/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedSet;
import java.util.zip.ZipFile;
import net.sf.hale.Game;
import net.sf.hale.resource.DirectoryResourcePackage;
import net.sf.hale.resource.PackageType;
import net.sf.hale.resource.ResourcePackage;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.resource.ZipResourcePackage;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;

public class ResourceManager {
    private static Map<String, String> cachedFiles = new HashMap<String, String>();
    private static List<ResourcePackage> packages = new ArrayList<ResourcePackage>(2);

    public static List<ResourcePackage> getPackages() {
        return packages;
    }

    public static void removeCampaignResource(String string) {
        for (ResourcePackage resourcePackage : packages) {
            if (resourcePackage.getType() != PackageType.Campaign) continue;
            resourcePackage.removeResource(string);
            break;
        }
    }

    public static void addCampaignResource(String string) {
        for (ResourcePackage resourcePackage : packages) {
            if (resourcePackage.getType() != PackageType.Campaign) continue;
            resourcePackage.addResource(string);
            break;
        }
    }

    public static String getResourceIDNoPath(String string, ResourceType resourceType) {
        if (!string.endsWith(resourceType.getExtension())) {
            return null;
        }
        String string2 = new File(string).getName();
        string2 = string2.substring(0, string2.length() - resourceType.getExtension().length());
        return string2;
    }

    public static String getResourceID(String string, ResourceType resourceType) {
        if (!string.endsWith(resourceType.getExtension())) {
            return null;
        }
        String string2 = string.substring(0, string.length() - resourceType.getExtension().length());
        return string2;
    }

    public static String getResourceID(String string, String string2, ResourceType resourceType) {
        if (!string.endsWith(resourceType.getExtension())) {
            return null;
        }
        String string3 = FileUtil.getRelativePath(string2, string);
        string3 = string3.substring(0, string3.length() - resourceType.getExtension().length());
        return string3;
    }

    public static void registerCampaignPackage() {
        String string = "campaigns/" + Game.curCampaign.getID();
        String string2 = string + ResourceType.Zip.getExtension();
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            ResourceManager.removePackageOfType(PackageType.Campaign);
            ResourceManager.registerPackage(file, PackageType.Campaign);
        } else {
            File file2 = new File(string2);
            if (file2.exists()) {
                ResourceManager.removePackageOfType(PackageType.Campaign);
                ResourceManager.registerPackage(file2, PackageType.Campaign);
            } else {
                throw new IllegalStateException("Package could not be found at " + string + " or " + string2);
            }
        }
        cachedFiles.clear();
    }

    public static void registerCorePackage() {
        File file;
        String string = "core";
        String string2 = string + ResourceType.Zip.getExtension();
        File file2 = new File(string);
        if (file2.exists() && file2.isDirectory()) {
            ResourceManager.removePackageOfType(PackageType.CoreDirectory);
            ResourceManager.registerPackage(file2, PackageType.CoreDirectory);
        }
        if ((file = new File(string2)).exists()) {
            ResourceManager.removePackageOfType(PackageType.CoreZip);
            ResourceManager.registerPackage(file, PackageType.CoreZip);
        }
        cachedFiles.clear();
    }

    private static void removePackageOfType(PackageType packageType) {
        Iterator<ResourcePackage> iterator = packages.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getType() != packageType) continue;
            iterator.remove();
        }
    }

    private static void registerPackage(File file, PackageType packageType) {
        if (file.isDirectory()) {
            packages.add(new DirectoryResourcePackage(file, packageType));
        } else if (file.isFile()) {
            try {
                packages.add(new ZipResourcePackage(new ZipFile(file), packageType));
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error reading package from " + file.getName(), exception);
            }
        }
        Collections.sort(packages);
    }

    public static Set<String> getResourcesInDirectory(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ResourcePackage resourcePackage : packages) {
            SortedSet<String> sortedSet = resourcePackage.getResourcesIn(string);
            if (sortedSet == null) continue;
            linkedHashSet.addAll(sortedSet);
        }
        return linkedHashSet;
    }

    public static Set<String> getCoreResourcesInDirectory(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        block3: for (ResourcePackage resourcePackage : packages) {
            switch (resourcePackage.getType()) {
                case CoreZip: 
                case CoreDirectory: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            SortedSet<String> sortedSet = resourcePackage.getResourcesIn(string);
            if (sortedSet == null) continue;
            linkedHashSet.addAll(sortedSet);
        }
        return linkedHashSet;
    }

    public static boolean hasResource(String string) {
        for (ResourcePackage resourcePackage : packages) {
            if (!resourcePackage.hasResource(string)) continue;
            return true;
        }
        return false;
    }

    public static Scanner getScanner(String string) {
        return new Scanner(ResourceManager.getStream(string));
    }

    public static Scanner getScanner(String string, ResourceType resourceType) {
        return new Scanner(ResourceManager.getStream(string + resourceType.getExtension()));
    }

    public static InputStream getStream(String string, ResourceType resourceType) {
        return ResourceManager.getStream(string + resourceType.getExtension());
    }

    public static InputStream getStream(String string) {
        for (ResourcePackage resourcePackage : packages) {
            if (!resourcePackage.hasResource(string)) continue;
            return resourcePackage.getStream(string);
        }
        return null;
    }

    public static Reader getReader(String string) {
        return new InputStreamReader(ResourceManager.getStream(string));
    }

    public static Reader getReader(String string, ResourceType resourceType) {
        return new InputStreamReader(ResourceManager.getStream(string, resourceType));
    }

    public static String getPackageIDOfResource(String string) {
        for (ResourcePackage resourcePackage : packages) {
            if (!resourcePackage.hasResource(string)) continue;
            return resourcePackage.getType().toString();
        }
        return null;
    }

    public static PackageType getPackageTypeOfResource(String string) {
        for (ResourcePackage resourcePackage : packages) {
            if (!resourcePackage.hasResource(string)) continue;
            return resourcePackage.getType();
        }
        return null;
    }

    public static String getScriptResourceAsString(String string) {
        return ResourceManager.getResourceAsString("scripts/" + string + ResourceType.JavaScript.getExtension());
    }

    public static String getResourceAsString(String string, ResourceType resourceType) {
        return ResourceManager.getResourceAsString(string + resourceType.getExtension());
    }

    public static String getResourceAsString(String string) {
        if (cachedFiles.containsKey(string)) {
            return cachedFiles.get(string);
        }
        InputStream inputStream = ResourceManager.getStream(string);
        if (inputStream == null) {
            cachedFiles.put(string, null);
            return null;
        }
        String string2 = ResourceManager.getResourceAsString(inputStream);
        cachedFiles.put(string, string2);
        return string2;
    }

    public static String getCoreResourceAsString(String string) {
        InputStream inputStream = null;
        block3: for (ResourcePackage resourcePackage : packages) {
            switch (resourcePackage.getType()) {
                case CoreZip: 
                case CoreDirectory: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (!resourcePackage.hasResource(string)) continue;
            inputStream = resourcePackage.getStream(string);
            break;
        }
        if (inputStream != null) {
            return ResourceManager.getResourceAsString(inputStream);
        }
        return null;
    }

    public static String getResourceAsString(InputStream inputStream) {
        char[] cArray = new char[65536];
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            int n;
            do {
                if ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) <= 0) continue;
                stringBuilder.append(cArray, 0, n);
            } while (n >= 0);
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error reading resource as string from stream.", iOException);
        }
        return stringBuilder.toString();
    }
}

