/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sf.hale.resource.PackageType;
import net.sf.hale.resource.ResourcePackage;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;

public class DirectoryResourcePackage
extends ResourcePackage {
    private final File root;

    public DirectoryResourcePackage(File file, PackageType packageType) {
        super(packageType);
        this.root = file;
        for (File file2 : FileUtil.getFiles(file)) {
            if (file2.isDirectory() || file2.getPath().contains(".svn")) continue;
            this.entries.add(FileUtil.getRelativePath(file, file2));
        }
    }

    @Override
    public InputStream getStream(String string) {
        File file = new File(this.root.getPath() + "/" + string);
        try {
            return new FileInputStream(file);
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error getting resource stream from " + string, exception);
            return null;
        }
    }
}

