/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.quickbar;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.Keybindings;
import net.sf.hale.entity.PC;
import net.sf.hale.quickbar.Quickbar;
import net.sf.hale.quickbar.QuickbarPopup;
import net.sf.hale.quickbar.QuickbarSlot;
import net.sf.hale.quickbar.QuickbarSlotButton;
import net.sf.hale.widgets.HotKeyButton;

public class QuickbarViewer
extends DialogLayout {
    private Quickbar quickbar;
    private List<QuickbarSlotButton> buttons;
    private Button scrollUp;
    private Button scrollDown;
    private Label currentIndexLabel = new Label();
    private int currentIndex;
    private HotKeyButton expand;

    public QuickbarViewer() {
        this.currentIndexLabel.setTheme("currentindexlabel");
        this.scrollUp = new Button();
        this.scrollUp.setTheme("incrementbutton");
        this.scrollUp.addCallback(new Runnable(){

            @Override
            public void run() {
                int n = QuickbarViewer.this.getIndexWrapAround(QuickbarViewer.this.currentIndex - 1);
                if (QuickbarViewer.this.quickbar != null) {
                    QuickbarViewer.this.quickbar.setLastViewSetIndex(n);
                }
                QuickbarViewer.this.setCurrentIndex(n);
                QuickbarViewer.this.setQuickbar(QuickbarViewer.this.quickbar);
            }
        });
        this.scrollDown = new Button();
        this.scrollDown.setTheme("decrementbutton");
        this.scrollDown.addCallback(new Runnable(){

            @Override
            public void run() {
                int n = QuickbarViewer.this.getIndexWrapAround(QuickbarViewer.this.currentIndex + 1);
                if (QuickbarViewer.this.quickbar != null) {
                    QuickbarViewer.this.quickbar.setLastViewSetIndex(n);
                }
                QuickbarViewer.this.setCurrentIndex(n);
                QuickbarViewer.this.setQuickbar(QuickbarViewer.this.quickbar);
            }
        });
        DialogLayout.Group group = this.createParallelGroup(new Widget[]{this.scrollUp, this.scrollDown});
        DialogLayout.Group group2 = this.createSequentialGroup(new Widget[]{this.scrollUp, this.scrollDown});
        DialogLayout.Group group3 = this.createSequentialGroup(new Widget[]{this.currentIndexLabel});
        DialogLayout.Group group4 = this.createParallelGroup(new Widget[]{this.currentIndexLabel});
        group3.addGroup(group);
        group4.addGroup(group2);
        this.buttons = new ArrayList<QuickbarSlotButton>(10);
        for (int i = 0; i < 10; ++i) {
            QuickbarSlotButton quickbarSlotButton = new QuickbarSlotButton(i, this);
            this.buttons.add(quickbarSlotButton);
            group3.addWidget((Widget)quickbarSlotButton);
            group4.addWidget((Widget)quickbarSlotButton);
        }
        this.expand = new HotKeyButton();
        this.expand.setTheme("expandbutton");
        this.expand.setHotKeyBinding(new Keybindings.ToggleQuickbarPopup());
        group3.addWidget((Widget)this.expand);
        group4.addWidget((Widget)this.expand);
        this.setHorizontalGroup(group3);
        this.setVerticalGroup(group4);
        this.setCurrentIndex(1);
        this.setQuickbar(this.quickbar);
    }

    public void showQuickbarPopup() {
        QuickbarPopup quickbarPopup = new QuickbarPopup((Widget)Game.mainViewer, this);
        quickbarPopup.openPopup();
    }

    private int getIndexWrapAround(int n) {
        if (n >= 5) {
            return 0;
        }
        if (n < 0) {
            return 4;
        }
        return n;
    }

    private void setCurrentIndex(int n) {
        if (n == this.currentIndex) {
            return;
        }
        this.currentIndex = n;
        this.currentIndexLabel.setText(Integer.toString(this.currentIndex));
    }

    public void setQuickbar(Quickbar quickbar) {
        this.quickbar = quickbar;
        if (quickbar == null) {
            for (QuickbarSlotButton quickbarSlotButton : this.buttons) {
                quickbarSlotButton.setSlot(null, null, 0);
            }
        } else {
            int n = this.currentIndex * 10;
            int n2 = 0;
            for (int i = n; i < n + 10; ++i) {
                QuickbarSlot quickbarSlot = quickbar.getSlot(i);
                this.buttons.get(n2).setSlot(quickbarSlot, quickbar, i);
                ++n2;
            }
        }
    }

    public int getSlotIndex(QuickbarSlotButton quickbarSlotButton) {
        if (!this.buttons.contains(quickbarSlotButton)) {
            return -1;
        }
        return quickbarSlotButton.getIndex() + this.currentIndex * 10;
    }

    public int findSlotIndexUnderMouse(int n, int n2) {
        for (QuickbarSlotButton quickbarSlotButton : this.buttons) {
            if (!quickbarSlotButton.isInside(n, n2)) continue;
            return quickbarSlotButton.getIndex() + this.currentIndex * 10;
        }
        return -1;
    }

    public QuickbarSlotButton getButton(int n) {
        int n2 = n - this.currentIndex * 10;
        if (n2 < 0 || n2 >= 10) {
            return null;
        }
        return this.buttons.get(n2);
    }

    public QuickbarSlotButton getButtonAtViewIndex(int n) {
        return this.buttons.get(n);
    }

    public Quickbar getQuickbar() {
        return this.quickbar;
    }

    public void updateContent(PC pC) {
        if (pC != null) {
            int n;
            Quickbar quickbar = pC.quickbar;
            if (quickbar != null && (n = quickbar.getLastViewSetIndex()) != this.currentIndex) {
                this.setCurrentIndex(n);
            }
            this.setQuickbar(quickbar);
        }
    }
}

