/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.quickbar;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.quickbar.Quickbar;
import net.sf.hale.quickbar.QuickbarSlot;
import net.sf.hale.quickbar.QuickbarViewer;
import net.sf.hale.view.DragTarget;
import net.sf.hale.view.DropTarget;

public class QuickbarSlotButton
extends Button
implements DropTarget {
    private QuickbarViewer viewer;
    private QuickbarSlot slot;
    private Quickbar quickbar;
    private int quickbarIndex;
    private Icon overrideIcon;
    private Icon icon;
    private Icon secondaryIcon;
    private int index;
    private Label primaryLabel;
    private Label indexLabel;
    private String emptyTooltip;
    private QuickbarSlot dragSlotToAdd;
    private boolean disabledExceptActivate;

    public QuickbarSlotButton(int n, QuickbarViewer quickbarViewer) {
        this.viewer = quickbarViewer;
        this.index = n;
        int n2 = n % 10;
        int n3 = Game.config.getKeyForAction("UseQuickbarSlot" + Integer.toString(n2));
        if (n3 != -1) {
            String string = Event.getKeyNameForCode((int)n3);
            this.indexLabel = new Label(string);
        } else {
            this.indexLabel = new Label();
        }
        this.indexLabel.setTheme("indexlabel");
        this.add((Widget)this.indexLabel);
        this.primaryLabel = new Label();
        this.primaryLabel.setTheme("primarylabel");
        this.add((Widget)this.primaryLabel);
        this.icon = IconFactory.emptyIcon;
    }

    public void setShowIndexLabel(boolean bl) {
        this.indexLabel.setVisible(bl);
    }

    public void setDisabledExceptActivate(boolean bl) {
        this.disabledExceptActivate = bl;
    }

    protected void layout() {
        super.layout();
        this.indexLabel.setPosition(this.getInnerRight() - this.indexLabel.getPreferredWidth(), this.getInnerY() + this.indexLabel.getPreferredHeight() / 2);
        this.primaryLabel.setPosition(this.getInnerX(), this.getInnerBottom() - this.primaryLabel.getPreferredHeight() / 2);
    }

    public void setOverrideIcon(Icon icon) {
        this.overrideIcon = icon;
    }

    public void clearOverrideIcon() {
        this.overrideIcon = null;
    }

    public void setSlot(QuickbarSlot quickbarSlot, Quickbar quickbar, int n) {
        this.slot = quickbarSlot;
        this.quickbar = quickbar;
        this.quickbarIndex = n;
        if (quickbarSlot == null) {
            if (this.getTooltipContent() != this.emptyTooltip) {
                this.setTooltipContent(this.emptyTooltip);
            }
            this.icon = IconFactory.emptyIcon;
            this.primaryLabel.setText("");
            this.secondaryIcon = null;
        } else {
            if (quickbarSlot.isActivateable()) {
                this.icon = quickbarSlot.getIcon();
                this.secondaryIcon = quickbarSlot.getSecondaryIcon();
            } else {
                this.icon = quickbarSlot.getIcon().multiplyByColor(new Color(-8421505));
                if (quickbarSlot.getSecondaryIcon() != null) {
                    this.secondaryIcon = quickbarSlot.getSecondaryIcon().multiplyByColor(new Color(-8421505));
                }
            }
            this.primaryLabel.setText(quickbarSlot.getLabelText());
            String string = quickbarSlot.getTooltipText();
            if (!string.equals(this.getTooltipContent())) {
                this.setTooltipContent(string);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean handleEvent(Event event) {
        if (Game.interfaceLocker.locked()) {
            return super.handleEvent(event);
        }
        switch (event.getType()) {
            case MOUSE_DRAGGED: 
            case MOUSE_BTNUP: {
                if (!this.isMouseInside(event)) {
                    return super.handleEvent(event);
                }
                switch (event.getMouseButton()) {
                    case 0: {
                        this.activateSlot(this.getRight(), this.getY());
                        return super.handleEvent(event);
                    }
                    case 1: {
                        if (this.disabledExceptActivate) return super.handleEvent(event);
                        this.createRightClickMenu(this.getRight(), this.getY());
                    }
                }
                return super.handleEvent(event);
            }
        }
        return super.handleEvent(event);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.emptyTooltip = themeInfo.getParameter("emptytooltip", (String)null);
    }

    public void paintWidget(GUI gUI) {
        super.paintWidget(gUI);
        if (this.overrideIcon != null) {
            this.overrideIcon.drawCentered(this.getInnerX(), this.getInnerY(), this.getInnerWidth(), this.getInnerHeight());
        } else if (this.secondaryIcon != null) {
            this.secondaryIcon.drawCentered(this.getInnerX() + 5, this.getInnerY(), this.getInnerWidth(), this.getInnerHeight());
            this.icon.drawCentered(this.getInnerX() - 5, this.getInnerY(), this.getInnerWidth(), this.getInnerHeight());
        } else {
            this.icon.drawCentered(this.getInnerX(), this.getInnerY(), this.getInnerWidth(), this.getInnerHeight());
        }
    }

    public void activateSlot(int n, int n2) {
        if (this.slot == null) {
            return;
        }
        Game.mainViewer.getMenu().clear();
        Game.mainViewer.getMenu().setPosition(n, n2);
        this.slot.activate(this);
    }

    public void createRightClickMenu(int n, int n2) {
        if (this.slot == null) {
            return;
        }
        Game.mainViewer.getMenu().clear();
        Game.mainViewer.getMenu().setPosition(n, n2);
        this.slot.createRightClickMenu(this);
    }

    public Runnable getActivateSlotCallback(QuickbarSlot quickbarSlot) {
        return new ActivateSlotCallback(quickbarSlot);
    }

    public Runnable getClearSlotCallback() {
        return new ClearSlotCallback(this);
    }

    @Override
    public void dragAndDropStartHover(DragTarget dragTarget) {
        this.dragSlotToAdd = dragTarget.getItem() != null && dragTarget.getParentPC() == this.quickbar.getParent() ? Quickbar.getQuickbarSlot(dragTarget.getItem(), dragTarget.getParentPC()) : (dragTarget.getAbility() != null && dragTarget.getParentPC() == this.quickbar.getParent() ? Quickbar.getQuickbarSlot(dragTarget.getAbility(), dragTarget.getParentPC()) : null);
        if (this.dragSlotToAdd != null) {
            this.setOverrideIcon(dragTarget.getDragIcon().multiplyByColor(new Color(-11184811)));
        }
    }

    @Override
    public void dragAndDropStopHover(DragTarget dragTarget) {
        this.clearOverrideIcon();
    }

    @Override
    public void dropDragTarget(DragTarget dragTarget) {
        this.clearOverrideIcon();
        int n = this.viewer.getSlotIndex(this);
        if (this.dragSlotToAdd != null) {
            this.quickbar.setSlot(this.dragSlotToAdd, n);
            Game.mainViewer.updateInterface();
        }
    }

    private class ActivateSlotCallback
    implements Runnable {
        private QuickbarSlot slot;

        public ActivateSlotCallback(QuickbarSlot quickbarSlot) {
            this.slot = quickbarSlot;
        }

        @Override
        public void run() {
            Game.mainViewer.getMenu().hide();
            this.slot.activate(QuickbarSlotButton.this);
        }
    }

    private static class ClearSlotCallback
    implements Runnable {
        private QuickbarSlotButton button;

        public ClearSlotCallback(QuickbarSlotButton quickbarSlotButton) {
            this.button = quickbarSlotButton;
        }

        @Override
        public void run() {
            this.button.quickbar.setSlot(null, this.button.quickbarIndex);
            this.button.setSlot(null, this.button.quickbar, this.button.quickbarIndex);
            Game.mainViewer.getMenu().hide();
        }
    }
}

