/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.quickbar;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.quickbar.Quickbar;
import net.sf.hale.quickbar.QuickbarSlotButton;
import net.sf.hale.quickbar.QuickbarViewer;

public class QuickbarPopup
extends PopupWindow {
    private QuickbarViewer quickbarViewer;

    public QuickbarPopup(Widget widget, QuickbarViewer quickbarViewer) {
        super(widget);
        this.setCloseOnEscape(true);
        this.setCloseOnClickedOutside(true);
        this.add((Widget)new Content());
        this.quickbarViewer = quickbarViewer;
    }

    public void layout() {
        this.setSize(this.getPreferredWidth(), this.getPreferredHeight());
        Widget widget = this.getChild(0);
        widget.setSize(widget.getPreferredWidth(), widget.getPreferredHeight());
        this.setPosition(this.quickbarViewer.getButtonAtViewIndex(0).getX() - this.getBorderLeft() - this.getChild(0).getBorderLeft(), this.getParent().getBottom() - this.getHeight());
    }

    private class Content
    extends DialogLayout {
        private Content() {
            Quickbar quickbar = Game.curCampaign.party.getSelected().quickbar;
            DialogLayout.Group group = this.createParallelGroup();
            DialogLayout.Group group2 = this.createSequentialGroup();
            for (int i = 0; i < 5; ++i) {
                DialogLayout.Group group3 = this.createSequentialGroup();
                DialogLayout.Group group4 = this.createParallelGroup();
                for (int j = 0; j < 10; ++j) {
                    int n = i * 10 + j;
                    QuickbarSlotButton quickbarSlotButton = new QuickbarSlotButton(n, QuickbarPopup.this.quickbarViewer);
                    quickbarSlotButton.setSlot(quickbar.getSlot(n), quickbar, n);
                    quickbarSlotButton.setShowIndexLabel(false);
                    quickbarSlotButton.setDisabledExceptActivate(true);
                    quickbarSlotButton.addCallback(new Runnable(){

                        @Override
                        public void run() {
                            QuickbarPopup.this.closePopup();
                        }
                    });
                    group3.addWidget((Widget)quickbarSlotButton);
                    group4.addWidget((Widget)quickbarSlotButton);
                }
                group.addGroup(group3);
                group2.addGroup(group4);
            }
            this.setHorizontalGroup(group);
            this.setVerticalGroup(group2);
        }

        protected boolean handleEvent(Event event) {
            if (event.getType() == Event.Type.KEY_PRESSED && Game.mainViewer.getKeyBindings().isCloseQuickbarPopupKey(event.getKeyCode())) {
                QuickbarPopup.this.closePopup();
            }
            return super.handleEvent(event);
        }
    }
}

