/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.quickbar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.PC;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.quickbar.AbilityActivateSlot;
import net.sf.hale.quickbar.ItemEquipSlot;
import net.sf.hale.quickbar.ItemUseSlot;
import net.sf.hale.quickbar.QuickbarSlot;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONObject;

public class Quickbar
implements Saveable {
    public static final int TotalSlots = 50;
    public static final int SlotsAtOnce = 10;
    public static final int SetsOfSlots = 5;
    private int lastViewSet;
    private Map<Integer, QuickbarSlot> slots = new HashMap<Integer, QuickbarSlot>();
    private PC parent;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("lastViewSet", this.lastViewSet);
        JSONOrderedObject jSONOrderedObject2 = new JSONOrderedObject();
        for (Integer n : this.slots.keySet()) {
            QuickbarSlot quickbarSlot = this.slots.get(n);
            if (quickbarSlot == null) continue;
            jSONOrderedObject2.put("slot" + n.toString(), quickbarSlot.save());
        }
        jSONOrderedObject.put("slots", jSONOrderedObject2);
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject) {
        this.clear();
        this.lastViewSet = simpleJSONObject.containsKey("lastViewerSet") ? simpleJSONObject.get("lastViewSet", 0) : 0;
        SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject("slots");
        for (String string : simpleJSONObject2.keySet()) {
            Comparable<ItemList.Entry> comparable;
            Object object;
            String string2;
            int n = Integer.parseInt(string.substring(4, string.length()));
            SimpleJSONObject simpleJSONObject3 = simpleJSONObject2.getObject(string);
            String string3 = simpleJSONObject3.get("type", null);
            if (string3.equals("ability")) {
                string2 = simpleJSONObject3.get("abilityID", null);
                object = new AbilityActivateSlot(Game.ruleset.getAbility(string2), this.parent);
                this.putSlot(n, (QuickbarSlot)object);
                continue;
            }
            if (string3.equals("use")) {
                string2 = simpleJSONObject3.get("itemID", null);
                object = null;
                if (simpleJSONObject3.containsKey("itemQuality")) {
                    object = simpleJSONObject3.get("itemQuality", null);
                }
                if ((comparable = this.parent.inventory.getUnequippedItems().find(string2, (String)object)) != null) {
                    this.putSlot(n, new ItemUseSlot((ItemList.Entry)comparable, this.parent));
                    continue;
                }
                Logger.appendToWarningLog("Warning, unable to find item in quickbar slot " + n + " for " + this.parent.getTemplate().getID());
                continue;
            }
            if (!string3.equals("equip")) continue;
            string2 = simpleJSONObject3.get("itemID", null);
            object = null;
            if (simpleJSONObject3.containsKey("itemQuality")) {
                object = simpleJSONObject3.get("itemQuality", null);
            }
            try {
                comparable = EntityManager.getItem(string2, (String)object);
                ItemEquipSlot itemEquipSlot = new ItemEquipSlot((EquippableItem)comparable, this.parent);
                if (simpleJSONObject3.containsKey("secondaryItemID")) {
                    String string4 = simpleJSONObject3.get("secondaryItemID", null);
                    String string5 = null;
                    if (simpleJSONObject3.containsKey("secondaryItemQuality")) {
                        string5 = simpleJSONObject3.get("secondaryItemQuality", null);
                    }
                    Item item = EntityManager.getItem(string4, string5);
                    itemEquipSlot.setSecondaryItem((EquippableItem)item);
                }
                this.putSlot(n, itemEquipSlot);
            }
            catch (Exception exception) {
                Logger.appendToWarningLog("Warning, unable to load item(s) in quickbar slot " + n);
            }
        }
    }

    public Quickbar(Quickbar quickbar, PC pC) {
        for (Integer n : quickbar.slots.keySet()) {
            QuickbarSlot quickbarSlot = quickbar.slots.get(n);
            if (quickbarSlot == null) continue;
            this.putSlot(n, quickbarSlot.getCopy(pC));
        }
        this.lastViewSet = quickbar.lastViewSet;
        this.parent = pC;
    }

    public Quickbar(PC pC) {
        this.lastViewSet = 0;
        this.parent = pC;
    }

    public void clear() {
        this.slots.clear();
        this.lastViewSet = 0;
    }

    public QuickbarSlot getSlot(int n) {
        if (n >= 50 || n < 0) {
            return null;
        }
        return this.slots.get(n);
    }

    public PC getParent() {
        return this.parent;
    }

    public void setSlot(QuickbarSlot quickbarSlot, int n) {
        QuickbarSlot quickbarSlot2 = this.slots.get(n);
        if (quickbarSlot2 instanceof ItemEquipSlot && quickbarSlot instanceof ItemEquipSlot && ((ItemEquipSlot)quickbarSlot2).setSecondaryItem(((ItemEquipSlot)quickbarSlot).getItem())) {
            return;
        }
        this.putSlot(n, quickbarSlot);
    }

    public void addToFirstEmptySlot(String string, String string2) {
        this.addToFirstEmptySlot(Quickbar.getQuickbarSlot(EntityManager.getItem(string, string2), this.parent));
    }

    public void addToFirstEmptySlot(String string) {
        this.addToFirstEmptySlot(Quickbar.getQuickbarSlot(EntityManager.getItem(string), this.parent));
    }

    public void addToFirstEmptySlot(Item item) {
        this.addToFirstEmptySlot(Quickbar.getQuickbarSlot(item, this.parent));
    }

    public void addToFirstEmptySlot(Ability ability) {
        this.addToFirstEmptySlot(Quickbar.getQuickbarSlot(ability, this.parent));
    }

    private void addToFirstEmptySlot(QuickbarSlot quickbarSlot) {
        if (quickbarSlot == null) {
            return;
        }
        for (int i = 0; i < 50; ++i) {
            if (this.getSlot(i) != null) continue;
            this.setSlot(quickbarSlot, i);
            break;
        }
        Game.mainViewer.updateInterface();
    }

    public void setLastViewSetIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= 5) {
            n = 4;
        }
        this.lastViewSet = n;
    }

    public int getLastViewSetIndex() {
        return this.lastViewSet;
    }

    public void addAbilitiesToEmptySlots() {
        List<Ability> list = this.parent.abilities.getActivateableAbilities();
        Iterator<Ability> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        for (int i = 0; i < 50; ++i) {
            if (this.getSlot(i) != null) continue;
            QuickbarSlot quickbarSlot = Quickbar.getQuickbarSlot(iterator.next(), this.parent);
            this.setSlot(quickbarSlot, i);
            if (iterator.hasNext()) continue;
            return;
        }
    }

    private void putSlot(int n, QuickbarSlot quickbarSlot) {
        if (quickbarSlot != null) {
            quickbarSlot.setIndex(n);
        }
        this.slots.put(n, quickbarSlot);
    }

    public static QuickbarSlot getQuickbarSlot(Item item, PC pC) {
        ItemList.Entry entry;
        if (item instanceof EquippableItem) {
            return new ItemEquipSlot((EquippableItem)item, pC);
        }
        if (item.getTemplate().isUsable() && (entry = pC.inventory.getUnequippedItems().find(item.getTemplate().getID(), item.getQuality())) != null) {
            return new ItemUseSlot(entry, pC);
        }
        return null;
    }

    public static QuickbarSlot getQuickbarSlot(Ability ability, PC pC) {
        return new AbilityActivateSlot(ability, pC);
    }
}

