/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.quickbar;

import de.matthiasmann.twl.Button;
import net.sf.hale.Game;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.PC;
import net.sf.hale.icon.Icon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.quickbar.QuickbarSlot;
import net.sf.hale.quickbar.QuickbarSlotButton;
import net.sf.hale.rules.Quality;
import net.sf.hale.widgets.RightClickMenu;

public class ItemUseSlot
extends QuickbarSlot
implements ItemList.Listener {
    private Item item;
    private ItemList.Entry entry;
    private PC parent;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("type", "use");
        jSONOrderedObject.put("itemID", this.item.getTemplate().getID());
        if (this.item.getTemplate().hasQuality()) {
            jSONOrderedObject.put("itemQuality", this.item.getQuality().getName());
        }
        return jSONOrderedObject;
    }

    public ItemUseSlot(ItemList.Entry entry, PC pC) {
        this.entry = entry;
        this.parent = pC;
        this.item = entry.createItem();
        pC.inventory.getUnequippedItems().addListener(this);
    }

    @Override
    public Icon getIcon() {
        return this.item.getTemplate().getIcon();
    }

    @Override
    public String getLabelText() {
        return Integer.toString(this.entry.getQuantity());
    }

    @Override
    public boolean isChildActivateable() {
        return this.parent.timer.canPerformAction(this.item.getTemplate().getUseAP());
    }

    @Override
    public void childActivate(QuickbarSlotButton quickbarSlotButton) {
        if (this.item.canUse(this.parent) && this.entry.getQuantity() > 0) {
            this.item.getUseCallback(this.parent).run();
        }
        if (this.entry.getQuantity() == 0) {
            quickbarSlotButton.getClearSlotCallback().run();
        } else {
            this.item = this.entry.createItem();
        }
    }

    @Override
    public void createRightClickMenu(QuickbarSlotButton quickbarSlotButton) {
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        rightClickMenu.addMenuLevel(this.item.getTemplate().getName());
        Button button = new Button(this.item.getTemplate().getUseText());
        button.setEnabled(this.isActivateable());
        button.addCallback(quickbarSlotButton.getActivateSlotCallback(this));
        rightClickMenu.addButton(button);
        Button button2 = new Button("View Details");
        button2.addCallback(this.item.getExamineDetailsCallback(rightClickMenu.getX(), rightClickMenu.getY()));
        rightClickMenu.addButton(button2);
        Button button3 = new Button("Clear Slot");
        button3.addCallback(quickbarSlotButton.getClearSlotCallback());
        rightClickMenu.addButton(button3);
        rightClickMenu.show();
        if (rightClickMenu.shouldPopupToggle()) {
            rightClickMenu.togglePopup();
        }
    }

    @Override
    public String getTooltipText() {
        return "Use " + this.item.getLongName();
    }

    @Override
    public Icon getSecondaryIcon() {
        return null;
    }

    @Override
    public String getSaveDescription() {
        return "Use \"" + this.item.getTemplate().getID() + "\" \"" + this.item.getQuality().getName() + "\"";
    }

    @Override
    public QuickbarSlot getCopy(PC pC) {
        return new ItemUseSlot(this.entry, pC);
    }

    @Override
    public void itemListItemAdded(String string, Quality quality, int n) {
    }

    @Override
    public boolean itemListEntryRemoved(ItemList.Entry entry) {
        if (entry == this.entry) {
            this.parent.quickbar.setSlot(null, this.getIndex());
            Game.mainViewer.updateInterface();
            return true;
        }
        return false;
    }
}

