/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.quickbar;

import de.matthiasmann.twl.Button;
import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Weapon;
import net.sf.hale.entity.WeaponTemplate;
import net.sf.hale.icon.Icon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.quickbar.QuickbarSlot;
import net.sf.hale.quickbar.QuickbarSlotButton;
import net.sf.hale.widgets.RightClickMenu;

public class ItemEquipSlot
extends QuickbarSlot {
    private EquippableItem item;
    private EquippableItem secondaryItem;
    private PC parent;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("type", "equip");
        jSONOrderedObject.put("itemID", this.item.getTemplate().getID());
        if (this.item.getTemplate().hasQuality()) {
            jSONOrderedObject.put("itemQuality", this.item.getQuality().getName());
        }
        if (this.secondaryItem != null) {
            jSONOrderedObject.put("secondaryItemID", this.secondaryItem.getTemplate().getID());
            if (this.secondaryItem.getTemplate().hasQuality()) {
                jSONOrderedObject.put("secondaryItemQuality", this.secondaryItem.getQuality().getName());
            }
        }
        return jSONOrderedObject;
    }

    public ItemEquipSlot(EquippableItem equippableItem, PC pC) {
        this.item = equippableItem;
        this.parent = pC;
    }

    public EquippableItem getItem() {
        return this.item;
    }

    public boolean setSecondaryItem(EquippableItem equippableItem) {
        if (equippableItem == null) {
            return false;
        }
        if (this.secondaryItem != null) {
            return false;
        }
        if (!this.item.getTemplate().hasPrereqsToEquip(this.parent)) {
            return false;
        }
        if (!equippableItem.getTemplate().hasPrereqsToEquip(this.parent)) {
            return false;
        }
        if (!this.parent.inventory.hasBoth(this.item, equippableItem)) {
            return false;
        }
        switch (this.item.getTemplate().getType()) {
            case Weapon: {
                switch (equippableItem.getTemplate().getType()) {
                    case Weapon: {
                        return this.checkWeaponWeapon((Weapon)this.item, (Weapon)equippableItem);
                    }
                    case Shield: {
                        return this.checkWeaponShield((Weapon)this.item, (Armor)equippableItem);
                    }
                }
            }
            case Shield: {
                switch (equippableItem.getTemplate().getType()) {
                    case Weapon: {
                        return this.checkWeaponShield((Weapon)equippableItem, (Armor)this.item);
                    }
                }
            }
        }
        return false;
    }

    private boolean checkWeaponWeapon(Weapon weapon, Weapon weapon2) {
        if (!weapon.isMelee() || !weapon2.isMelee()) {
            return false;
        }
        if (!this.parent.stats.has(Bonus.Type.DualWieldTraining)) {
            return false;
        }
        if (weapon.getTemplate().getHanded() == WeaponTemplate.Handed.TwoHanded) {
            return false;
        }
        if (weapon2.getTemplate().getHanded() == WeaponTemplate.Handed.TwoHanded) {
            return false;
        }
        this.item = weapon;
        this.secondaryItem = weapon2;
        return true;
    }

    private boolean checkWeaponShield(Weapon weapon, Armor armor) {
        if (weapon.getTemplate().getHanded() == WeaponTemplate.Handed.TwoHanded) {
            return false;
        }
        this.item = weapon;
        this.secondaryItem = armor;
        return true;
    }

    @Override
    public Icon getIcon() {
        return this.item.getTemplate().getIcon();
    }

    @Override
    public String getLabelText() {
        switch (this.item.getTemplate().getType()) {
            case Ammo: {
                return Integer.toString(this.parent.inventory.getTotalQuantity(this.item));
            }
        }
        return "";
    }

    @Override
    public boolean isChildActivateable() {
        if (this.parent.inventory.isEquipped(this.item) && !this.item.getTemplate().isUnequippable()) {
            return false;
        }
        if (this.secondaryItem != null && this.parent.inventory.isEquipped(this.secondaryItem) && !this.secondaryItem.getTemplate().isUnequippable()) {
            return false;
        }
        return this.parent.inventory.canEquip(this.item, null);
    }

    @Override
    public void childActivate(QuickbarSlotButton quickbarSlotButton) {
        if (!this.parent.inventory.canEquip(this.item, null)) {
            return;
        }
        if (this.secondaryItem != null) {
            if (!this.parent.inventory.hasBoth(this.item, this.secondaryItem)) {
                return;
            }
            if (this.parent.inventory.isEquipped(this.item)) {
                this.parent.inventory.getUnequipCallback(this.parent.inventory.getSlot(this.item)).run();
                if (this.parent.inventory.isEquipped(this.secondaryItem)) {
                    this.parent.timer.setFreeMode(true);
                    this.parent.inventory.getUnequipCallback(this.parent.inventory.getSlot(this.secondaryItem)).run();
                    this.parent.timer.setFreeMode(false);
                }
            } else {
                this.parent.inventory.equipItem(this.item, null);
                if (!this.parent.inventory.isEquipped(this.secondaryItem)) {
                    this.parent.timer.setFreeMode(true);
                    this.parent.inventory.equipItem(this.secondaryItem, null);
                    this.parent.timer.setFreeMode(false);
                }
            }
        } else {
            Inventory.Slot slot = this.parent.inventory.getSlot(this.item);
            if (slot != null) {
                this.parent.inventory.getUnequipCallback(slot).run();
            } else if (this.parent.inventory.getUnequippedItems().contains(this.item)) {
                this.parent.inventory.getEquipCallback(this.item, null).run();
            }
        }
    }

    @Override
    public void createRightClickMenu(QuickbarSlotButton quickbarSlotButton) {
        Button button;
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        String string = this.item.getTemplate().getName();
        if (this.secondaryItem != null) {
            string = string + " and " + this.secondaryItem.getTemplate().getName();
        }
        rightClickMenu.addMenuLevel(string);
        String string2 = null;
        String string3 = null;
        if (this.parent.inventory.isEquipped(this.item)) {
            string3 = "Unequip";
            string2 = !this.item.getTemplate().isUnequippable() ? "Item is conjured and cannot be removed." : "Not enough AP to unequip";
        } else {
            string3 = "Equip";
            string2 = "Not enough AP to equip";
        }
        Button button2 = new Button(string3);
        button2.setEnabled(this.isActivateable());
        if (!button2.isEnabled()) {
            button2.setTooltipContent((Object)string2);
        }
        button2.addCallback(quickbarSlotButton.getActivateSlotCallback(this));
        rightClickMenu.addButton(button2);
        Button button3 = new Button(this.item.getTemplate().getName() + " Details");
        button3.addCallback(this.item.getExamineDetailsCallback(rightClickMenu.getX(), rightClickMenu.getY()));
        rightClickMenu.addButton(button3);
        if (this.secondaryItem != null) {
            button = new Button(this.secondaryItem.getTemplate().getName() + " Details");
            button.addCallback(this.secondaryItem.getExamineDetailsCallback(rightClickMenu.getX(), rightClickMenu.getY()));
            rightClickMenu.addButton(button);
        }
        button = new Button("Clear Slot");
        button.addCallback(quickbarSlotButton.getClearSlotCallback());
        rightClickMenu.addButton(button);
        rightClickMenu.show();
        if (rightClickMenu.shouldPopupToggle()) {
            rightClickMenu.togglePopup();
        }
    }

    @Override
    public String getTooltipText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Equip ");
        stringBuilder.append(this.item.getLongName());
        if (this.secondaryItem != null) {
            stringBuilder.append(" and ");
            stringBuilder.append(this.secondaryItem.getLongName());
        }
        return stringBuilder.toString();
    }

    @Override
    public Icon getSecondaryIcon() {
        if (this.secondaryItem != null) {
            return this.secondaryItem.getTemplate().getIcon();
        }
        return null;
    }

    @Override
    public String getSaveDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Equip ");
        stringBuilder.append("\"");
        stringBuilder.append(this.item.getTemplate().getID());
        stringBuilder.append("\" \"");
        stringBuilder.append(this.item.getQuality().getName());
        stringBuilder.append("\"");
        if (this.secondaryItem != null) {
            stringBuilder.append(" \"");
            stringBuilder.append(this.secondaryItem.getTemplate().getID());
            stringBuilder.append("\" \"");
            stringBuilder.append(this.secondaryItem.getQuality().getName());
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    @Override
    public QuickbarSlot getCopy(PC pC) {
        ItemEquipSlot itemEquipSlot = new ItemEquipSlot((EquippableItem)EntityManager.getItem(this.item.getTemplate().getID(), this.item.getQuality()), pC);
        if (this.secondaryItem != null) {
            itemEquipSlot.setSecondaryItem((EquippableItem)EntityManager.getItem(this.secondaryItem.getTemplate().getID(), this.secondaryItem.getQuality()));
        }
        return itemEquipSlot;
    }
}

