/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.quickbar;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Widget;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilityActivateCallback;
import net.sf.hale.ability.AbilityExamineCallback;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.entity.PC;
import net.sf.hale.icon.Icon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.quickbar.QuickbarSlot;
import net.sf.hale.quickbar.QuickbarSlotButton;
import net.sf.hale.widgets.RightClickMenu;

public class AbilityActivateSlot
extends QuickbarSlot {
    private final String abilityID;
    private final Icon abilityIcon;
    private final String abilityName;
    private PC parent;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("type", "ability");
        jSONOrderedObject.put("abilityID", this.abilityID);
        return jSONOrderedObject;
    }

    public AbilityActivateSlot(Ability ability, PC pC) {
        this.abilityID = ability.getID();
        this.abilityIcon = ability.getIcon();
        this.abilityName = ability.getName();
        this.parent = pC;
    }

    @Override
    public Icon getIcon() {
        return this.abilityIcon;
    }

    @Override
    public String getLabelText() {
        AbilitySlot abilitySlot = this.getBestSlot();
        if (abilitySlot != null) {
            return abilitySlot.getLabelText();
        }
        return "";
    }

    @Override
    public boolean isChildActivateable() {
        Ability ability = Game.ruleset.getAbility(this.abilityID);
        if (!Game.isInTurnMode() && !ability.canActivateOutsideCombat()) {
            return false;
        }
        if (!this.parent.timer.canPerformAction(ability.getAPCost())) {
            return false;
        }
        for (AbilitySlot abilitySlot : this.parent.abilities.getSlotsWithReadiedAbility(ability)) {
            if (abilitySlot.getCooldownRoundsLeft() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void childActivate(QuickbarSlotButton quickbarSlotButton) {
        AbilitySlot abilitySlot = this.getBestSlot();
        if (abilitySlot == null) {
            return;
        }
        if (abilitySlot.canActivate()) {
            new AbilityActivateCallback(abilitySlot, ScriptFunctionType.onActivate).run();
        } else if (abilitySlot.canDeactivate()) {
            new AbilityActivateCallback(abilitySlot, ScriptFunctionType.onDeactivate).run();
        }
    }

    @Override
    public void createRightClickMenu(QuickbarSlotButton quickbarSlotButton) {
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        rightClickMenu.addMenuLevel(this.abilityName);
        Button button = new Button("Activate");
        button.setEnabled(this.isActivateable());
        button.addCallback(quickbarSlotButton.getActivateSlotCallback(this));
        rightClickMenu.addButton(button);
        Button button2 = new Button("View Details");
        AbilityExamineCallback abilityExamineCallback = new AbilityExamineCallback(Game.ruleset.getAbility(this.abilityID), (Widget)quickbarSlotButton, this.parent);
        abilityExamineCallback.setWindowCenter(rightClickMenu.getX(), rightClickMenu.getY());
        button2.addCallback((Runnable)abilityExamineCallback);
        rightClickMenu.addButton(button2);
        Button button3 = new Button("Clear Slot");
        button3.addCallback(quickbarSlotButton.getClearSlotCallback());
        rightClickMenu.addButton(button3);
        rightClickMenu.show();
        if (rightClickMenu.shouldPopupToggle()) {
            rightClickMenu.togglePopup();
        }
    }

    private AbilitySlot getBestSlot() {
        Ability ability = Game.ruleset.getAbility(this.abilityID);
        List<AbilitySlot> list = this.parent.abilities.getSlotsWithReadiedAbility(ability);
        if (list.isEmpty()) {
            return null;
        }
        Iterator<AbilitySlot> iterator = list.iterator();
        AbilitySlot abilitySlot = iterator.next();
        while (iterator.hasNext()) {
            AbilitySlot abilitySlot2 = iterator.next();
            if (abilitySlot2.getCooldownRoundsLeft() >= abilitySlot.getCooldownRoundsLeft()) continue;
            abilitySlot = abilitySlot2;
        }
        return abilitySlot;
    }

    @Override
    public String getTooltipText() {
        return "Activate " + this.abilityName;
    }

    @Override
    public Icon getSecondaryIcon() {
        return null;
    }

    @Override
    public String getSaveDescription() {
        return "Ability \"" + this.abilityID + "\"";
    }

    @Override
    public QuickbarSlot getCopy(PC pC) {
        return new AbilityActivateSlot(Game.ruleset.getAbility(this.abilityID), pC);
    }
}

