/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionTwoValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONObject;

public class VelocityTowardsPointDistribution
implements DistributionTwoValue {
    private Point dest;
    private float time;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("destX", this.dest.x);
        jSONOrderedObject.put("destY", this.dest.y);
        jSONOrderedObject.put("time", Float.valueOf(this.time));
        return jSONOrderedObject;
    }

    public static VelocityTowardsPointDistribution load(SimpleJSONObject simpleJSONObject) {
        int n = simpleJSONObject.get("destX", 0);
        int n2 = simpleJSONObject.get("destY", 0);
        float f = simpleJSONObject.get("time", 0.0f);
        return new VelocityTowardsPointDistribution(new Point(n, n2), f);
    }

    public VelocityTowardsPointDistribution(Point point, float f) {
        this.dest = new Point(point);
        this.time = f;
    }

    @Override
    public float[] generate(Particle particle) {
        int n = AreaUtil.euclideanDistance2((int)particle.getX(), (int)particle.getY(), this.dest.x, this.dest.y);
        float f = (float)Math.sqrt(n);
        float f2 = (float)this.dest.x - particle.getX();
        float f3 = (float)this.dest.y - particle.getY();
        float f4 = f / this.time;
        float f5 = (float)Math.acos(f2 / f);
        if (f3 < 0.0f) {
            f5 = -f5;
        }
        float[] fArray = new float[]{(float)Math.cos(f5) * f4, (float)Math.sin(f5) * f4, f4, f5};
        return fArray;
    }

    @Override
    public DistributionTwoValue getCopyIfHasState() {
        return this;
    }
}

