/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.DistributionBase;
import net.sf.hale.particle.DistributionOneValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONObject;

public class UniformDistributionWithBase
implements DistributionOneValue {
    private final DistributionBase base;
    private final float plusOrMinusFraction;
    private final float multiplier;
    private final float offset;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("plusOrMinusFraction", Float.valueOf(this.plusOrMinusFraction));
        jSONOrderedObject.put("multiplier", Float.valueOf(this.multiplier));
        jSONOrderedObject.put("offset", Float.valueOf(this.offset));
        jSONOrderedObject.put("base", this.base.save());
        return jSONOrderedObject;
    }

    public static UniformDistributionWithBase load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        float f = simpleJSONObject.get("multiplier", 0.0f);
        float f2 = simpleJSONObject.get("offset", 0.0f);
        float f3 = simpleJSONObject.get("plusOrMinusFraction", 0.0f);
        DistributionBase distributionBase = (DistributionBase)SaveGameUtil.loadObject(simpleJSONObject.getObject("base"));
        return new UniformDistributionWithBase(distributionBase, f, f2, f3);
    }

    public UniformDistributionWithBase(DistributionBase distributionBase, float f, float f2, float f3) {
        this.base = distributionBase;
        this.plusOrMinusFraction = f3;
        this.multiplier = f;
        this.offset = f2;
    }

    @Override
    public float generate(Particle particle) {
        float f = this.base.getBase(particle) * this.multiplier + this.offset;
        return Game.dice.rand(f - f * this.plusOrMinusFraction, f + f * this.plusOrMinusFraction);
    }

    @Override
    public DistributionOneValue getCopyIfHasState() {
        return this;
    }
}

