/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionOneValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SimpleJSONObject;

public class UniformDistribution
implements DistributionOneValue {
    private float min;
    private float max;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("min", Float.valueOf(this.min));
        jSONOrderedObject.put("max", Float.valueOf(this.max));
        return jSONOrderedObject;
    }

    public static UniformDistribution load(SimpleJSONObject simpleJSONObject) {
        float f = simpleJSONObject.get("min", 0.0f);
        float f2 = simpleJSONObject.get("max", 0.0f);
        return new UniformDistribution(f, f2);
    }

    public UniformDistribution(float f, float f2) {
        this.min = f;
        this.max = f2;
    }

    @Override
    public float generate(Particle particle) {
        return Game.dice.rand(this.min, this.max);
    }

    @Override
    public DistributionOneValue getCopyIfHasState() {
        return this;
    }
}

