/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionTwoValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SimpleJSONObject;

public class UniformArcDistribution
implements DistributionTwoValue {
    private final float magnitudeMin;
    private final float magnitudeMax;
    private final float angleMin;
    private final float angleMax;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("magnitudeMin", Float.valueOf(this.magnitudeMin));
        jSONOrderedObject.put("magnitudeMax", Float.valueOf(this.magnitudeMax));
        jSONOrderedObject.put("angleMin", Float.valueOf(this.angleMin));
        jSONOrderedObject.put("angleMax", Float.valueOf(this.angleMax));
        return jSONOrderedObject;
    }

    public static UniformArcDistribution load(SimpleJSONObject simpleJSONObject) {
        float f = simpleJSONObject.get("magnitudeMin", 0.0f);
        float f2 = simpleJSONObject.get("magnitudeMax", 0.0f);
        float f3 = simpleJSONObject.get("angleMin", 0.0f);
        float f4 = simpleJSONObject.get("angleMax", 0.0f);
        return new UniformArcDistribution(f, f2, f3, f4);
    }

    public UniformArcDistribution(float f, float f2, float f3, float f4) {
        this.magnitudeMin = f;
        this.magnitudeMax = f2;
        this.angleMin = f3;
        this.angleMax = f4;
    }

    @Override
    public float[] generate(Particle particle) {
        float f = Game.dice.rand(this.angleMin, this.angleMax);
        float f2 = Game.dice.rand(this.magnitudeMin, this.magnitudeMax);
        float[] fArray = new float[]{(float)Math.cos(f) * f2, (float)Math.sin(f) * f2, f2, f};
        return fArray;
    }

    @Override
    public DistributionTwoValue getCopyIfHasState() {
        return this;
    }
}

