/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionTwoValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SimpleJSONObject;

public class UniformAngleDistribution
implements DistributionTwoValue {
    private static final float twoPi = (float)Math.PI * 2;
    private final float magnitudeMin;
    private final float magnitudeMax;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("magnitudeMin", Float.valueOf(this.magnitudeMin));
        jSONOrderedObject.put("magnitudeMax", Float.valueOf(this.magnitudeMax));
        return jSONOrderedObject;
    }

    public static UniformAngleDistribution load(SimpleJSONObject simpleJSONObject) {
        float f = simpleJSONObject.get("magnitudeMin", 0.0f);
        float f2 = simpleJSONObject.get("magnitudeMax", 0.0f);
        return new UniformAngleDistribution(f, f2);
    }

    public UniformAngleDistribution(float f, float f2) {
        this.magnitudeMin = f;
        this.magnitudeMax = f2;
    }

    @Override
    public float[] generate(Particle particle) {
        float f = Game.dice.rand(0.0f, (float)Math.PI * 2);
        float f2 = Game.dice.rand(this.magnitudeMin, this.magnitudeMax);
        float[] fArray = new float[]{(float)Math.cos(f) * f2, (float)Math.sin(f) * f2, f2, f};
        return fArray;
    }

    @Override
    public DistributionTwoValue getCopyIfHasState() {
        return this;
    }
}

