/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.Animated;
import net.sf.hale.particle.Particle;
import net.sf.hale.particle.ParticleGenerator;
import net.sf.hale.util.SimpleJSONObject;

public class RectParticleGenerator
extends ParticleGenerator {
    private float upperX;
    private float upperY;
    private float lowerX;
    private float lowerY;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("upperX", Float.valueOf(this.upperX - this.getX()));
        jSONOrderedObject.put("upperY", Float.valueOf(this.upperY - this.getY()));
        jSONOrderedObject.put("lowerX", Float.valueOf(this.lowerX - this.getX()));
        jSONOrderedObject.put("lowerY", Float.valueOf(this.lowerY - this.getY()));
        return jSONOrderedObject;
    }

    public static ParticleGenerator load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        ParticleGenerator.Mode mode = ParticleGenerator.Mode.valueOf(simpleJSONObject.get("generatorMode", null));
        String string = simpleJSONObject.get("sprite", null);
        float f = simpleJSONObject.get("numParticles", 0.0f);
        RectParticleGenerator rectParticleGenerator = new RectParticleGenerator(mode, string, f);
        rectParticleGenerator.loadBase(simpleJSONObject);
        rectParticleGenerator.upperX = simpleJSONObject.get("upperX", 0.0f);
        rectParticleGenerator.upperY = simpleJSONObject.get("upperY", 0.0f);
        rectParticleGenerator.lowerX = simpleJSONObject.get("lowerX", 0.0f);
        rectParticleGenerator.lowerY = simpleJSONObject.get("lowerY", 0.0f);
        return rectParticleGenerator;
    }

    public RectParticleGenerator(ParticleGenerator.Mode mode, String string, float f) {
        super(mode, string, f);
    }

    public RectParticleGenerator(RectParticleGenerator rectParticleGenerator) {
        super(rectParticleGenerator);
        this.upperX = rectParticleGenerator.upperX;
        this.upperY = rectParticleGenerator.upperY;
        this.lowerX = rectParticleGenerator.lowerX;
        this.lowerY = rectParticleGenerator.lowerY;
    }

    public void setRectBounds(float f, float f2, float f3, float f4) {
        this.upperX = Math.max(f2, f);
        this.upperY = Math.max(f4, f3);
        this.lowerX = Math.min(f, f2);
        this.lowerY = Math.min(f3, f4);
    }

    @Override
    public void offsetPosition(float f, float f2) {
        super.offsetPosition(f, f2);
        this.upperX += f;
        this.lowerX += f;
        this.upperY += f2;
        this.lowerY += f2;
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        this.upperX += this.getX();
        this.upperY += this.getY();
        this.lowerX += this.getX();
        this.lowerY += this.getY();
        return true;
    }

    @Override
    protected void setParticlePosition(Particle particle) {
        particle.setPosition(Game.dice.rand(this.lowerX, this.upperX), Game.dice.rand(this.lowerY, this.upperY));
    }

    @Override
    public Animated getCopy() {
        return new RectParticleGenerator(this);
    }
}

