/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;
import net.sf.hale.Game;
import net.sf.hale.interfacelock.EntityOffsetAnimation;
import net.sf.hale.particle.Animated;
import net.sf.hale.particle.Animation;
import net.sf.hale.particle.CircleParticleGenerator;
import net.sf.hale.particle.LineParticleGenerator;
import net.sf.hale.particle.ParticleGenerator;
import net.sf.hale.particle.RectParticleGenerator;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.JSEngine;
import net.sf.hale.util.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class ParticleManager {
    private long lastTime;
    private final Map<String, ParticleGenerator> baseGenerators = new HashMap<String, ParticleGenerator>();
    private final Map<String, Animation> baseAnimations = new HashMap<String, Animation>();
    private final List<Animated> activeBelowAnimations = new LinkedList<Animated>();
    private final List<Animated> activeAboveAnimations = new LinkedList<Animated>();
    private final List<Animated> animationsToAdd = new LinkedList<Animated>();
    private final List<EntityOffsetAnimation> entityOffsetAnimations = new LinkedList<EntityOffsetAnimation>();

    public ParticleManager() {
        this.lastTime = System.currentTimeMillis();
    }

    public void loadBaseResources() {
        Set<String> set = ResourceManager.getResourcesInDirectory("scripts/particleEffects");
        for (String string : set) {
            if (!string.endsWith(ResourceType.JavaScript.getExtension())) continue;
            this.loadBaseGenerator(string);
        }
        set = ResourceManager.getResourcesInDirectory("scripts/animations");
        for (String string : set) {
            if (!string.endsWith(ResourceType.JavaScript.getExtension())) continue;
            this.loadAnimation(string);
        }
    }

    private void loadAnimation(String string) {
        JSEngine jSEngine = Game.scriptEngineManager.getEngine();
        jSEngine.put("game", Game.scriptInterface);
        Animation animation = null;
        try {
            animation = (Animation)jSEngine.eval(ResourceManager.getResourceAsString(string));
            jSEngine.release();
        }
        catch (ScriptException scriptException) {
            Logger.appendToErrorLog("Error running script for animation " + string, scriptException);
        }
        String string2 = ResourceManager.getResourceIDNoPath(string, ResourceType.JavaScript);
        if (animation != null) {
            this.baseAnimations.put(string2, animation);
        } else {
            Logger.appendToErrorLog("Warning: " + string + " did not return an Animation.");
        }
    }

    private void loadBaseGenerator(String string) {
        JSEngine jSEngine = Game.scriptEngineManager.getEngine();
        jSEngine.put("game", Game.scriptInterface);
        ParticleGenerator particleGenerator = null;
        try {
            particleGenerator = (ParticleGenerator)jSEngine.eval(ResourceManager.getResourceAsString(string));
            jSEngine.release();
        }
        catch (ScriptException scriptException) {
            Logger.appendToErrorLog("Error running script for particle effect " + string, scriptException);
        }
        String string2 = ResourceManager.getResourceIDNoPath(string, ResourceType.JavaScript);
        if (particleGenerator != null) {
            this.baseGenerators.put(string2, particleGenerator);
        } else {
            Logger.appendToErrorLog("Warning: " + string + " did not return a Particle Generator.");
        }
    }

    public Animation getAnimation(String string) {
        Animation animation = this.baseAnimations.get(string);
        if (animation == null) {
            return null;
        }
        return new Animation(animation);
    }

    public ParticleGenerator getParticleGenerator(String string) {
        ParticleGenerator particleGenerator = this.baseGenerators.get(string);
        if (particleGenerator == null) {
            return null;
        }
        if (particleGenerator instanceof LineParticleGenerator) {
            return new LineParticleGenerator((LineParticleGenerator)particleGenerator);
        }
        if (particleGenerator instanceof RectParticleGenerator) {
            return new RectParticleGenerator((RectParticleGenerator)particleGenerator);
        }
        if (particleGenerator instanceof CircleParticleGenerator) {
            return new CircleParticleGenerator((CircleParticleGenerator)particleGenerator);
        }
        return new ParticleGenerator(this.baseGenerators.get(string));
    }

    public void addEntityOffsetAnimation(EntityOffsetAnimation entityOffsetAnimation) {
        this.entityOffsetAnimations.add(entityOffsetAnimation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Animated animated) {
        animated.initialize();
        List<Animated> list = this.animationsToAdd;
        synchronized (list) {
            this.animationsToAdd.add(animated);
        }
    }

    public void clear() {
        this.activeAboveAnimations.clear();
        this.activeBelowAnimations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long l) {
        float f = (float)(l - this.lastTime) / 1000.0f;
        Iterator<EntityOffsetAnimation> iterator = this.entityOffsetAnimations.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().elapseTime(f)) continue;
            iterator.remove();
        }
        Iterator<Animated> iterator2 = this.activeAboveAnimations.iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().elapseTime(f)) continue;
            iterator2.remove();
        }
        iterator2 = this.activeBelowAnimations.iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().elapseTime(f)) continue;
            iterator2.remove();
        }
        List<Animated> list = this.animationsToAdd;
        synchronized (list) {
            for (Animated animated : this.animationsToAdd) {
                animated.cacheSprite();
                if (!animated.isDrawable()) continue;
                switch (animated.getDrawingMode()) {
                    case BelowEntities: {
                        this.activeBelowAnimations.add(animated);
                        break;
                    }
                    case AboveEntities: {
                        this.activeAboveAnimations.add(animated);
                    }
                }
            }
            this.animationsToAdd.clear();
        }
        this.lastTime = l;
    }

    public final void drawBelowEntities() {
        GL11.glEnable((int)3553);
        for (Animated animated : this.activeBelowAnimations) {
            animated.draw();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL14.glSecondaryColor3f((float)0.0f, (float)0.0f, (float)0.0f);
    }

    public final void drawAboveEntities() {
        GL11.glEnable((int)3553);
        for (Animated animated : this.activeAboveAnimations) {
            animated.draw();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL14.glSecondaryColor3f((float)0.0f, (float)0.0f, (float)0.0f);
    }
}

