/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.Location;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.Animated;
import net.sf.hale.particle.DistributionOneValue;
import net.sf.hale.particle.DistributionTwoValue;
import net.sf.hale.particle.FixedDistribution;
import net.sf.hale.particle.Particle;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import org.lwjgl.opengl.GL11;

public class ParticleGenerator
implements Animated {
    private Sprite particleSprite;
    private List<Particle> particles;
    private float speed;
    private Mode mode;
    private Animated.DrawingMode drawingMode;
    private boolean initialized;
    private boolean burstGenerated;
    private float timeLeft;
    private boolean stopAtOpaque;
    private boolean drawInOpaque;
    private float positionX;
    private float positionY;
    private float velocityX;
    private float velocityY;
    private float currentNewParticles;
    private float numParticles;
    private final String spriteRef;
    private List<SubGenerator> subGenerators;
    private DistributionOneValue rotationDistribution;
    private DistributionOneValue rotationSpeedDistribution;
    private DistributionTwoValue velocityDistribution;
    private DistributionOneValue durationDistribution;
    private DistributionOneValue alphaVelocityDistribution;
    private DistributionOneValue redVelocityDistribution;
    private DistributionOneValue greenVelocityDistribution;
    private DistributionOneValue blueVelocityDistribution;
    private DistributionOneValue alphaDistribution;
    private DistributionOneValue redDistribution;
    private DistributionOneValue greenDistribution;
    private DistributionOneValue blueDistribution;
    private DistributionOneValue red2VelocityDistribution;
    private DistributionOneValue green2VelocityDistribution;
    private DistributionOneValue blue2VelocityDistribution;
    private DistributionOneValue red2Distribution;
    private DistributionOneValue green2Distribution;
    private DistributionOneValue blue2Distribution;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("generatorMode", this.mode.toString());
        jSONOrderedObject.put("numParticles", Float.valueOf(this.numParticles));
        jSONOrderedObject.put("sprite", this.spriteRef);
        jSONOrderedObject.put("drawingMode", this.drawingMode.toString());
        jSONOrderedObject.put("burstGenerated", this.burstGenerated);
        jSONOrderedObject.put("timeLeft", Float.valueOf(this.timeLeft));
        jSONOrderedObject.put("stopAtOpaque", this.stopAtOpaque);
        jSONOrderedObject.put("drawInOpaque", this.drawInOpaque);
        jSONOrderedObject.put("positionX", Float.valueOf(this.positionX));
        jSONOrderedObject.put("positionY", Float.valueOf(this.positionY));
        jSONOrderedObject.put("velocityX", Float.valueOf(this.velocityX));
        jSONOrderedObject.put("velocityY", Float.valueOf(this.velocityY));
        jSONOrderedObject.put("currentNewParticles", Float.valueOf(this.currentNewParticles));
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.subGenerators.size()];
        int n = 0;
        for (SubGenerator subGenerator : this.subGenerators) {
            jSONOrderedObjectArray[n] = new JSONOrderedObject();
            jSONOrderedObjectArray[n].put("time", Float.valueOf(subGenerator.time));
            jSONOrderedObjectArray[n].put("animated", subGenerator.generator.save());
            ++n;
        }
        if (jSONOrderedObjectArray.length != 0) {
            jSONOrderedObject.put("subGenerators", jSONOrderedObjectArray);
        }
        if (this.rotationDistribution != null) {
            jSONOrderedObject.put("rotationDistribution", this.rotationDistribution.save());
        }
        if (this.rotationSpeedDistribution != null) {
            jSONOrderedObject.put("rotationSpeedDistribution", this.rotationSpeedDistribution.save());
        }
        if (this.velocityDistribution != null) {
            jSONOrderedObject.put("velocityDistribution", this.velocityDistribution.save());
        }
        if (this.durationDistribution != null) {
            jSONOrderedObject.put("durationDistribution", this.durationDistribution.save());
        }
        if (this.alphaVelocityDistribution != null) {
            jSONOrderedObject.put("alphaVelocityDistribution", this.alphaVelocityDistribution.save());
        }
        if (this.redVelocityDistribution != null) {
            jSONOrderedObject.put("redVelocityDistribution", this.redVelocityDistribution.save());
        }
        if (this.greenVelocityDistribution != null) {
            jSONOrderedObject.put("greenVelocityDistribution", this.greenVelocityDistribution.save());
        }
        if (this.blueVelocityDistribution != null) {
            jSONOrderedObject.put("blueVelocityDistribution", this.blueVelocityDistribution.save());
        }
        if (this.alphaDistribution != null) {
            jSONOrderedObject.put("alphaDistribution", this.alphaDistribution.save());
        }
        if (this.redDistribution != null) {
            jSONOrderedObject.put("redDistribution", this.redDistribution.save());
        }
        if (this.greenDistribution != null) {
            jSONOrderedObject.put("greenDistribution", this.greenDistribution.save());
        }
        if (this.blueDistribution != null) {
            jSONOrderedObject.put("blueDistribution", this.blueDistribution.save());
        }
        if (this.red2VelocityDistribution != null) {
            jSONOrderedObject.put("red2VelocityDistribution", this.red2VelocityDistribution.save());
        }
        if (this.green2VelocityDistribution != null) {
            jSONOrderedObject.put("green2VelocityDistribution", this.green2VelocityDistribution.save());
        }
        if (this.blue2VelocityDistribution != null) {
            jSONOrderedObject.put("blue2VelocityDistribution", this.blue2VelocityDistribution.save());
        }
        if (this.red2Distribution != null) {
            jSONOrderedObject.put("red2Distribution", this.red2Distribution.save());
        }
        if (this.green2Distribution != null) {
            jSONOrderedObject.put("green2Distribution", this.green2Distribution.save());
        }
        if (this.blue2Distribution != null) {
            jSONOrderedObject.put("blue2Distribution", this.blue2Distribution.save());
        }
        return jSONOrderedObject;
    }

    public static ParticleGenerator load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        Mode mode = Mode.valueOf(simpleJSONObject.get("generatorMode", null));
        String string = simpleJSONObject.get("sprite", null);
        float f = simpleJSONObject.get("numParticles", 0.0f);
        ParticleGenerator particleGenerator = new ParticleGenerator(mode, string, f);
        particleGenerator.loadBase(simpleJSONObject);
        return particleGenerator;
    }

    protected final void loadBase(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        this.drawingMode = Animated.DrawingMode.valueOf(simpleJSONObject.get("drawingMode", null));
        this.burstGenerated = simpleJSONObject.get("burstGenerated", false);
        this.timeLeft = simpleJSONObject.get("timeLeft", 0.0f);
        this.stopAtOpaque = simpleJSONObject.get("stopAtOpaque", false);
        this.drawInOpaque = simpleJSONObject.get("drawInOpaque", false);
        this.positionX = simpleJSONObject.get("positionX", 0.0f);
        this.positionY = simpleJSONObject.get("positionY", 0.0f);
        this.velocityX = simpleJSONObject.get("velocityX", 0.0f);
        this.velocityY = simpleJSONObject.get("velocityY", 0.0f);
        this.currentNewParticles = simpleJSONObject.get("currentNewParticles", 0.0f);
        if (simpleJSONObject.containsKey("subGenerators")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("subGenerators")) {
                SimpleJSONObject simpleJSONObject2 = simpleJSONArrayEntry.getObject();
                float f = simpleJSONObject2.get("anim", 0.0f);
                Animated animated = (Animated)SaveGameUtil.loadObject(simpleJSONObject2.getObject("animated"));
                this.addSubGenerator(animated, f);
            }
        }
        if (simpleJSONObject.containsKey("rotationDistribution")) {
            this.rotationDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("rotationDistribution"));
        }
        if (simpleJSONObject.containsKey("rotationSpeedDistribution")) {
            this.rotationSpeedDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("rotationSpeedDistribution"));
        }
        if (simpleJSONObject.containsKey("velocityDistribution")) {
            this.velocityDistribution = (DistributionTwoValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("velocityDistribution"));
        }
        if (simpleJSONObject.containsKey("durationDistribution")) {
            this.durationDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("durationDistribution"));
        }
        if (simpleJSONObject.containsKey("alphaVelocityDistribution")) {
            this.alphaVelocityDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("alphaVelocityDistribution"));
        }
        if (simpleJSONObject.containsKey("redVelocityDistribution")) {
            this.redVelocityDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("redVelocityDistribution"));
        }
        if (simpleJSONObject.containsKey("greenVelocityDistribution")) {
            this.greenVelocityDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("greenVelocityDistribution"));
        }
        if (simpleJSONObject.containsKey("blueVelocityDistribution")) {
            this.blueVelocityDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("blueVelocityDistribution"));
        }
        if (simpleJSONObject.containsKey("alphaDistribution")) {
            this.alphaDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("alphaDistribution"));
        }
        if (simpleJSONObject.containsKey("redDistribution")) {
            this.redDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("redDistribution"));
        }
        if (simpleJSONObject.containsKey("greenDistribution")) {
            this.greenDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("greenDistribution"));
        }
        if (simpleJSONObject.containsKey("blueDistribution")) {
            this.blueDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("blueDistribution"));
        }
        if (simpleJSONObject.containsKey("red2VelocityDistribution")) {
            this.red2VelocityDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("red2VelocityDistribution"));
        }
        if (simpleJSONObject.containsKey("green2VelocityDistribution")) {
            this.green2VelocityDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("green2VelocityDistribution"));
        }
        if (simpleJSONObject.containsKey("blue2VelocityDistribution")) {
            this.blue2VelocityDistribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("blue2VelocityDistribution"));
        }
        if (simpleJSONObject.containsKey("red2Distribution")) {
            this.red2Distribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("red2Distribution"));
        }
        if (simpleJSONObject.containsKey("green2Distribution")) {
            this.green2Distribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("green2Distribution"));
        }
        if (simpleJSONObject.containsKey("blue2Distribution")) {
            this.blue2Distribution = (DistributionOneValue)SaveGameUtil.loadObject(simpleJSONObject.getObject("blue2Distribution"));
        }
    }

    public ParticleGenerator(ParticleGenerator particleGenerator) {
        this.particles = new LinkedList<Particle>();
        this.subGenerators = new LinkedList<SubGenerator>();
        this.initialized = particleGenerator.initialized;
        if (particleGenerator.velocityDistribution != null) {
            this.velocityDistribution = particleGenerator.velocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.durationDistribution != null) {
            this.durationDistribution = particleGenerator.durationDistribution.getCopyIfHasState();
        }
        if (particleGenerator.rotationDistribution != null) {
            this.rotationDistribution = particleGenerator.rotationDistribution.getCopyIfHasState();
        }
        if (particleGenerator.rotationSpeedDistribution != null) {
            this.rotationSpeedDistribution = particleGenerator.rotationSpeedDistribution.getCopyIfHasState();
        }
        if (particleGenerator.alphaVelocityDistribution != null) {
            this.alphaVelocityDistribution = particleGenerator.alphaVelocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.redVelocityDistribution != null) {
            this.redVelocityDistribution = particleGenerator.redVelocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.greenVelocityDistribution != null) {
            this.greenVelocityDistribution = particleGenerator.greenVelocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.blueVelocityDistribution != null) {
            this.blueVelocityDistribution = particleGenerator.blueVelocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.alphaDistribution != null) {
            this.alphaDistribution = particleGenerator.alphaDistribution.getCopyIfHasState();
        }
        if (particleGenerator.redDistribution != null) {
            this.redDistribution = particleGenerator.redDistribution.getCopyIfHasState();
        }
        if (particleGenerator.greenDistribution != null) {
            this.greenDistribution = particleGenerator.greenDistribution.getCopyIfHasState();
        }
        if (particleGenerator.blueDistribution != null) {
            this.blueDistribution = particleGenerator.blueDistribution.getCopyIfHasState();
        }
        if (particleGenerator.red2VelocityDistribution != null) {
            this.red2VelocityDistribution = particleGenerator.red2VelocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.green2VelocityDistribution != null) {
            this.green2VelocityDistribution = particleGenerator.green2VelocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.blue2VelocityDistribution != null) {
            this.blue2VelocityDistribution = particleGenerator.blue2VelocityDistribution.getCopyIfHasState();
        }
        if (particleGenerator.red2Distribution != null) {
            this.red2Distribution = particleGenerator.red2Distribution.getCopyIfHasState();
        }
        if (particleGenerator.green2Distribution != null) {
            this.green2Distribution = particleGenerator.green2Distribution.getCopyIfHasState();
        }
        if (particleGenerator.blue2Distribution != null) {
            this.blue2Distribution = particleGenerator.blue2Distribution.getCopyIfHasState();
        }
        for (SubGenerator object : particleGenerator.subGenerators) {
            this.subGenerators.add(new SubGenerator(object));
        }
        this.drawingMode = particleGenerator.drawingMode;
        this.burstGenerated = particleGenerator.burstGenerated;
        this.mode = particleGenerator.mode;
        this.timeLeft = particleGenerator.timeLeft;
        this.stopAtOpaque = particleGenerator.stopAtOpaque;
        this.drawInOpaque = particleGenerator.drawInOpaque;
        this.positionX = particleGenerator.positionX;
        this.positionY = particleGenerator.positionY;
        this.velocityX = particleGenerator.velocityX;
        this.velocityY = particleGenerator.velocityY;
        this.speed = particleGenerator.speed;
        this.currentNewParticles = particleGenerator.currentNewParticles;
        this.numParticles = particleGenerator.numParticles;
        this.particleSprite = particleGenerator.particleSprite;
        this.spriteRef = particleGenerator.spriteRef;
        for (Particle particle : particleGenerator.particles) {
            this.particles.add(new Particle(particle));
        }
    }

    public ParticleGenerator(Mode mode, String string, float f) {
        this.mode = mode;
        this.drawingMode = Animated.DrawingMode.AboveEntities;
        this.particleSprite = SpriteManager.getSprite(string);
        this.spriteRef = string;
        this.numParticles = f;
        this.particles = new LinkedList<Particle>();
        this.subGenerators = new LinkedList<SubGenerator>();
        this.burstGenerated = false;
        this.initialized = false;
    }

    public void setNumParticles(float f) {
        this.numParticles = f;
    }

    public void setDrawingMode(String string) {
        this.drawingMode = Animated.DrawingMode.valueOf(string);
    }

    @Override
    public Animated.DrawingMode getDrawingMode() {
        return this.drawingMode;
    }

    @Override
    public boolean isDrawable() {
        return this.numParticles > 0.0f && this.particleSprite != null;
    }

    @Override
    public void cacheSprite() {
    }

    public void setSprite(Sprite sprite) {
        this.particleSprite = sprite;
    }

    public final float getNumParticles() {
        return this.numParticles;
    }

    public final float getX() {
        return this.positionX;
    }

    public final float getY() {
        return this.positionY;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public void addSubGeneratorAtEnd(Animated animated) {
        this.subGenerators.add(new SubGenerator(animated, this.timeLeft));
    }

    public void addSubGenerator(Animated animated, float f) {
        this.subGenerators.add(new SubGenerator(animated, f));
    }

    public void setDrawParticlesInOpaque(boolean bl) {
        this.drawInOpaque = bl;
    }

    public void setStopParticlesAtOpaque(boolean bl) {
        this.stopAtOpaque = bl;
    }

    public void setPosition(Location location) {
        Point point = AreaUtil.convertGridToScreenAndCenter(location.getX(), location.getY());
        this.setPosition(point.x, point.y);
    }

    public void setPosition(Point point) {
        Point point2 = AreaUtil.convertGridToScreenAndCenter(point);
        this.setPosition(point2.x, point2.y);
    }

    @Override
    public void offsetPosition(float f, float f2) {
        this.positionX += f;
        this.positionY += f2;
    }

    @Override
    public void setPosition(float f, float f2) {
        this.positionX = f;
        this.positionY = f2;
    }

    public void setVelocity(float f, float f2) {
        this.velocityX = f;
        this.velocityY = f2;
        this.speed = (float)Math.sqrt(f * f + f2 * f2);
    }

    @Override
    public void setDurationInfinite() {
        this.timeLeft = 1.0E12f;
    }

    @Override
    public void setDuration(float f) {
        this.timeLeft = f;
    }

    public float getTimeLeft() {
        return this.timeLeft;
    }

    private void setParametersBasedOnSpeed(Point point, Point point2, float f, boolean bl) {
        Point point3 = AreaUtil.convertGridToScreenAndCenter(point2);
        Point point4 = AreaUtil.convertGridToScreenAndCenter(point);
        this.positionX = point4.x;
        this.positionY = point4.y;
        int n = AreaUtil.euclideanDistance2(point4.x, point4.y, point3.x, point3.y);
        float f2 = (float)Math.sqrt(n);
        this.timeLeft = f2 / f;
        float f3 = point3.x - point4.x;
        float f4 = point3.y - point4.y;
        float f5 = (float)Math.acos(f3 / f2);
        if (f4 < 0.0f) {
            f5 = -f5;
        }
        this.velocityX = f * (float)Math.cos(f5);
        this.velocityY = f * (float)Math.sin(f5);
        this.speed = f;
        if (bl) {
            this.rotationDistribution = new FixedDistribution((float)((double)f5 * 180.0 / Math.PI));
        }
    }

    public void setVelocityDurationRotationBasedOnSpeed(Point point, Point point2, float f) {
        this.setParametersBasedOnSpeed(point, point2, f, true);
    }

    public void setVelocityDurationBasedOnSpeed(Point point, Point point2, float f) {
        this.setParametersBasedOnSpeed(point, point2, f, false);
    }

    public void setRotationDistribution(DistributionOneValue distributionOneValue) {
        this.rotationDistribution = distributionOneValue;
    }

    public void setRotationSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.rotationSpeedDistribution = distributionOneValue;
    }

    public void setRedDistribution(DistributionOneValue distributionOneValue) {
        this.redDistribution = distributionOneValue;
    }

    public void setGreenDistribution(DistributionOneValue distributionOneValue) {
        this.greenDistribution = distributionOneValue;
    }

    public void setBlueDistribution(DistributionOneValue distributionOneValue) {
        this.blueDistribution = distributionOneValue;
    }

    public void setAlphaDistribution(DistributionOneValue distributionOneValue) {
        this.alphaDistribution = distributionOneValue;
    }

    public void setRedSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.redVelocityDistribution = distributionOneValue;
    }

    public void setGreenSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.greenVelocityDistribution = distributionOneValue;
    }

    public void setBlueSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.blueVelocityDistribution = distributionOneValue;
    }

    public void setAlphaSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.alphaVelocityDistribution = distributionOneValue;
    }

    public void setSecondaryRedDistribution(DistributionOneValue distributionOneValue) {
        this.red2Distribution = distributionOneValue;
    }

    public void setSecondaryGreenDistribution(DistributionOneValue distributionOneValue) {
        this.green2Distribution = distributionOneValue;
    }

    public void setSecondaryBlueDistribution(DistributionOneValue distributionOneValue) {
        this.blue2Distribution = distributionOneValue;
    }

    public void setSecondaryRedSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.red2VelocityDistribution = distributionOneValue;
    }

    public void setSecondaryGreenSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.green2VelocityDistribution = distributionOneValue;
    }

    public void setSecondaryBlueSpeedDistribution(DistributionOneValue distributionOneValue) {
        this.blue2VelocityDistribution = distributionOneValue;
    }

    public void setDurationDistribution(DistributionOneValue distributionOneValue) {
        this.durationDistribution = distributionOneValue;
    }

    public void setVelocityDistribution(DistributionTwoValue distributionTwoValue) {
        this.velocityDistribution = distributionTwoValue;
    }

    @Override
    public boolean elapseTime(float f) {
        Object object;
        this.timeLeft -= f;
        Iterator<SubGenerator> iterator = this.subGenerators.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            SubGenerator subGenerator = object;
            subGenerator.time = subGenerator.time - f;
            if (!(((SubGenerator)object).time < 0.0f)) continue;
            ((SubGenerator)object).generator.setPosition(this.positionX, this.positionY);
            Game.particleManager.add(((SubGenerator)object).generator);
            iterator.remove();
        }
        this.offsetPosition(this.velocityX * f, this.velocityY * f);
        object = this.particles.iterator();
        while (object.hasNext()) {
            boolean bl = ((Particle)object.next()).elapseTime(f);
            if (!bl) continue;
            object.remove();
        }
        if (this.timeLeft > 0.0f) {
            switch (this.mode) {
                case Continuous: {
                    this.currentNewParticles += f * this.numParticles;
                    int n = (int)Math.floor(this.currentNewParticles);
                    this.addParticles(n);
                    this.currentNewParticles -= (float)n;
                    break;
                }
                case Burst: {
                    if (this.burstGenerated) break;
                    this.addParticles((int)this.numParticles);
                    this.burstGenerated = true;
                }
            }
        }
        return this.timeLeft < 0.0f && this.particles.size() == 0;
    }

    @Override
    public boolean initialize() {
        boolean bl = this.initialized;
        this.initialized = true;
        return !bl;
    }

    protected void setParticlePosition(Particle particle) {
        particle.setPosition(this.positionX, this.positionY);
    }

    private void addParticles(int n) {
        for (int i = 0; i < n; ++i) {
            Particle particle = new Particle(this.particleSprite);
            particle.setStopAtOpaque(this.stopAtOpaque);
            particle.setDrawInOpaque(this.drawInOpaque);
            this.setParticlePosition(particle);
            if (this.durationDistribution != null) {
                particle.setDuration(this.durationDistribution.generate(particle));
            } else {
                particle.setDuration(this.timeLeft);
            }
            if (this.velocityDistribution != null) {
                particle.setVelocity(this.velocityDistribution.generate(particle));
            }
            if (this.alphaDistribution != null) {
                particle.setAlpha(this.alphaDistribution.generate(particle));
            }
            if (this.redDistribution != null) {
                particle.setRed(this.redDistribution.generate(particle));
            }
            if (this.greenDistribution != null) {
                particle.setGreen(this.greenDistribution.generate(particle));
            }
            if (this.blueDistribution != null) {
                particle.setBlue(this.blueDistribution.generate(particle));
            }
            if (this.red2Distribution != null) {
                particle.setSecondaryRed(this.red2Distribution.generate(particle));
            }
            if (this.green2Distribution != null) {
                particle.setSecondaryGreen(this.green2Distribution.generate(particle));
            }
            if (this.blue2Distribution != null) {
                particle.setSecondaryBlue(this.blue2Distribution.generate(particle));
            }
            if (this.alphaVelocityDistribution != null) {
                particle.setAlphaSpeed(this.alphaVelocityDistribution.generate(particle));
            }
            if (this.redVelocityDistribution != null) {
                particle.setRedSpeed(this.redVelocityDistribution.generate(particle));
            }
            if (this.greenVelocityDistribution != null) {
                particle.setGreenSpeed(this.greenVelocityDistribution.generate(particle));
            }
            if (this.blueVelocityDistribution != null) {
                particle.setBlueSpeed(this.blueVelocityDistribution.generate(particle));
            }
            if (this.red2VelocityDistribution != null) {
                particle.setSecondaryRedSpeed(this.red2VelocityDistribution.generate(particle));
            }
            if (this.green2VelocityDistribution != null) {
                particle.setSecondaryGreenSpeed(this.green2VelocityDistribution.generate(particle));
            }
            if (this.blue2VelocityDistribution != null) {
                particle.setSecondaryBlueSpeed(this.blue2VelocityDistribution.generate(particle));
            }
            if (this.rotationDistribution != null) {
                particle.setRotation(this.rotationDistribution.generate(particle));
            }
            if (this.rotationSpeedDistribution != null) {
                particle.setRotationSpeed(this.rotationSpeedDistribution.generate(particle));
            }
            this.particles.add(particle);
        }
    }

    @Override
    public void draw() {
        GL11.glBindTexture((int)3553, (int)this.particleSprite.getTextureReference());
        for (Particle particle : this.particles) {
            particle.draw();
        }
    }

    @Override
    public Animated getCopy() {
        return new ParticleGenerator(this);
    }

    private class SubGenerator {
        private Animated generator;
        private float time;

        private SubGenerator(SubGenerator subGenerator) {
            this.generator = subGenerator.generator.getCopy();
            this.time = subGenerator.time;
        }

        private SubGenerator(Animated animated, float f) {
            this.generator = animated;
            this.time = f;
        }
    }

    public static enum Mode {
        Continuous,
        Burst;

    }
}

