/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.particle.AnimationBase;
import net.sf.hale.resource.Sprite;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class Particle
extends AnimationBase {
    private final Sprite sprite;
    private boolean stopAtOpaque;
    private boolean drawInOpaque;

    public Particle(Particle particle) {
        super(particle);
        this.sprite = particle.sprite;
        this.stopAtOpaque = particle.stopAtOpaque;
        this.drawInOpaque = particle.drawInOpaque;
    }

    public Particle(Sprite sprite) {
        super(sprite.getWidth() / 2, sprite.getHeight() / 2);
        this.sprite = sprite;
        this.stopAtOpaque = false;
        this.drawInOpaque = false;
    }

    public final void setDrawInOpaque(boolean bl) {
        this.drawInOpaque = bl;
    }

    public final void setStopAtOpaque(boolean bl) {
        this.stopAtOpaque = bl;
    }

    public final void draw() {
        GL11.glColor4f((float)this.getR(), (float)this.getG(), (float)this.getB(), (float)this.getA());
        GL14.glSecondaryColor3f((float)this.getR2(), (float)this.getG2(), (float)this.getB2());
        int n = (int)this.getX();
        int n2 = (int)this.getY();
        Point point = AreaUtil.convertScreenToGrid(n + this.getHalfWidth(), n2 + this.getHalfHeight());
        Point point2 = AreaUtil.convertScreenToGrid(n + this.getHalfWidth(), n2 - this.getHalfHeight());
        Point point3 = AreaUtil.convertScreenToGrid(n - this.getHalfWidth(), n2 + this.getHalfHeight());
        Point point4 = AreaUtil.convertScreenToGrid(n - this.getHalfWidth(), n2 - this.getHalfHeight());
        Area area = Game.curCampaign.curArea;
        if (!(this.drawInOpaque || area.isTransparent(point) && area.isTransparent(point2) && area.isTransparent(point3) && area.isTransparent(point4))) {
            Point point5 = AreaUtil.convertScreenToGrid(n + this.getHalfWidth(), n2 + this.getHalfHeight());
            if (!area.isTransparent(point5) && this.stopAtOpaque) {
                this.finish();
            }
            return;
        }
        if (this.getRotation() != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.getX(), (float)this.getY(), (float)0.0f);
            GL11.glRotatef((float)this.getRotation(), (float)0.0f, (float)0.0f, (float)1.0f);
            if (area.isVisible(point) || area.isVisible(point2) || area.isVisible(point3) || area.isVisible(point4)) {
                this.sprite.drawNoTextureBind(-this.getHalfWidth(), -this.getHalfHeight());
            }
            GL11.glPopMatrix();
        } else if (area.isVisible(point) || area.isVisible(point2) || area.isVisible(point3) || area.isVisible(point4)) {
            this.sprite.drawNoTextureBind((int)this.getX() - this.getHalfWidth(), (int)this.getY() - this.getHalfHeight());
        }
    }
}

