/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.Animated;
import net.sf.hale.particle.Particle;
import net.sf.hale.particle.ParticleGenerator;
import net.sf.hale.util.SimpleJSONObject;

public class LineParticleGenerator
extends ParticleGenerator {
    private LineStepMode lineStepMode;
    private float lineStepRatio;
    private float lineStartX;
    private float lineStartY;
    private float lineEndX;
    private float lineEndY;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("lineStartX", Float.valueOf(this.lineStartX - this.getX()));
        jSONOrderedObject.put("lineStartY", Float.valueOf(this.lineStartY - this.getY()));
        jSONOrderedObject.put("lineEndX", Float.valueOf(this.lineEndX - this.getX()));
        jSONOrderedObject.put("lineEndY", Float.valueOf(this.lineEndY - this.getY()));
        return jSONOrderedObject;
    }

    public static ParticleGenerator load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        ParticleGenerator.Mode mode = ParticleGenerator.Mode.valueOf(simpleJSONObject.get("generatorMode", null));
        String string = simpleJSONObject.get("sprite", null);
        float f = simpleJSONObject.get("numParticles", 0.0f);
        LineParticleGenerator lineParticleGenerator = new LineParticleGenerator(mode, string, f);
        lineParticleGenerator.loadBase(simpleJSONObject);
        lineParticleGenerator.lineStartX = simpleJSONObject.get("lineStartX", 0.0f);
        lineParticleGenerator.lineStartY = simpleJSONObject.get("lineStartY", 0.0f);
        lineParticleGenerator.lineEndX = simpleJSONObject.get("lineEndX", 0.0f);
        lineParticleGenerator.lineEndY = simpleJSONObject.get("lineEndY", 0.0f);
        return lineParticleGenerator;
    }

    public LineParticleGenerator(ParticleGenerator.Mode mode, String string, float f) {
        super(mode, string, f);
    }

    public LineParticleGenerator(LineParticleGenerator lineParticleGenerator) {
        super(lineParticleGenerator);
        this.lineStepMode = lineParticleGenerator.lineStepMode;
        this.lineStepRatio = lineParticleGenerator.lineStepRatio;
        this.lineStartX = lineParticleGenerator.lineStartX;
        this.lineStartY = lineParticleGenerator.lineStartY;
        this.lineEndX = lineParticleGenerator.lineEndX;
        this.lineEndY = lineParticleGenerator.lineEndY;
    }

    public void setLineStart(float f, float f2) {
        this.lineStartX = f;
        this.lineStartY = f2;
    }

    public void setLineEnd(float f, float f2) {
        this.lineEndX = f;
        this.lineEndY = f2;
    }

    @Override
    public void offsetPosition(float f, float f2) {
        super.offsetPosition(f, f2);
        this.lineStartX += f;
        this.lineEndX += f;
        this.lineStartY += f2;
        this.lineEndY += f2;
    }

    @Override
    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        this.lineStartX += this.getX();
        this.lineStartY += this.getY();
        this.lineEndX += this.getX();
        this.lineEndY += this.getY();
        float f = this.lineEndX - this.lineStartX;
        float f2 = this.lineEndY - this.lineStartY;
        if (Math.abs(f) > Math.abs(f2)) {
            this.lineStepMode = LineStepMode.X;
            this.lineStepRatio = f2 / f;
        } else {
            this.lineStepMode = LineStepMode.Y;
            this.lineStepRatio = f / f2;
        }
        return true;
    }

    @Override
    protected void setParticlePosition(Particle particle) {
        float f;
        float f2;
        switch (this.lineStepMode) {
            case X: {
                f2 = Game.dice.rand(this.lineStartX, this.lineEndX);
                f = (f2 - this.lineStartX) * this.lineStepRatio + this.lineStartY;
                break;
            }
            default: {
                f = Game.dice.rand(this.lineStartY, this.lineEndY);
                f2 = (f - this.lineStartY) * this.lineStepRatio + this.lineStartX;
            }
        }
        particle.setPosition(f2, f);
    }

    @Override
    public Animated getCopy() {
        return new LineParticleGenerator(this);
    }

    private static enum LineStepMode {
        X,
        Y;

    }
}

