/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.DistributionBase;
import net.sf.hale.particle.DistributionOneValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONObject;

public class GaussianDistributionWithBase
implements DistributionOneValue {
    private final DistributionBase base;
    private final float stddevFraction;
    private final float multiplier;
    private final float offset;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("stddevFraction", Float.valueOf(this.stddevFraction));
        jSONOrderedObject.put("multiplier", Float.valueOf(this.multiplier));
        jSONOrderedObject.put("offset", Float.valueOf(this.offset));
        jSONOrderedObject.put("base", this.base.save());
        return jSONOrderedObject;
    }

    public static GaussianDistributionWithBase load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        float f = simpleJSONObject.get("multiplier", 0.0f);
        float f2 = simpleJSONObject.get("offset", 0.0f);
        float f3 = simpleJSONObject.get("stddevFraction", 0.0f);
        DistributionBase distributionBase = (DistributionBase)SaveGameUtil.loadObject(simpleJSONObject.getObject("base"));
        return new GaussianDistributionWithBase(distributionBase, f, f2, f3);
    }

    public GaussianDistributionWithBase(DistributionBase distributionBase, float f, float f2, float f3) {
        this.base = distributionBase;
        this.stddevFraction = f3;
        this.multiplier = f;
        this.offset = f2;
    }

    @Override
    public float generate(Particle particle) {
        float f = this.base.getBase(particle) * this.multiplier + this.offset;
        return Game.dice.gaussian(f, f * this.stddevFraction);
    }

    @Override
    public DistributionOneValue getCopyIfHasState() {
        return this;
    }
}

