/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionOneValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SimpleJSONObject;

public class GaussianDistribution
implements DistributionOneValue {
    private final float mean;
    private final float stddev;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("mean", Float.valueOf(this.mean));
        jSONOrderedObject.put("stddev", Float.valueOf(this.stddev));
        return jSONOrderedObject;
    }

    public static GaussianDistribution load(SimpleJSONObject simpleJSONObject) {
        float f = simpleJSONObject.get("mean", 0.0f);
        float f2 = simpleJSONObject.get("stddev", 0.0f);
        return new GaussianDistribution(f, f2);
    }

    public GaussianDistribution(float f, float f2) {
        this.mean = f;
        this.stddev = f2;
    }

    @Override
    public float generate(Particle particle) {
        return Game.dice.gaussian(this.mean, this.stddev);
    }

    @Override
    public DistributionOneValue getCopyIfHasState() {
        return this;
    }
}

