/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionTwoValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SimpleJSONObject;

public class GaussianAngleDistribution
implements DistributionTwoValue {
    private static final float twoPi = (float)Math.PI * 2;
    private final float mean;
    private final float stddev;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("mean", Float.valueOf(this.mean));
        jSONOrderedObject.put("stddev", Float.valueOf(this.stddev));
        return jSONOrderedObject;
    }

    public static GaussianAngleDistribution load(SimpleJSONObject simpleJSONObject) {
        float f = simpleJSONObject.get("mean", 0.0f);
        float f2 = simpleJSONObject.get("stddev", 0.0f);
        return new GaussianAngleDistribution(f, f2);
    }

    public GaussianAngleDistribution(float f, float f2) {
        this.mean = f;
        this.stddev = f2;
    }

    @Override
    public float[] generate(Particle particle) {
        float f = Game.dice.rand(0.0f, (float)Math.PI * 2);
        float f2 = Game.dice.gaussian(this.mean, this.stddev);
        float[] fArray = new float[]{(float)Math.cos(f) * f2, (float)Math.sin(f) * f2, f2, f};
        return fArray;
    }

    @Override
    public DistributionTwoValue getCopyIfHasState() {
        return this;
    }
}

