/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.DistributionBase;
import net.sf.hale.particle.DistributionOneValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONObject;

public class FixedDistributionWithBase
implements DistributionOneValue {
    private final DistributionBase base;
    private final float multiplier;
    private final float offset;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("multiplier", Float.valueOf(this.multiplier));
        jSONOrderedObject.put("offset", Float.valueOf(this.offset));
        jSONOrderedObject.put("base", this.base.save());
        return jSONOrderedObject;
    }

    public static DistributionOneValue load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        float f = simpleJSONObject.get("multiplier", 0.0f);
        float f2 = simpleJSONObject.get("offset", 0.0f);
        DistributionBase distributionBase = (DistributionBase)SaveGameUtil.loadObject(simpleJSONObject.getObject("base"));
        return new FixedDistributionWithBase(distributionBase, f, f2);
    }

    public FixedDistributionWithBase(DistributionBase distributionBase, float f, float f2) {
        this.base = distributionBase;
        this.multiplier = f;
        this.offset = f2;
    }

    @Override
    public float generate(Particle particle) {
        return this.base.getBase(particle) * this.multiplier + this.offset;
    }

    @Override
    public DistributionOneValue getCopyIfHasState() {
        return this;
    }
}

