/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionTwoValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SimpleJSONObject;

public class FixedAngleDistribution
implements DistributionTwoValue {
    private final float magnitudeMin;
    private final float magnitudeMax;
    private final float angle;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("magnitudeMin", Float.valueOf(this.magnitudeMin));
        jSONOrderedObject.put("magnitudeMax", Float.valueOf(this.magnitudeMax));
        jSONOrderedObject.put("angle", Float.valueOf(this.angle));
        return jSONOrderedObject;
    }

    public static DistributionTwoValue load(SimpleJSONObject simpleJSONObject) {
        float f = simpleJSONObject.get("magnitudeMin", 0.0f);
        float f2 = simpleJSONObject.get("magnitudeMax", 0.0f);
        float f3 = simpleJSONObject.get("angle", 0.0f);
        return new FixedAngleDistribution(f, f2, f3);
    }

    public FixedAngleDistribution(float f, float f2, float f3) {
        this.magnitudeMin = f;
        this.magnitudeMax = f2;
        this.angle = f3;
    }

    @Override
    public float[] generate(Particle particle) {
        float f = Game.dice.rand(this.magnitudeMin, this.magnitudeMax);
        float[] fArray = new float[]{(float)Math.cos(this.angle) * f, (float)Math.sin(this.angle) * f, f, this.angle};
        return fArray;
    }

    @Override
    public DistributionTwoValue getCopyIfHasState() {
        return this;
    }
}

