/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.particle.DistributionTwoValue;
import net.sf.hale.particle.Particle;
import net.sf.hale.util.SimpleJSONObject;

public class EquallySpacedAngleDistribution
implements DistributionTwoValue {
    private final float angleStepSize;
    private final float magnitudeStepSize;
    private final float particlesPerRadius;
    private final float jitter;
    private int count;
    private float curMagnitude;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("angleStepSize", Float.valueOf(this.angleStepSize));
        jSONOrderedObject.put("magnitudeStepSize", Float.valueOf(this.magnitudeStepSize));
        jSONOrderedObject.put("particlesPerRadius", Float.valueOf(this.particlesPerRadius));
        jSONOrderedObject.put("jitter", Float.valueOf(this.jitter));
        jSONOrderedObject.put("count", this.count);
        jSONOrderedObject.put("curMagnitude", Float.valueOf(this.curMagnitude));
        return jSONOrderedObject;
    }

    public static DistributionTwoValue load(SimpleJSONObject simpleJSONObject) {
        float f = simpleJSONObject.get("angleStepSize", 0.0f);
        float f2 = simpleJSONObject.get("magnitudeStepSize", 0.0f);
        float f3 = simpleJSONObject.get("particlesPerRadius", 0.0f);
        float f4 = simpleJSONObject.get("jitter", 0.0f);
        EquallySpacedAngleDistribution equallySpacedAngleDistribution = new EquallySpacedAngleDistribution(f, f2, f3, f4);
        equallySpacedAngleDistribution.count = simpleJSONObject.get("count", 0);
        equallySpacedAngleDistribution.curMagnitude = simpleJSONObject.get("curMagnitude", 0.0f);
        return equallySpacedAngleDistribution;
    }

    private EquallySpacedAngleDistribution(float f, float f2, float f3, float f4) {
        this.angleStepSize = f;
        this.magnitudeStepSize = f2;
        this.particlesPerRadius = f3;
        this.jitter = f4;
    }

    public EquallySpacedAngleDistribution(float f, float f2, float f3, float f4, float f5) {
        this.magnitudeStepSize = f3;
        this.jitter = f5;
        this.particlesPerRadius = f2 == f ? f4 : f4 / ((f2 - f) / f3);
        this.angleStepSize = (float)Math.PI * 2 / this.particlesPerRadius;
        this.count = 0;
        this.curMagnitude = f;
    }

    public EquallySpacedAngleDistribution(EquallySpacedAngleDistribution equallySpacedAngleDistribution) {
        this.angleStepSize = equallySpacedAngleDistribution.angleStepSize;
        this.magnitudeStepSize = equallySpacedAngleDistribution.magnitudeStepSize;
        this.particlesPerRadius = equallySpacedAngleDistribution.particlesPerRadius;
        this.jitter = equallySpacedAngleDistribution.jitter;
        this.count = equallySpacedAngleDistribution.count;
        this.curMagnitude = equallySpacedAngleDistribution.curMagnitude;
    }

    @Override
    public float[] generate(Particle particle) {
        float f = this.angleStepSize * (float)this.count;
        float f2 = this.curMagnitude + Game.dice.rand(0.0f, this.jitter);
        float[] fArray = new float[]{(float)Math.cos(f) * f2, (float)Math.sin(f) * f2, f2, f};
        ++this.count;
        if ((float)this.count >= this.particlesPerRadius) {
            this.count = 0;
            this.curMagnitude += this.magnitudeStepSize;
        }
        return fArray;
    }

    @Override
    public DistributionTwoValue getCopyIfHasState() {
        return new EquallySpacedAngleDistribution(this);
    }
}

