/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.Animated;
import net.sf.hale.particle.Particle;
import net.sf.hale.particle.ParticleGenerator;
import net.sf.hale.util.SimpleJSONObject;

public class CircleParticleGenerator
extends ParticleGenerator {
    private float minBound;
    private float maxBound;
    private static final float twoPi = (float)Math.PI * 2;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("minCircleBound", Float.valueOf(this.minBound));
        jSONOrderedObject.put("maxCircleBound", Float.valueOf(this.maxBound));
        return jSONOrderedObject;
    }

    public static ParticleGenerator load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        ParticleGenerator.Mode mode = ParticleGenerator.Mode.valueOf(simpleJSONObject.get("generatorMode", null));
        String string = simpleJSONObject.get("sprite", null);
        float f = simpleJSONObject.get("numParticles", 0.0f);
        CircleParticleGenerator circleParticleGenerator = new CircleParticleGenerator(mode, string, f);
        circleParticleGenerator.loadBase(simpleJSONObject);
        circleParticleGenerator.minBound = simpleJSONObject.get("minCircleBound", 0.0f);
        circleParticleGenerator.maxBound = simpleJSONObject.get("maxCircleBound", 0.0f);
        return circleParticleGenerator;
    }

    public CircleParticleGenerator(ParticleGenerator.Mode mode, String string, float f) {
        super(mode, string, f);
    }

    public CircleParticleGenerator(CircleParticleGenerator circleParticleGenerator) {
        super(circleParticleGenerator);
        this.minBound = circleParticleGenerator.minBound;
        this.maxBound = circleParticleGenerator.maxBound;
    }

    public void setCircleBounds(float f, float f2) {
        this.minBound = f;
        this.maxBound = f2;
    }

    @Override
    public void offsetPosition(float f, float f2) {
        super.offsetPosition(f, f2);
    }

    @Override
    public boolean initialize() {
        return super.initialize();
    }

    @Override
    protected void setParticlePosition(Particle particle) {
        float f = Game.dice.rand(0.0f, (float)Math.PI * 2);
        float f2 = Game.dice.rand(this.minBound, this.maxBound);
        particle.setPosition((float)Math.cos(f) * f2 + this.getX(), (float)Math.sin(f) * f2 + this.getY());
    }

    @Override
    public Animated getCopy() {
        return new CircleParticleGenerator(this);
    }
}

