/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import java.awt.Color;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONObject;

public abstract class AnimationBase
implements Saveable {
    private final int halfWidth;
    private final int halfHeight;
    private float r;
    private float g;
    private float b;
    private float a;
    private float vr;
    private float vg;
    private float vb;
    private float va;
    private float r2;
    private float g2;
    private float b2;
    private float vr2;
    private float vg2;
    private float vb2;
    private float positionX;
    private float positionY;
    private float velocityX;
    private float velocityY;
    private float speed;
    private float velocityAngle;
    private float rotation;
    private float rotationSpeed;
    private float secondsRemaining;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("color", this.getColorString(new Color(this.r, this.g, this.b, this.a)));
        jSONOrderedObject.put("colorVelocity", this.getColorString(new Color(this.vr, this.vg, this.vb, this.va)));
        jSONOrderedObject.put("secondaryColor", this.getColorString(new Color(this.r2, this.g2, this.b2)));
        jSONOrderedObject.put("secondaryColorVelocity", this.getColorString(new Color(this.vr2, this.vg2, this.vb2)));
        jSONOrderedObject.put("positionX", Float.valueOf(this.positionX));
        jSONOrderedObject.put("positionY", Float.valueOf(this.positionY));
        jSONOrderedObject.put("velocityX", Float.valueOf(this.velocityX));
        jSONOrderedObject.put("velocityY", Float.valueOf(this.velocityY));
        jSONOrderedObject.put("rotation", Float.valueOf(this.rotation));
        jSONOrderedObject.put("rotationSpeed", Float.valueOf(this.rotationSpeed));
        jSONOrderedObject.put("secondsRemaining", Float.valueOf(this.secondsRemaining));
        return jSONOrderedObject;
    }

    protected final void loadBase(SimpleJSONObject simpleJSONObject) {
        this.secondsRemaining = simpleJSONObject.get("secondsRemaining", 0.0f);
        this.rotationSpeed = simpleJSONObject.get("rotationSpeed", 0.0f);
        this.rotation = simpleJSONObject.get("rotation", 0.0f);
        this.velocityY = simpleJSONObject.get("velocityY", 0.0f);
        this.velocityX = simpleJSONObject.get("velocityX", 0.0f);
        this.positionX = simpleJSONObject.get("positionX", 0.0f);
        this.positionY = simpleJSONObject.get("positionY", 0.0f);
        String string = simpleJSONObject.get("color", null);
        de.matthiasmann.twl.Color color = de.matthiasmann.twl.Color.parserColor((String)string);
        this.r = color.getRedFloat();
        this.g = color.getGreenFloat();
        this.b = color.getBlueFloat();
        this.a = color.getAlphaFloat();
        String string2 = simpleJSONObject.get("colorVelocity", null);
        de.matthiasmann.twl.Color color2 = de.matthiasmann.twl.Color.parserColor((String)string2);
        this.vr = color2.getRedFloat();
        this.vg = color2.getGreenFloat();
        this.vb = color2.getBlueFloat();
        this.va = color2.getAlphaFloat();
        String string3 = simpleJSONObject.get("secondaryColor", null);
        de.matthiasmann.twl.Color color3 = de.matthiasmann.twl.Color.parserColor((String)string3);
        this.r2 = color3.getRedFloat();
        this.g2 = color3.getGreenFloat();
        this.b2 = color3.getBlueFloat();
        String string4 = simpleJSONObject.get("secondaryColorVelocity", null);
        de.matthiasmann.twl.Color color4 = de.matthiasmann.twl.Color.parserColor((String)string4);
        this.vr2 = color4.getRedFloat();
        this.vg2 = color4.getGreenFloat();
        this.vb2 = color4.getBlueFloat();
    }

    private String getColorString(Color color) {
        return '#' + String.format("%08x", color.getRGB());
    }

    public AnimationBase(int n, int n2) {
        this.halfWidth = n;
        this.halfHeight = n2;
        this.rotation = 0.0f;
    }

    public AnimationBase(AnimationBase animationBase) {
        this.halfWidth = animationBase.halfWidth;
        this.halfHeight = animationBase.halfHeight;
        this.r = animationBase.r;
        this.g = animationBase.g;
        this.b = animationBase.b;
        this.a = animationBase.a;
        this.vr = animationBase.vr;
        this.vg = animationBase.vg;
        this.vb = animationBase.vb;
        this.va = animationBase.va;
        this.r2 = animationBase.r2;
        this.g2 = animationBase.g2;
        this.b2 = animationBase.b2;
        this.vr2 = animationBase.vr2;
        this.vg2 = animationBase.vg2;
        this.vb2 = animationBase.vb2;
        this.positionX = animationBase.positionX;
        this.positionY = animationBase.positionY;
        this.velocityX = animationBase.velocityX;
        this.velocityY = animationBase.velocityY;
        this.speed = animationBase.speed;
        this.velocityAngle = animationBase.velocityAngle;
        this.secondsRemaining = animationBase.secondsRemaining;
    }

    public boolean elapseTime(float f) {
        this.rotation += this.rotationSpeed * f;
        this.positionX += this.velocityX * f;
        this.positionY += this.velocityY * f;
        this.r += this.vr * f;
        this.g += this.vg * f;
        this.b += this.vb * f;
        this.a += this.va * f;
        this.r2 += this.vr2 * f;
        this.g2 += this.vg2 * f;
        this.b2 += this.vb2 * f;
        this.secondsRemaining -= f;
        return this.secondsRemaining <= 0.0f;
    }

    public final void setRotation(float f) {
        this.rotation = f;
    }

    public final void setRotationSpeed(float f) {
        this.rotationSpeed = f;
    }

    public final void offsetPosition(float f, float f2) {
        this.positionX += f;
        this.positionY += f2;
    }

    public final void setPosition(Point point) {
        this.positionX = point.x;
        this.positionY = point.y;
    }

    public final void setPosition(float f, float f2) {
        this.positionX = f;
        this.positionY = f2;
    }

    public final void setSecondaryRed(float f) {
        this.r2 = f;
    }

    public final void setSecondaryGreen(float f) {
        this.g2 = f;
    }

    public final void setSecondaryBlue(float f) {
        this.b2 = f;
    }

    public final void setSecondaryRedSpeed(float f) {
        this.vr2 = f;
    }

    public final void setSecondaryGreenSpeed(float f) {
        this.vg2 = f;
    }

    public final void setSecondaryBlueSpeed(float f) {
        this.vb2 = f;
    }

    public final void setRed(float f) {
        this.r = f;
    }

    public final void setGreen(float f) {
        this.g = f;
    }

    public final void setBlue(float f) {
        this.b = f;
    }

    public final void setAlpha(float f) {
        this.a = f;
    }

    public final void setAlphaSpeed(float f) {
        this.va = f;
    }

    public final void setRedSpeed(float f) {
        this.vr = f;
    }

    public final void setGreenSpeed(float f) {
        this.vg = f;
    }

    public final void setBlueSpeed(float f) {
        this.vb = f;
    }

    public void setDuration(float f) {
        this.secondsRemaining = f;
    }

    public final void setVelocity(float[] fArray) {
        this.velocityX = fArray[0];
        this.velocityY = fArray[1];
        this.speed = fArray[2];
        this.velocityAngle = fArray[3];
    }

    public final void setVelocity(float f, float f2) {
        this.velocityX = f;
        this.velocityY = f2;
        this.speed = (float)Math.sqrt(f * f + f2 * f2);
        this.velocityAngle = (float)Math.atan(f2 / f);
    }

    public final void setVelocityMagnitudeAngle(float f, float f2) {
        this.speed = f;
        this.velocityAngle = f2;
        this.velocityX = (float)Math.cos(f2) * f;
        this.velocityY = (float)Math.sin(f2) * f;
    }

    public void finish() {
        this.secondsRemaining = 0.0f;
    }

    public final int getHalfWidth() {
        return this.halfWidth;
    }

    public final int getHalfHeight() {
        return this.halfHeight;
    }

    public final float getR() {
        return this.r;
    }

    public final float getG() {
        return this.g;
    }

    public final float getB() {
        return this.b;
    }

    public final float getA() {
        return this.a;
    }

    public final float getR2() {
        return this.r2;
    }

    public final float getG2() {
        return this.g2;
    }

    public final float getB2() {
        return this.b2;
    }

    public final float getX() {
        return this.positionX;
    }

    public final float getY() {
        return this.positionY;
    }

    public final float getVX() {
        return this.velocityX;
    }

    public final float getVY() {
        return this.velocityY;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final float getVelocityAngle() {
        return this.velocityAngle;
    }

    public final float getSecondsRemaining() {
        return this.secondsRemaining;
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final float getRotationSpeed() {
        return this.rotationSpeed;
    }
}

