/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.particle;

import de.matthiasmann.twl.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.particle.Animated;
import net.sf.hale.particle.AnimationBase;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class Animation
extends AnimationBase
implements Animated {
    private Animated.DrawingMode drawingMode;
    private final List<AnimationFrame> frames;
    private float frameDuration;
    private final int width;
    private final int height;
    private int currentFrameIndex;
    private int numLoops;
    private final String textureSprite;
    private final int halfWidth;
    private final int halfHeight;
    private int texture;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("texture", this.textureSprite);
        jSONOrderedObject.put("frameDuration", Float.valueOf(this.frameDuration));
        jSONOrderedObject.put("drawingMode", this.drawingMode.toString());
        jSONOrderedObject.put("currentFrame", this.currentFrameIndex);
        jSONOrderedObject.put("numLoops", this.numLoops);
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.frames.size()];
        int n = 0;
        for (AnimationFrame animationFrame : this.frames) {
            jSONOrderedObjectArray[n] = new JSONOrderedObject();
            jSONOrderedObjectArray[n].put("initialDuration", Float.valueOf(animationFrame.initialDuration));
            jSONOrderedObjectArray[n].put("duration", Float.valueOf(animationFrame.duration));
            jSONOrderedObjectArray[n].put("texCoordStartX", animationFrame.texCoordStartX);
            jSONOrderedObjectArray[n].put("texCoordStartY", animationFrame.texCoordStartY);
            jSONOrderedObjectArray[n].put("texCoordEndX", animationFrame.texCoordEndX);
            jSONOrderedObjectArray[n].put("texCoordEndY", animationFrame.texCoordEndY);
            ++n;
        }
        jSONOrderedObject.put("frames", jSONOrderedObjectArray);
        return jSONOrderedObject;
    }

    public static Animated load(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        float f = simpleJSONObject.get("frameDuration", 0.0f);
        String string = simpleJSONObject.get("texture", null);
        Animation animation = new Animation(string, f);
        animation.frames.clear();
        animation.loadBase(simpleJSONObject);
        animation.drawingMode = Animated.DrawingMode.valueOf(simpleJSONObject.get("drawingMode", null));
        animation.currentFrameIndex = simpleJSONObject.get("currentFrame", 0);
        animation.numLoops = simpleJSONObject.get("numLoops", 0);
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("frames")) {
            SimpleJSONObject simpleJSONObject2 = simpleJSONArrayEntry.getObject();
            float f2 = simpleJSONObject2.get("initialDuration", 0.0f);
            float f3 = simpleJSONObject2.get("texCoordStartX", 0.0f);
            float f4 = simpleJSONObject2.get("texCoordStartY", 0.0f);
            float f5 = simpleJSONObject2.get("texCoordEndX", 0.0f);
            float f6 = simpleJSONObject2.get("texCoordEndY", 0.0f);
            Animation animation2 = animation;
            animation2.getClass();
            AnimationFrame animationFrame = animation2.new AnimationFrame(f3, f4, f5, f6, f2);
            animationFrame.duration = simpleJSONObject2.get("duration", 0.0f);
            animation.frames.add(animationFrame);
        }
        return animation;
    }

    public Animation(Animation animation) {
        super(animation);
        this.width = animation.width;
        this.height = animation.height;
        this.halfWidth = animation.halfWidth;
        this.halfHeight = animation.halfHeight;
        this.texture = animation.texture;
        this.textureSprite = animation.textureSprite;
        this.frameDuration = animation.frameDuration;
        this.frames = new ArrayList<AnimationFrame>();
        for (AnimationFrame animationFrame : animation.frames) {
            this.frames.add(new AnimationFrame(animationFrame));
        }
        this.drawingMode = animation.drawingMode;
    }

    public Animation(String string, float f) {
        this(SpriteManager.getSprite(string), f, string);
    }

    public Animation(String string) {
        this(SpriteManager.getSprite(string), 0.0f, string);
    }

    public Animation(SimpleIcon simpleIcon) {
        this(SpriteManager.getSprite(simpleIcon.getSpriteID()), 0.0f, simpleIcon.getSpriteID());
        this.setColor(simpleIcon.getColor());
    }

    public Animation(Sprite sprite, float f, String string) {
        super(sprite.getWidth() / 2, sprite.getHeight() / 2);
        this.drawingMode = Animated.DrawingMode.AboveEntities;
        this.textureSprite = string;
        this.texture = sprite.getTextureReference();
        this.width = sprite.getWidth();
        this.height = sprite.getHeight();
        this.halfWidth = this.width / 2;
        this.halfHeight = this.height / 2;
        this.frameDuration = f;
        this.frames = new ArrayList<AnimationFrame>();
        this.frames.add(new AnimationFrame(sprite.getTexCoordStartX(), sprite.getTexCoordStartY(), sprite.getTexCoordEndX(), sprite.getTexCoordEndY(), this.frameDuration));
        this.setRed(1.0f);
        this.setBlue(1.0f);
        this.setGreen(1.0f);
        this.setAlpha(1.0f);
        this.setDuration(this.frameDuration);
    }

    @Override
    public void cacheSprite() {
        Sprite sprite = SpriteManager.getSprite(this.textureSprite);
        this.texture = sprite.getTextureReference();
    }

    public void setLoopInfinite() {
        this.numLoops = Integer.MAX_VALUE;
    }

    public float getLoopLength() {
        float f = 0.0f;
        for (AnimationFrame animationFrame : this.frames) {
            f += animationFrame.duration;
        }
        return f;
    }

    public void setDrawingMode(String string) {
        this.drawingMode = Animated.DrawingMode.valueOf(string);
    }

    @Override
    public Animated.DrawingMode getDrawingMode() {
        return this.drawingMode;
    }

    @Override
    public void setDuration(float f) {
        super.setDuration(f);
        float f2 = f / this.getLoopLength();
        this.numLoops = (int)f2 + 1;
    }

    @Override
    public void setDurationInfinite() {
        super.setDuration(Float.MAX_VALUE);
        this.frameDuration = Float.MAX_VALUE;
        if (this.frames.size() == 1) {
            this.frames.get(0).duration = Float.MAX_VALUE;
        } else {
            this.numLoops = Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean initialize() {
        if (this.getSecondsRemaining() == 0.0f) {
            super.setDuration(this.getLoopLength() * (float)this.numLoops);
        }
        return true;
    }

    @Override
    public boolean isDrawable() {
        return this.frames.size() > 0;
    }

    public void clearFrames() {
        this.frames.clear();
    }

    public void addFrameAndSetColor(Icon icon) {
        if (!(icon instanceof SimpleIcon)) {
            return;
        }
        SimpleIcon simpleIcon = (SimpleIcon)icon;
        this.addFrame(simpleIcon.getSpriteID());
        this.setColor(simpleIcon.getColor());
    }

    public void addFrame(String string) {
        if (string == null) {
            return;
        }
        this.addFrame(SpriteManager.getSprite(string), this.frameDuration);
    }

    public void addFrame(String string, float f) {
        if (string == null) {
            return;
        }
        this.addFrame(SpriteManager.getSprite(string), f);
    }

    public void addFrame(Sprite sprite, float f) {
        this.frames.add(new AnimationFrame(sprite.getTexCoordStartX(), sprite.getTexCoordStartY(), sprite.getTexCoordEndX(), sprite.getTexCoordEndY(), f));
    }

    public void addFrames(String string, int n, int n2) {
        this.addFrames(string, n, n2, 1, this.frameDuration);
    }

    public void addFrames(String string, int n, int n2, int n3) {
        this.addFrames(string, n, n2, n3, this.frameDuration);
    }

    public void addFrames(String string, int n, int n2, int n3, float f) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumIntegerDigits(n3);
        for (int i = n; i <= n2; ++i) {
            String string2 = string + decimalFormat.format(i);
            Sprite sprite = SpriteManager.getSprite(string2);
            this.addFrame(sprite, f);
        }
    }

    @Override
    public boolean elapseTime(float f) {
        AnimationFrame animationFrame = this.frames.get(this.currentFrameIndex);
        if (animationFrame.duration != 0.0f) {
            AnimationFrame animationFrame2 = animationFrame;
            animationFrame2.duration = animationFrame2.duration - f;
            while (animationFrame.duration < 0.0f) {
                if (this.currentFrameIndex == this.frames.size() - 1) {
                    --this.numLoops;
                    if (this.numLoops < 1) {
                        return true;
                    }
                    this.currentFrameIndex = 0;
                } else {
                    ++this.currentFrameIndex;
                }
                float f2 = animationFrame.duration;
                animationFrame.resetDuration();
                AnimationFrame animationFrame3 = animationFrame = this.frames.get(this.currentFrameIndex);
                animationFrame3.duration = animationFrame3.duration + f2;
            }
        }
        return super.elapseTime(f);
    }

    @Override
    public final void draw() {
        GL11.glColor4f((float)this.getR(), (float)this.getG(), (float)this.getB(), (float)this.getA());
        GL14.glSecondaryColor3f((float)this.getR2(), (float)this.getG2(), (float)this.getB2());
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.getX(), (float)this.getY(), (float)0.0f);
        if (this.getRotation() != 0.0f) {
            GL11.glRotatef((float)this.getRotation(), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        AnimationFrame animationFrame = this.frames.get(this.currentFrameIndex);
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)animationFrame.texCoordStartX, (double)animationFrame.texCoordStartY);
        GL11.glVertex2i((int)(-this.halfWidth), (int)(-this.halfHeight));
        GL11.glTexCoord2d((double)animationFrame.texCoordEndX, (double)animationFrame.texCoordStartY);
        GL11.glVertex2i((int)this.halfWidth, (int)(-this.halfHeight));
        GL11.glTexCoord2d((double)animationFrame.texCoordEndX, (double)animationFrame.texCoordEndY);
        GL11.glVertex2i((int)this.halfWidth, (int)this.halfHeight);
        GL11.glTexCoord2d((double)animationFrame.texCoordStartX, (double)animationFrame.texCoordEndY);
        GL11.glVertex2i((int)(-this.halfWidth), (int)this.halfHeight);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.setRed(color.getRedFloat());
        this.setGreen(color.getGreenFloat());
        this.setBlue(color.getBlueFloat());
    }

    @Override
    public Animated getCopy() {
        return new Animation(this);
    }

    private class AnimationFrame {
        private final double texCoordStartX;
        private final double texCoordStartY;
        private final double texCoordEndX;
        private final double texCoordEndY;
        private float duration;
        private final float initialDuration;

        private AnimationFrame(double d, double d2, double d3, double d4, float f) {
            this.texCoordStartX = d;
            this.texCoordStartY = d2;
            this.texCoordEndX = d3;
            this.texCoordEndY = d4;
            this.duration = f;
            this.initialDuration = f;
        }

        private AnimationFrame(AnimationFrame animationFrame) {
            this.texCoordStartX = animationFrame.texCoordStartX;
            this.texCoordStartY = animationFrame.texCoordStartY;
            this.texCoordEndX = animationFrame.texCoordEndX;
            this.texCoordEndY = animationFrame.texCoordEndY;
            this.duration = animationFrame.duration;
            this.initialDuration = animationFrame.initialDuration;
        }

        private void resetDuration() {
            this.duration = this.initialDuration;
        }
    }
}

