/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Widget;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.sf.hale.Game;
import net.sf.hale.mainmenu.MainMenu;
import net.sf.hale.mainmenu.UpdatePopup;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;

public class Updater
extends Thread {
    private String argument;
    private String updaterCommand;
    private boolean canceled;
    private UpdatePopup popup;

    public Updater() {
        try {
            this.argument = Game.getProgramCommand();
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error getting program restart command", iOException);
        }
        this.updaterCommand = System.getProperty("java.home") + "/bin/java -jar updater.jar " + this.argument;
    }

    public void cancel() {
        this.canceled = true;
    }

    public void runUpdater(MainMenu mainMenu) {
        this.popup = new UpdatePopup((Widget)mainMenu, this);
        this.popup.openPopupCentered();
        this.start();
    }

    private void finish() {
        new File(Game.getConfigBaseDirectory() + "updateAvailable.txt").delete();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(Updater.this.updaterCommand);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        System.exit(0);
    }

    private void downloadUpdater(String string) {
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            File file = new File("updater.jar");
            file.delete();
            bufferedInputStream = new BufferedInputStream(new URL(string).openStream());
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[2048];
            while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1 && !this.canceled) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error downloading updater", exception);
        }
        try {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error closing stream", exception);
        }
    }

    @Override
    public void run() {
        this.popup.updateCurrentTask("Checking updater version.");
        String string = FileUtil.getMD5Sum(new File("updater.jar"));
        String string2 = null;
        String string3 = null;
        InputStream inputStream = null;
        try {
            inputStream = new URL("http://www.halegame.com/updater-version.txt").openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            string2 = bufferedReader.readLine().toUpperCase();
            string3 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error checking updater version", exception);
            this.popup.updateCurrentTask("Error: Unable to update.");
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Logger.appendToErrorLog("Error closing input stream while checking for updater version", iOException);
            }
        }
        if (this.canceled) {
            return;
        }
        if (!string.equals(string2)) {
            this.popup.updateCurrentTask("Downloading updater.");
            this.downloadUpdater(string3);
            if (this.canceled) {
                return;
            }
            this.finish();
        } else {
            this.finish();
        }
    }
}

