/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import net.sf.hale.mainmenu.Updater;

public class UpdatePopup
extends PopupWindow {
    private Updater updater;
    private String currentTaskUpdate;
    private Content content;

    public UpdatePopup(Widget widget, Updater updater) {
        super(widget);
        this.updater = updater;
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(false);
        this.content = new Content();
        this.add(this.content);
    }

    public void paint(GUI gUI) {
        super.paint(gUI);
        if (this.currentTaskUpdate != null) {
            this.content.currentTask.setText(this.currentTaskUpdate);
            this.currentTaskUpdate = null;
        }
    }

    public void updateCurrentTask(String string) {
        this.currentTaskUpdate = string;
    }

    private class Content
    extends Widget {
        private Label title = new Label();
        private Label currentTask;
        private Button cancel;
        private int titleGap;

        private Content() {
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.currentTask = new Label();
            this.currentTask.setTheme("currenttasklabel");
            this.add((Widget)this.currentTask);
            this.cancel = new Button();
            this.cancel.setTheme("cancelbutton");
            this.cancel.addCallback(new Runnable(){

                @Override
                public void run() {
                    UpdatePopup.this.updater.cancel();
                    UpdatePopup.this.closePopup();
                }
            });
            this.add((Widget)this.cancel);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.titleGap = themeInfo.getParameter("titlegap", 0);
        }

        protected void layout() {
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.currentTask.setSize(this.currentTask.getPreferredWidth(), this.currentTask.getPreferredHeight());
            this.cancel.setSize(this.cancel.getPreferredWidth(), this.cancel.getPreferredHeight());
            this.title.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - this.title.getWidth() / 2, this.getInnerY());
            this.currentTask.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - this.currentTask.getWidth() / 2, this.title.getBottom() + this.titleGap);
            this.cancel.setPosition(this.getInnerRight() - this.cancel.getWidth(), this.getInnerBottom() - this.cancel.getHeight());
        }
    }
}

