/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.PC;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.Race;
import net.sf.hale.rules.Ruleset;

public class UniqueCharacter
implements Iterable<PC> {
    private final List<PC> pcs = new ArrayList<PC>();
    private final String portraitID;
    private final String name;
    private final Ruleset.Gender gender;
    private final Race race;
    private int minLevel;
    private int maxLevel;

    public UniqueCharacter(PC pC) {
        this.pcs.add(pC);
        this.portraitID = pC.getTemplate().getPortrait();
        this.name = pC.getTemplate().getName();
        this.gender = pC.getTemplate().getGender();
        this.race = pC.getTemplate().getRace();
        this.setMinMaxLevel();
    }

    public int size() {
        return this.pcs.size();
    }

    public void setMinMaxLevel() {
        this.minLevel = Game.curCampaign.allowLevelUp() ? 1 : Game.curCampaign.getMinStartingLevel();
        this.maxLevel = Game.curCampaign.getMaxStartingLevel();
    }

    public boolean meetsLevelConstraints(PC pC) {
        int n = pC.roles.getTotalLevel();
        return n >= this.minLevel && n <= this.maxLevel;
    }

    public PC getFirstCreature() {
        return this.pcs.get(0);
    }

    public PC getBestCreature() {
        int n = -1;
        PC pC = null;
        for (PC pC2 : this.pcs) {
            int n2 = pC2.roles.getTotalLevel();
            if (n2 <= n || n2 < this.minLevel || n2 > this.maxLevel) continue;
            n = n2;
            pC = pC2;
        }
        return pC;
    }

    public boolean addIfMatches(PC pC) {
        if (!this.portraitID.equals(pC.getTemplate().getPortrait())) {
            return false;
        }
        if (!this.name.equals(pC.getTemplate().getName())) {
            return false;
        }
        if (this.gender != pC.getTemplate().getGender()) {
            return false;
        }
        if (this.race != pC.getTemplate().getRace()) {
            return false;
        }
        this.pcs.add(pC);
        return true;
    }

    public void deleteCreature(PC pC) {
        int n = this.pcs.indexOf(pC);
        if (n == -1) {
            return;
        }
        String string = Game.getCharactersBaseDirectory() + pC.getTemplate().getID() + ResourceType.JSON.getExtension();
        new File(string).delete();
        this.pcs.remove(n);
    }

    @Override
    public Iterator<PC> iterator() {
        return this.pcs.iterator();
    }
}

