/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import net.sf.hale.Game;
import net.sf.hale.mainmenu.AbstractSaveGamePopup;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SaveFileHeader;
import net.sf.hale.util.SaveGameUtil;

public class SaveGameSelector
extends AbstractSaveGamePopup.Selector {
    private String saveGame;
    private Label name;
    private Label date;
    private Label partyName;
    private Label partyLevel;
    private Label area;
    private int nameDateGap;
    private int partyLevelGap;
    private boolean versionIDMatchesCurrentVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveGameSelector(String string, DateFormat dateFormat) {
        this.saveGame = string;
        File file = SaveGameUtil.getSaveFile(string);
        Date date = new Date(file.lastModified());
        this.name = new Label(string);
        this.name.setTheme("namelabel");
        this.add((Widget)this.name);
        this.date = new Label(dateFormat.format(date));
        this.date.setTheme("datelabel");
        this.add((Widget)this.date);
        this.partyName = new Label();
        this.partyName.setTheme("partynamelabel");
        this.add((Widget)this.partyName);
        this.partyLevel = new Label();
        this.partyLevel.setTheme("partylevellabel");
        this.add((Widget)this.partyLevel);
        this.area = new Label();
        this.area.setTheme("arealabel");
        this.add((Widget)this.area);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            SaveFileHeader saveFileHeader = SaveFileHeader.read(gZIPInputStream);
            fileInputStream.close();
            this.partyName.setText(saveFileHeader.getPartyNamesString());
            this.partyLevel.setText("Level " + saveFileHeader.getPartyLevel());
            this.area.setText(saveFileHeader.getAreaName());
            String string2 = saveFileHeader.getVersionID();
            this.versionIDMatchesCurrentVersion = Game.config.getVersionID().equals(string2);
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error reading header for save game file " + file.getPath(), exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    Logger.appendToErrorLog("Error closing file " + file.getPath(), iOException);
                }
            }
        }
    }

    @Override
    public boolean checkVersionID() {
        return this.versionIDMatchesCurrentVersion;
    }

    @Override
    public String getSaveGame() {
        return this.saveGame;
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.nameDateGap = themeInfo.getParameter("nameDateGap", 0);
        this.partyLevelGap = themeInfo.getParameter("partyLevelGap", 0);
    }

    protected void layout() {
        super.layout();
        int n = this.getInnerY() + this.getInnerHeight() / 2;
        this.name.setPosition(this.getInnerX(), n);
        int n2 = this.getInnerX() + this.name.getPreferredWidth() + this.nameDateGap;
        this.area.setPosition(n2, n);
        this.partyName.setPosition(n2, n - this.partyName.getPreferredHeight());
        this.partyLevel.setPosition(n2 + this.partyName.getPreferredWidth() + this.partyLevelGap, this.partyName.getY());
        this.date.setPosition(n2, n + this.date.getPreferredHeight());
    }

    public int getPreferredHeight() {
        int n = this.name.getPreferredHeight();
        int n2 = this.date.getPreferredHeight() + this.partyName.getPreferredHeight() + this.partyLevel.getPreferredHeight();
        return Math.max(n, n2);
    }
}

