/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.mainmenu.AbstractSaveGamePopup;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.mainmenu.SaveGameSelector;
import net.sf.hale.util.SaveGameUtil;

public class SaveGamePopup
extends AbstractSaveGamePopup
implements Runnable {
    private List<String> currentSaves;
    private AbstractSaveGamePopup.Selector newSaveSelector;
    private Callback callback;
    private String selectedSave;

    public SaveGamePopup(Widget widget) {
        super(widget);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        this.callback.saveGameAccepted(this.selectedSave);
        this.closePopup();
    }

    @Override
    protected void selectionAccepted(AbstractSaveGamePopup.Selector selector) {
        this.selectedSave = selector.getSaveGame();
        if (selector != this.newSaveSelector) {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup(this.getParent());
            confirmationPopup.setTitleText("Overwrite save file " + this.selectedSave + "?");
            confirmationPopup.addCallback(this);
            confirmationPopup.openPopupCentered();
        } else {
            this.callback.saveGameAccepted(this.selectedSave);
            this.closePopup();
        }
    }

    @Override
    protected List<AbstractSaveGamePopup.Selector> getValidSelectors() {
        this.currentSaves = new ArrayList<String>();
        ArrayList<AbstractSaveGamePopup.Selector> arrayList = new ArrayList<AbstractSaveGamePopup.Selector>();
        this.newSaveSelector = new NewSaveSelector();
        arrayList.add(this.newSaveSelector);
        for (String string : SaveGameUtil.getSaveGames()) {
            if (SaveGameUtil.isQuickSave(string)) continue;
            SaveGameSelector saveGameSelector = new SaveGameSelector(string, this.getDateFormat());
            saveGameSelector.addCallback(new AbstractSaveGamePopup.SelectorCallback(this, saveGameSelector));
            arrayList.add(saveGameSelector);
            this.currentSaves.add(string);
        }
        return arrayList;
    }

    private class NewSaveSelector
    extends AbstractSaveGamePopup.Selector
    implements Runnable {
        private Label name;
        private EditField editField;
        private Label error;
        private int editFieldGap;
        private int topRowCenter;

        private NewSaveSelector() {
            this.addCallback(this);
            this.name = new Label();
            this.name.setTheme("namelabel");
            this.add((Widget)this.name);
            this.editField = new EditField();
            this.editField.setTheme("nameeditfield");
            this.editField.addCallback(new EditField.Callback(){

                public void callback(int n) {
                    switch (n) {
                        case 28: {
                            if (!NewSaveSelector.this.editFieldHasValidSaveName()) break;
                            SaveGamePopup.this.selectionAccepted(NewSaveSelector.this);
                            break;
                        }
                        default: {
                            if (NewSaveSelector.this.editFieldHasValidSaveName()) {
                                SaveGamePopup.this.setActiveSelector(NewSaveSelector.this);
                                SaveGamePopup.this.setDeleteEnabled(false);
                                break;
                            }
                            SaveGamePopup.this.setActiveSelector(null);
                            SaveGamePopup.this.setDeleteEnabled(false);
                        }
                    }
                }
            });
            this.add((Widget)this.editField);
            this.error = new Label();
            this.error.setTheme("errorlabel");
            this.add((Widget)this.error);
        }

        private boolean editFieldHasValidSaveName() {
            if (this.editField.getTextLength() == 0) {
                this.error.setText("");
                return false;
            }
            if (this.editField.getTextLength() > 12) {
                this.error.setText("You must use at most 12 characters.");
                return false;
            }
            String string = this.editField.getText();
            for (String string2 : SaveGamePopup.this.currentSaves) {
                if (!string2.equals(string)) continue;
                this.error.setText("A save of that name already exists.");
                return false;
            }
            if (SaveGameUtil.isQuickSave(string)) {
                this.error.setText("Invalid save name.");
                return false;
            }
            for (Object object : (Object)string.toCharArray()) {
                if (Character.isDigit((char)object) || Character.isLetter((char)object) || object == 32 || object == 45 || object == 95 || object == 46) continue;
                this.error.setText("Invalid save name.");
                return false;
            }
            this.error.setText("");
            return true;
        }

        @Override
        public void run() {
            SaveGamePopup.this.setActiveSelector(null);
            SaveGamePopup.this.setDeleteEnabled(false);
            this.setActive(false);
        }

        protected boolean handleEvent(Event event) {
            switch (event.getType()) {
                case KEY_PRESSED: 
                case KEY_RELEASED: {
                    return this.editField.handleEvent(event);
                }
            }
            return super.handleEvent(event);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.editFieldGap = themeInfo.getParameter("editFieldGap", 0);
            this.topRowCenter = themeInfo.getParameter("topRowCenter", 0);
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerY() + this.topRowCenter;
            this.name.setPosition(this.getInnerX(), n);
            this.editField.setSize(this.editField.getPreferredWidth(), this.editField.getPreferredHeight());
            this.editField.setPosition(this.getInnerX() + this.name.getPreferredWidth() + this.editFieldGap, n - this.editField.getHeight() / 2);
            this.error.setPosition(this.editField.getX(), this.editField.getBottom() + this.error.getPreferredHeight() / 2);
        }

        @Override
        public String getSaveGame() {
            return this.editField.getText();
        }
    }

    public static interface Callback {
        public void saveGameAccepted(String var1);
    }
}

