/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.SavedParty;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.PC;
import net.sf.hale.mainmenu.CharacterSelector;
import net.sf.hale.mainmenu.MainMenu;
import net.sf.hale.mainmenu.NewGameWindow;
import net.sf.hale.mainmenu.UniqueCharacter;
import net.sf.hale.resource.ResourceType;

public class PartyFormationWindow
extends Widget {
    private MainMenu mainMenu;
    private NewGameWindow newGameWindow;
    private Label titleLabel;
    private Label nameLabel;
    private EditField nameField;
    private ToggleButton showPregeneratedCharactersButton;
    private Button newCharacterButton;
    private Button cancel;
    private Button accept;
    private Label partySize;
    private Label partyTitle;
    private ScrollPane partyPane;
    private Content partyPaneContent;
    private Label availableTitle;
    private ScrollPane availablePane;
    private Content availablePaneContent;
    private int smallGap;
    private int sectionGap;
    private int selectableWidth;
    private CharacterSelector highlightedSelector;
    private Set<String> charactersInParties;

    public PartyFormationWindow(MainMenu mainMenu, NewGameWindow newGameWindow, Set<String> set) {
        this.charactersInParties = set;
        this.mainMenu = mainMenu;
        this.newGameWindow = newGameWindow;
        mainMenu.setButtonsVisible(false);
        this.titleLabel = new Label();
        this.titleLabel.setTheme("titlelabel");
        this.add((Widget)this.titleLabel);
        this.nameLabel = new Label();
        this.nameLabel.setTheme("namelabel");
        this.add((Widget)this.nameLabel);
        this.nameField = new EditField();
        this.nameField.addCallback(new EditField.Callback(){

            public void callback(int n) {
                PartyFormationWindow.this.setAcceptEnabled();
            }
        });
        this.nameField.setTheme("namefield");
        this.add((Widget)this.nameField);
        this.partyTitle = new Label();
        this.partyTitle.setTheme("partytitlelabel");
        this.add((Widget)this.partyTitle);
        int n = Game.curCampaign.getMinPartySize();
        int n2 = Game.curCampaign.getMaxPartySize();
        String string = n == n2 ? (n == 1 ? "1 Character)" : n + " Characters)") : n + " to " + n2 + " Characters";
        int n3 = Game.curCampaign.allowLevelUp() ? 1 : Game.curCampaign.getMinStartingLevel();
        int n4 = Game.curCampaign.getMaxStartingLevel();
        string = n3 == n4 ? string + " of Level " + n3 + ")" : string + " of Levels " + n3 + " to " + n4 + ")";
        this.partySize = new Label("(Select " + string);
        this.partySize.setTheme("partysizelabel");
        this.add((Widget)this.partySize);
        this.availableTitle = new Label();
        this.availableTitle.setTheme("availabletitlelabel");
        this.add((Widget)this.availableTitle);
        this.showPregeneratedCharactersButton = new ToggleButton();
        this.showPregeneratedCharactersButton.setTheme("showpregeneratedcharactersbutton");
        this.showPregeneratedCharactersButton.setActive(true);
        this.showPregeneratedCharactersButton.addCallback(new Runnable(){

            @Override
            public void run() {
                PartyFormationWindow.this.partyPaneContent.clear();
                PartyFormationWindow.this.populateSelectableList();
            }
        });
        this.add((Widget)this.showPregeneratedCharactersButton);
        this.newCharacterButton = new Button();
        this.newCharacterButton.setTheme("newcharacterbutton");
        this.newCharacterButton.addCallback(new Runnable(){

            @Override
            public void run() {
                PartyFormationWindow.this.showCharacterEditor();
            }
        });
        this.add((Widget)this.newCharacterButton);
        this.cancel = new Button();
        this.cancel.setTheme("cancelbutton");
        this.cancel.addCallback(new Runnable(){

            @Override
            public void run() {
                PartyFormationWindow.this.mainMenu.removeChild(PartyFormationWindow.this);
                PartyFormationWindow.this.mainMenu.setButtonsVisible(true);
            }
        });
        this.add((Widget)this.cancel);
        this.accept = new Button();
        this.accept.setTheme("acceptbutton");
        this.accept.addCallback(new Runnable(){

            @Override
            public void run() {
                PartyFormationWindow.this.acceptParty();
                PartyFormationWindow.this.mainMenu.removeChild(PartyFormationWindow.this);
                PartyFormationWindow.this.mainMenu.setButtonsVisible(true);
            }
        });
        this.add((Widget)this.accept);
        this.partyPaneContent = new Content();
        this.partyPane = new ScrollPane((Widget)this.partyPaneContent);
        this.partyPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.partyPane.setTheme("partypane");
        this.add((Widget)this.partyPane);
        this.availablePaneContent = new Content();
        this.availablePane = new ScrollPane((Widget)this.availablePaneContent);
        this.availablePane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.availablePane.setTheme("selectorpane");
        this.add((Widget)this.availablePane);
        this.populateSelectableList();
        this.setAcceptEnabled();
    }

    public void removeSelector(CharacterSelector characterSelector) {
        this.partyPaneContent.removeSelector(characterSelector);
        this.availablePaneContent.removeSelector(characterSelector);
        this.setAcceptEnabled();
    }

    private List<PC> getPCsInDirectory(String string) {
        ArrayList<PC> arrayList = new ArrayList<PC>();
        File file = new File(string);
        for (String string2 : file.list()) {
            String string3;
            PC pC;
            File file2;
            if (!string2.endsWith(ResourceType.JSON.getExtension()) || !(file2 = new File(string + string2)).isFile() || (pC = EntityManager.getPC(string3 = string2.substring(0, string2.length() - 5))).getTemplate().isPregenerated() && !this.showPregeneratedCharactersButton.isActive()) continue;
            pC.resetTime();
            arrayList.add(pC);
        }
        return arrayList;
    }

    private void populateSelectableList() {
        this.availablePaneContent.clear();
        ArrayList<PC> arrayList = new ArrayList<PC>();
        arrayList.addAll(this.getPCsInDirectory("characters/"));
        arrayList.addAll(this.getPCsInDirectory(Game.getCharactersBaseDirectory()));
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (PC object : arrayList) {
            boolean characterSelector = false;
            for (UniqueCharacter uniqueCharacter : arrayList2) {
                if (!uniqueCharacter.addIfMatches(object)) continue;
                characterSelector = true;
                break;
            }
            if (characterSelector) continue;
            UniqueCharacter uniqueCharacter = new UniqueCharacter(object);
            arrayList2.add(uniqueCharacter);
        }
        for (UniqueCharacter uniqueCharacter : arrayList2) {
            CharacterSelector characterSelector = new CharacterSelector(uniqueCharacter, (Widget)this.mainMenu, this.charactersInParties);
            characterSelector.showDeleteButtons();
            characterSelector.setNewGameWindow(this);
            this.availablePaneContent.addSelector(characterSelector, true, false);
        }
    }

    private void acceptParty() {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CharacterSelector characterSelector : this.partyPaneContent.selectors) {
            arrayList.add(characterSelector.getCreatureID());
            PC pC = characterSelector.getCreature();
            n = Math.max(n, pC.roles.getTotalLevel());
            n2 = Math.min(n2, pC.roles.getTotalLevel());
        }
        SavedParty savedParty = new SavedParty(arrayList, this.nameField.getText(), n2, n, 0);
        savedParty.writeToFile();
        this.newGameWindow.populatePartySelectors(savedParty.getID());
    }

    private void setHighlightedSelector(CharacterSelector characterSelector) {
        this.clearHighlightedSelector();
        characterSelector.getAnimationState().setAnimationState(Button.STATE_SELECTED, true);
        this.highlightedSelector = characterSelector;
    }

    private void clearHighlightedSelector() {
        if (this.highlightedSelector != null) {
            this.highlightedSelector.getAnimationState().setAnimationState(Button.STATE_SELECTED, false);
            this.highlightedSelector = null;
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.smallGap = themeInfo.getParameter("smallGap", 0);
        this.sectionGap = themeInfo.getParameter("sectionGap", 0);
        this.selectableWidth = themeInfo.getParameter("selectableWidth", 0);
        this.nameField.setText(themeInfo.getParameter("defaultpartyname", ""));
    }

    protected void layout() {
        super.layout();
        this.setSize(this.selectableWidth, this.getMaxHeight());
        this.setPosition((Game.config.getResolutionX() - this.getWidth()) / 2, (Game.config.getResolutionY() - this.getHeight()) / 2);
        int n = this.getInnerX() + this.getInnerWidth() / 2;
        this.cancel.setSize(this.cancel.getPreferredWidth(), this.cancel.getPreferredHeight());
        this.accept.setSize(this.accept.getPreferredWidth(), this.accept.getPreferredHeight());
        this.accept.setPosition(n - this.accept.getWidth() - this.smallGap, this.getInnerBottom() - this.accept.getHeight());
        this.cancel.setPosition(n + this.smallGap, this.getInnerBottom() - this.cancel.getHeight());
        this.titleLabel.setSize(this.titleLabel.getPreferredWidth(), this.titleLabel.getPreferredHeight());
        this.titleLabel.setPosition(n - this.titleLabel.getWidth() / 2, this.getInnerY());
        int n2 = Math.min(this.cancel.getY(), this.accept.getY());
        this.nameLabel.setSize(this.nameLabel.getPreferredWidth(), this.nameLabel.getPreferredHeight());
        this.nameField.setSize(this.nameField.getPreferredWidth(), this.nameField.getPreferredHeight());
        int n3 = this.nameField.getWidth() + this.nameLabel.getWidth() + this.smallGap;
        int n4 = Math.max(this.nameField.getHeight(), this.nameLabel.getHeight());
        this.nameLabel.setPosition(n - n3 / 2, this.titleLabel.getBottom() + this.sectionGap + n4 / 2 - this.nameLabel.getHeight() / 2);
        this.nameField.setPosition(this.nameLabel.getRight() + this.smallGap, this.titleLabel.getBottom() + this.sectionGap + n4 / 2 - this.nameField.getHeight() / 2);
        int n5 = Math.max(this.nameLabel.getBottom(), this.nameField.getBottom());
        this.partyTitle.setSize(this.partyTitle.getPreferredWidth(), this.partyTitle.getPreferredHeight());
        this.availableTitle.setSize(this.availableTitle.getPreferredWidth(), this.availableTitle.getPreferredHeight());
        this.partyTitle.setPosition(this.getInnerX(), n5 + this.sectionGap);
        this.availableTitle.setPosition(n, n5 + this.sectionGap);
        this.newCharacterButton.setSize(this.newCharacterButton.getPreferredWidth(), this.newCharacterButton.getPreferredHeight());
        this.newCharacterButton.setPosition(n, this.availableTitle.getBottom());
        this.partySize.setSize(this.partySize.getPreferredWidth(), this.partySize.getPreferredHeight());
        this.partySize.setPosition(this.getInnerX(), this.partyTitle.getBottom());
        this.partyPane.setPosition(this.getInnerX(), this.partySize.getBottom());
        this.partyPane.setSize(this.getInnerWidth() / 2, n2 - this.partyPane.getY());
        this.showPregeneratedCharactersButton.setSize(this.showPregeneratedCharactersButton.getPreferredWidth(), this.showPregeneratedCharactersButton.getPreferredHeight());
        this.showPregeneratedCharactersButton.setPosition(this.getInnerRight() - this.showPregeneratedCharactersButton.getWidth(), n2 - this.showPregeneratedCharactersButton.getHeight());
        this.availablePane.setPosition(this.partyPane.getRight(), this.newCharacterButton.getBottom());
        this.availablePane.setSize(this.getInnerWidth() - this.partyPane.getWidth(), this.showPregeneratedCharactersButton.getY() - this.availablePane.getY());
    }

    private void showCharacterEditor() {
        CharacterBuilder characterBuilder = new CharacterBuilder(new Buildable());
        this.mainMenu.add((Widget)characterBuilder);
        characterBuilder.addFinishCallback(new CharacterBuilder.FinishCallback(){

            @Override
            public void creatureModified(String string) {
                PC pC = EntityManager.getPC(string);
                CharacterSelector characterSelector = new CharacterSelector(pC, (Widget)PartyFormationWindow.this.mainMenu);
                PartyFormationWindow.this.availablePaneContent.addSelectorToTop(characterSelector, true, false);
                PartyFormationWindow.this.setHighlightedSelector(characterSelector);
                PartyFormationWindow.this.availablePane.setScrollPositionY(0);
                PartyFormationWindow.this.invalidateLayout();
            }
        });
    }

    private void setAcceptEnabled() {
        boolean bl;
        int n = this.partyPaneContent.selectors.size();
        int n2 = Game.curCampaign.getMaxPartySize();
        int n3 = Game.curCampaign.getMinPartySize();
        if (n == n2) {
            for (CharacterSelector characterSelector : this.availablePaneContent.selectors) {
                characterSelector.setAddRemoveEnabled(false);
            }
        } else {
            for (CharacterSelector characterSelector : this.availablePaneContent.selectors) {
                characterSelector.setAddRemoveEnabled(true);
            }
        }
        boolean bl2 = this.nameField.getTextLength() == 0;
        boolean bl3 = n > n2;
        boolean bl4 = bl = n < n3;
        if (bl2) {
            this.accept.setTooltipContent((Object)"You must enter a name for the party");
            this.accept.setEnabled(false);
        } else if (bl3) {
            this.accept.setTooltipContent((Object)"There are too many members in the party");
            this.accept.setEnabled(false);
        } else if (bl) {
            this.accept.setTooltipContent((Object)"There are too few members in the party");
            this.accept.setEnabled(false);
        } else {
            this.accept.setTooltipContent(null);
            this.accept.setEnabled(true);
        }
    }

    private class RemoveCallback
    implements Runnable {
        private CharacterSelector selector;

        private RemoveCallback(CharacterSelector characterSelector) {
            this.selector = characterSelector;
        }

        @Override
        public void run() {
            PartyFormationWindow.this.partyPaneContent.removeSelector(this.selector);
            PartyFormationWindow.this.availablePaneContent.addSelector(this.selector, true, false);
            PartyFormationWindow.this.setAcceptEnabled();
            PartyFormationWindow.this.clearHighlightedSelector();
        }
    }

    private class AddCallback
    implements Runnable {
        private CharacterSelector selector;

        private AddCallback(CharacterSelector characterSelector) {
            this.selector = characterSelector;
        }

        @Override
        public void run() {
            PartyFormationWindow.this.availablePaneContent.removeSelector(this.selector);
            PartyFormationWindow.this.partyPaneContent.addSelector(this.selector, false, true);
            PartyFormationWindow.this.setAcceptEnabled();
            PartyFormationWindow.this.clearHighlightedSelector();
        }
    }

    private class Content
    extends Widget {
        private List<CharacterSelector> selectors = new ArrayList<CharacterSelector>();
        private int selectorGap;

        private Content() {
        }

        private void addSelectorToTop(CharacterSelector characterSelector, boolean bl, boolean bl2) {
            this.add(characterSelector, true, bl, bl2);
        }

        private void addSelector(CharacterSelector characterSelector, boolean bl, boolean bl2) {
            this.add(characterSelector, false, bl, bl2);
        }

        private void add(CharacterSelector characterSelector, boolean bl, boolean bl2, boolean bl3) {
            if (bl2) {
                characterSelector.setAddRemoveButton("(+) Add to Party", new AddCallback(characterSelector));
            } else if (bl3) {
                characterSelector.setAddRemoveButton("(-) Remove from Party", new RemoveCallback(characterSelector));
            }
            if (bl) {
                this.selectors.add(0, characterSelector);
            } else {
                this.selectors.add(characterSelector);
            }
            this.add(characterSelector);
            this.invalidateLayout();
        }

        private void clear() {
            this.selectors.clear();
            this.removeAllChildren();
        }

        private void removeSelector(CharacterSelector characterSelector) {
            if (!this.selectors.contains((Object)characterSelector)) {
                return;
            }
            this.selectors.remove((Object)characterSelector);
            characterSelector.setAddRemoveButton(null, null);
            this.removeChild(characterSelector);
            this.invalidateLayout();
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.selectorGap = themeInfo.getParameter("selectorGap", 0);
        }

        public int getPreferredHeight() {
            int n = 0;
            for (CharacterSelector characterSelector : this.selectors) {
                n += characterSelector.getPreferredHeight();
            }
            return (n += Math.max(this.selectors.size() - 1, 0) * this.selectorGap) + this.getBorderVertical();
        }

        public int getPreferredWidth() {
            int n = 0;
            for (CharacterSelector characterSelector : this.selectors) {
                n = Math.max(n, characterSelector.getPreferredWidth());
            }
            return n + this.getBorderHorizontal();
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerY();
            for (CharacterSelector characterSelector : this.selectors) {
                characterSelector.setSize(characterSelector.getPreferredWidth(), characterSelector.getPreferredHeight());
                characterSelector.setPosition(this.getInnerX(), n);
                n = characterSelector.getBottom() + this.selectorGap;
            }
        }
    }
}

