/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ComboBox;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.Scrollbar;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.SimpleChangableListModel;
import de.matthiasmann.twl.model.SimpleIntegerModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.hale.Config;
import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.SaveWriter;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.mainmenu.KeyBindPopup;
import net.sf.hale.mainmenu.MainMenu;
import net.sf.hale.util.Logger;
import org.lwjgl.opengl.DisplayMode;

public class OptionsPopup
extends PopupWindow {
    private MainMenu mainMenu;
    private Content content;

    public OptionsPopup(MainMenu mainMenu) {
        super((Widget)mainMenu);
        this.mainMenu = mainMenu;
        this.content = new Content();
        this.add((Widget)this.content);
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(true);
    }

    private void writeConfigToFile(int n, int n2, boolean bl, int n3, int n4, boolean bl2, boolean bl3, Map<String, String> map) throws IOException {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        File file = new File(Game.getConfigBaseDirectory() + "config.json");
        PrintWriter printWriter = new PrintWriter(file);
        Integer[] integerArray = new Integer[]{n, n2};
        jSONOrderedObject.put("Resolution", integerArray);
        jSONOrderedObject.put("Fullscreen", bl);
        jSONOrderedObject.put("ShowFPS", bl2);
        jSONOrderedObject.put("CapFPS", Game.config.capFPS());
        jSONOrderedObject.put("CombatAutoScroll", bl3);
        jSONOrderedObject.put("TooltipDelay", n3);
        jSONOrderedObject.put("CombatDelay", n4);
        jSONOrderedObject.put("ScriptConsoleEnabled", Game.config.isScriptConsoleEnabled());
        jSONOrderedObject.put("DebugMode", Game.config.isDebugModeEnabled());
        jSONOrderedObject.put("WarningMode", Game.config.isWarningModeEnabled());
        jSONOrderedObject.put("CheckForUpdatesInterval", Game.config.getCheckForUpdatesInterval());
        if (Game.config.randSeedSet()) {
            jSONOrderedObject.put("RandSeed", Game.config.getRandSeed());
        }
        JSONOrderedObject jSONOrderedObject2 = new JSONOrderedObject();
        for (String string : map.keySet()) {
            jSONOrderedObject2.put(string, map.get(string));
        }
        jSONOrderedObject.put("Keybindings", jSONOrderedObject2);
        SaveWriter.writeJSON(jSONOrderedObject, printWriter);
        printWriter.close();
    }

    private class KeyBindWidget
    extends Widget
    implements KeyBindPopup.Callback {
        private Label actionLabel;
        private Button keyBinding;
        private String actionName;

        private KeyBindWidget(String string, Config config) {
            this.actionName = string;
            this.actionLabel = new Label(string);
            this.actionLabel.setTheme("actionlabel");
            this.add((Widget)this.actionLabel);
            int n = config.getKeyForAction(string);
            String string2 = Event.getKeyNameForCode((int)n);
            this.keyBinding = new Button(string2);
            this.keyBinding.addCallback(new Runnable(){

                @Override
                public void run() {
                    KeyBindWidget.this.showKeyBindPopup();
                }
            });
            this.keyBinding.setTheme("keybindingbutton");
            this.add((Widget)this.keyBinding);
        }

        private void showKeyBindPopup() {
            KeyBindPopup keyBindPopup = new KeyBindPopup(this, this);
            keyBindPopup.openPopupCentered();
        }

        public int getPreferredInnerHeight() {
            return Math.max(this.actionLabel.getPreferredHeight(), this.keyBinding.getPreferredHeight());
        }

        protected void layout() {
            this.actionLabel.setSize(this.actionLabel.getPreferredWidth(), this.actionLabel.getPreferredHeight());
            this.keyBinding.setSize(this.keyBinding.getPreferredWidth(), this.keyBinding.getPreferredHeight());
            this.actionLabel.setPosition(this.getInnerX(), this.getInnerY() + this.getInnerHeight() / 2 - this.actionLabel.getHeight() / 2);
            this.keyBinding.setPosition(this.actionLabel.getRight(), this.getInnerY() + this.getInnerHeight() / 2 - this.keyBinding.getHeight() / 2);
        }

        @Override
        public String getActionName() {
            return this.actionName;
        }

        @Override
        public void keyBound(int n) {
            String string = Event.getKeyNameForCode((int)n);
            this.keyBinding.setText(string);
            for (KeyBindWidget keyBindWidget : OptionsPopup.this.content.keyBindingsContent.widgets) {
                if (keyBindWidget == this || !string.equals(keyBindWidget.keyBinding.getText())) continue;
                keyBindWidget.keyBinding.setText("");
            }
        }
    }

    private class KeyBindingsContent
    extends DialogLayout {
        private List<KeyBindWidget> widgets = new ArrayList<KeyBindWidget>();

        private KeyBindingsContent() {
        }

        private void initializeWidgetsToConfig(Config config) {
            this.removeAllChildren();
            this.widgets.clear();
            DialogLayout.Group group = this.createParallelGroup();
            DialogLayout.Group group2 = this.createSequentialGroup();
            List<String> list = config.getKeyActionNames();
            Collections.sort(list);
            for (String string : list) {
                KeyBindWidget keyBindWidget = new KeyBindWidget(string, config);
                group.addWidget((Widget)keyBindWidget);
                group2.addWidget((Widget)keyBindWidget);
                this.widgets.add(keyBindWidget);
            }
            this.setHorizontalGroup(group);
            this.setVerticalGroup(group2);
        }
    }

    private class Content
    extends DialogLayout {
        private Label title;
        private Label keybindingsTitle;
        private Button accept;
        private Button cancel;
        private Button reset;
        private final ToggleButton fullscreen;
        private final ComboBox<String> modesBox;
        private final SimpleChangableListModel<String> modesModel;
        private final Scrollbar tooltipDelay;
        private final Scrollbar combatSpeed;
        private final ToggleButton fpsCounter;
        private final ToggleButton autoscrollToggle;
        private final Label modesTitle;
        private final Label tooltipTitle;
        private final Label combatSpeedTitle;
        private final ScrollPane keyBindingsPane;
        private final KeyBindingsContent keyBindingsContent;
        private DialogLayout.Group mainH = this.createParallelGroup();
        private DialogLayout.Group mainV = this.createSequentialGroup();

        private Content() {
            this.title = new Label();
            this.title.setTheme("titlelabel");
            this.addHorizontalWidgets(new Widget[]{this.title});
            this.modesTitle = new Label();
            this.modesTitle.setTheme("modeslabel");
            this.modesModel = new SimpleChangableListModel();
            this.modesBox = new ComboBox(this.modesModel);
            this.modesBox.setTheme("modesbox");
            this.modesBox.addCallback(new Runnable(){

                @Override
                public void run() {
                    Content.this.setAcceptEnabled();
                }
            });
            this.fullscreen = new ToggleButton();
            this.fullscreen.setTheme("fullscreentoggle");
            this.addHorizontalWidgets(new Widget[]{this.modesTitle, this.modesBox, this.fullscreen});
            this.tooltipTitle = new Label();
            this.tooltipTitle.setTheme("tooltiplabel");
            this.tooltipDelay = new Scrollbar(Scrollbar.Orientation.HORIZONTAL);
            this.tooltipDelay.setModel((IntegerModel)new SimpleIntegerModel(1, 20, 4));
            this.tooltipDelay.setPageSize(1);
            this.tooltipDelay.setTheme("tooltipbar");
            this.addHorizontalWidgets(new Widget[]{this.tooltipTitle, this.tooltipDelay});
            this.combatSpeedTitle = new Label();
            this.combatSpeedTitle.setTheme("combatspeedlabel");
            this.combatSpeed = new Scrollbar(Scrollbar.Orientation.HORIZONTAL);
            this.combatSpeed.setModel((IntegerModel)new SimpleIntegerModel(1, 5, 3));
            this.combatSpeed.setPageSize(1);
            this.combatSpeed.setTheme("combatspeedbar");
            this.addHorizontalWidgets(new Widget[]{this.combatSpeedTitle, this.combatSpeed});
            this.fpsCounter = new ToggleButton();
            this.fpsCounter.setTheme("fpstoggle");
            this.addHorizontalWidgets(new Widget[]{this.fpsCounter});
            this.autoscrollToggle = new ToggleButton();
            this.autoscrollToggle.setTheme("autoscrolltoggle");
            this.addHorizontalWidgets(new Widget[]{this.autoscrollToggle});
            this.mainV.addGap(-3);
            this.keybindingsTitle = new Label();
            this.keybindingsTitle.setTheme("keybindingslabel");
            this.addHorizontalWidgets(new Widget[]{this.keybindingsTitle});
            this.keyBindingsContent = new KeyBindingsContent();
            this.keyBindingsPane = new ScrollPane((Widget)this.keyBindingsContent);
            this.keyBindingsPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            this.keyBindingsPane.setTheme("keybindingspane");
            this.addHorizontalWidgets(new Widget[]{this.keyBindingsPane});
            this.mainV.addGap(-3);
            this.accept = new Button();
            this.accept.setTheme("acceptbutton");
            this.accept.addCallback(new Runnable(){

                @Override
                public void run() {
                    Content.this.applySettings();
                    OptionsPopup.this.closePopup();
                }
            });
            this.cancel = new Button();
            this.cancel.setTheme("cancelbutton");
            this.cancel.addCallback(new Runnable(){

                @Override
                public void run() {
                    OptionsPopup.this.closePopup();
                }
            });
            this.reset = new Button();
            this.reset.setTheme("resetbutton");
            this.reset.addCallback(new Runnable(){

                @Override
                public void run() {
                    ConfirmationPopup confirmationPopup = new ConfirmationPopup((Widget)OptionsPopup.this.mainMenu);
                    confirmationPopup.setTitleText("Reset all options to defaults?");
                    confirmationPopup.addCallback(new Runnable(){

                        @Override
                        public void run() {
                            Content.this.resetOptions();
                        }
                    });
                    confirmationPopup.openPopupCentered();
                }
            });
            DialogLayout.Group group = this.createSequentialGroup();
            DialogLayout.Group group2 = this.createParallelGroup();
            group.addWidgets(new Widget[]{this.accept, this.cancel});
            group.addGap("button");
            group.addWidget((Widget)this.reset);
            group2.addWidgets(new Widget[]{this.accept, this.cancel, this.reset});
            this.mainH.addGroup(group);
            this.mainV.addGroup(group2);
            this.setHorizontalGroup(this.mainH);
            this.setVerticalGroup(this.mainV);
            this.initializeWidgetsToConfig(Game.config);
        }

        private void setAcceptEnabled() {
            this.accept.setEnabled(this.modesBox.getSelected() != -1);
        }

        private void addHorizontalWidgets(Widget ... widgetArray) {
            switch (widgetArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.mainH.addWidget(widgetArray[0]);
                    this.mainV.addWidget(widgetArray[0]);
                    break;
                }
                default: {
                    DialogLayout.Group group = this.createSequentialGroup(widgetArray);
                    DialogLayout.Group group2 = this.createParallelGroup(widgetArray);
                    this.mainH.addGroup(group);
                    this.mainV.addGroup(group2);
                }
            }
        }

        private void resetOptions() {
            Config config = new Config("docs/defaultConfig.json");
            this.initializeWidgetsToConfig(config);
        }

        private void applySettings() {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (KeyBindWidget keyBindWidget : this.keyBindingsContent.widgets) {
                if (keyBindWidget.keyBinding.getText() != null) {
                    linkedHashMap.put(keyBindWidget.actionName, keyBindWidget.keyBinding.getText());
                    continue;
                }
                linkedHashMap.put(keyBindWidget.actionName, "");
            }
            boolean bl = this.fpsCounter.isActive();
            boolean bl2 = this.autoscrollToggle.isActive();
            DisplayMode displayMode = Game.allDisplayModes.get(this.modesBox.getSelected());
            boolean bl3 = this.fullscreen.isActive();
            int n = this.tooltipDelay.getValue() * 100;
            int n2 = (6 - this.combatSpeed.getValue()) * 50;
            try {
                OptionsPopup.this.writeConfigToFile(displayMode.getWidth(), displayMode.getHeight(), bl3, n, n2, bl, bl2, linkedHashMap);
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error writing configuration file", exception);
            }
            if (displayMode.getWidth() == Game.config.getResolutionX() && displayMode.getHeight() == Game.config.getResolutionY() && bl3 == Game.config.getFullscreen()) {
                Game.config = new Config(Game.getConfigBaseDirectory() + "config.json");
            } else {
                Game.config = new Config(Game.getConfigBaseDirectory() + "config.json");
                OptionsPopup.this.mainMenu.restartMenu();
            }
        }

        private void initializeWidgetsToConfig(Config config) {
            this.fullscreen.setActive(config.getFullscreen());
            this.tooltipDelay.setValue(config.getTooltipDelay() / 100);
            this.combatSpeed.setValue(6 - config.getCombatDelay() / 50);
            this.fpsCounter.setActive(config.showFPS());
            this.autoscrollToggle.setActive(config.autoScrollDuringCombat());
            this.modesModel.clear();
            for (DisplayMode displayMode : Game.allDisplayModes) {
                this.modesModel.addElement((Object)(displayMode.getWidth() + " x " + displayMode.getHeight()));
            }
            int n = Config.getMatchingDisplayMode(config.getResolutionX(), config.getResolutionY());
            this.modesBox.setSelected(n);
            this.keyBindingsContent.initializeWidgetsToConfig(config);
            this.setAcceptEnabled();
        }
    }
}

