/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.SavedParty;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.PC;
import net.sf.hale.mainmenu.CharacterSelector;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.mainmenu.DifficultySelector;
import net.sf.hale.mainmenu.MainMenu;
import net.sf.hale.mainmenu.PartyFormationWindow;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.XP;
import net.sf.hale.widgets.TextAreaNoInput;

public class NewGameWindow
extends Widget {
    public static final AnimationState.StateKey STATE_INVALID = AnimationState.StateKey.get((String)"invalid");
    private MainMenu mainMenu;
    private Label title;
    private Button cancel;
    private Button accept;
    private int acceptCancelGap;
    private int sectionGap;
    private int innerWidth;
    private int preselectedWidth;
    private int preselectedHeight;
    private DifficultySelector difficultySelector;
    private ToggleButton showInvalidPartiesButton;
    private Label partyLabel;
    private Button newPartyButton;
    private ScrollPane partyPane;
    private DialogLayout partyPaneContent;
    private Label charactersLabel;
    private ScrollPane charactersPane;
    private DialogLayout charactersPaneContent;
    private PartySelector selectedParty;
    private PC preselected;
    private HashSet<String> charactersUsedInParties;

    public NewGameWindow(MainMenu mainMenu) {
        this.mainMenu = mainMenu;
        mainMenu.setButtonsVisible(false);
        this.title = new Label();
        this.title.setTheme("titlelabel");
        this.add((Widget)this.title);
        this.cancel = new Button();
        this.cancel.setTheme("cancelbutton");
        this.cancel.addCallback(new Runnable(){

            @Override
            public void run() {
                NewGameWindow.this.mainMenu.removeChild(NewGameWindow.this);
                NewGameWindow.this.mainMenu.setButtonsVisible(true);
            }
        });
        this.add((Widget)this.cancel);
        this.accept = new Button();
        this.accept.setTheme("acceptbutton");
        this.accept.addCallback(new Runnable(){

            @Override
            public void run() {
                NewGameWindow.this.acceptNewGame();
                NewGameWindow.this.mainMenu.removeChild(NewGameWindow.this);
                NewGameWindow.this.mainMenu.setButtonsVisible(true);
            }
        });
        this.add((Widget)this.accept);
        this.difficultySelector = new DifficultySelector();
        this.add(this.difficultySelector);
        this.partyLabel = new Label();
        this.partyLabel.setTheme("partylabel");
        this.add((Widget)this.partyLabel);
        this.showInvalidPartiesButton = new ToggleButton();
        this.showInvalidPartiesButton.setTheme("showinvalidpartiesbutton");
        this.showInvalidPartiesButton.addCallback(new Runnable(){

            @Override
            public void run() {
                NewGameWindow.this.selectedParty = null;
                NewGameWindow.this.populatePartySelectors(null);
                NewGameWindow.this.populateCurrentParty();
            }
        });
        this.add((Widget)this.showInvalidPartiesButton);
        this.newPartyButton = new Button();
        this.newPartyButton.addCallback(new Runnable(){

            @Override
            public void run() {
                PartyFormationWindow partyFormationWindow = new PartyFormationWindow(NewGameWindow.this.mainMenu, NewGameWindow.this, NewGameWindow.this.charactersUsedInParties);
                NewGameWindow.this.mainMenu.add(partyFormationWindow);
            }
        });
        this.newPartyButton.setTheme("newpartybutton");
        this.add((Widget)this.newPartyButton);
        this.partyPaneContent = new DialogLayout();
        this.partyPaneContent.setTheme("content");
        this.partyPane = new ScrollPane((Widget)this.partyPaneContent);
        this.partyPane.setTheme("partypane");
        this.partyPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.add((Widget)this.partyPane);
        this.charactersLabel = new Label();
        this.charactersLabel.setTheme("characterslabel");
        this.add((Widget)this.charactersLabel);
        this.charactersPaneContent = new DialogLayout();
        this.charactersPaneContent.setTheme("content");
        this.charactersPane = new ScrollPane((Widget)this.charactersPaneContent);
        this.charactersPane.setTheme("characterspane");
        this.charactersPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.add((Widget)this.charactersPane);
        String string = Game.curCampaign.getStartingCharacter();
        if (string != null) {
            this.preselected = EntityManager.getPC(string);
            this.preselected.resetTime();
        }
        if (this.preselected != null) {
            this.newPartyButton.setVisible(false);
            this.partyLabel.setVisible(false);
            this.partyPane.setVisible(false);
            this.showInvalidPartiesButton.setVisible(false);
        }
        this.charactersUsedInParties = new HashSet();
        this.populatePartySelectors(null);
        this.populateCurrentParty();
    }

    private void setAcceptState() {
        this.accept.setTooltipContent(null);
        if (this.preselected != null) {
            this.accept.setEnabled(true);
        } else if (this.selectedParty != null) {
            String string = this.validateParty(this.selectedParty.party);
            this.accept.setEnabled(string == null);
            this.accept.setTooltipContent((Object)string);
        } else {
            this.accept.setEnabled(false);
        }
    }

    private String validateParty(SavedParty savedParty) {
        int n;
        int n2 = Game.curCampaign.getMaxPartySize();
        int n3 = Game.curCampaign.getMinPartySize();
        int n4 = Game.curCampaign.getMaxStartingLevel();
        int n5 = n = Game.curCampaign.allowLevelUp() ? 1 : Game.curCampaign.getMinStartingLevel();
        if (savedParty.size() > n2) {
            return "The party is too large for this campaign";
        }
        if (savedParty.size() < n3) {
            return "The party is too small for this campaign";
        }
        if (savedParty.getMinLevel() < n) {
            return "One or more party members are of too low a level for this campaign";
        }
        if (savedParty.getMaxLevel() > n4) {
            return "One or more party members are of too high a level for this campaign";
        }
        return null;
    }

    public void populatePartySelectors(String string) {
        this.charactersUsedInParties.clear();
        this.partyPaneContent.removeAllChildren();
        DialogLayout.Group group = this.partyPaneContent.createParallelGroup();
        DialogLayout.Group group2 = this.partyPaneContent.createSequentialGroup();
        if (this.preselected == null) {
            ArrayList<SavedParty> arrayList = new ArrayList<SavedParty>();
            arrayList.addAll(this.getPartiesInDirectory("characters/parties/"));
            int n = arrayList.size() - 1;
            arrayList.addAll(this.getPartiesInDirectory(Game.getPartiesBaseDirectory()));
            int n2 = 0;
            for (SavedParty savedParty : arrayList) {
                boolean bl;
                String string2 = this.validateParty(savedParty);
                boolean bl2 = bl = string2 == null;
                if (savedParty.getMinLevel() < Game.curCampaign.getMinStartingLevel() && string2 == null) {
                    string2 = "One or more party members will be automatically leveled up for this campaign";
                }
                PartySelector partySelector = n2 > n ? new PartySelector(savedParty, true) : new PartySelector(savedParty, false);
                partySelector.setTooltipContent(string2);
                partySelector.getAnimationState().setAnimationState(STATE_INVALID, !bl);
                if (this.showInvalidPartiesButton.isActive() || bl) {
                    group.addWidget((Widget)partySelector);
                    group2.addWidget((Widget)partySelector);
                }
                if (savedParty.getID().equals(string)) {
                    partySelector.run();
                }
                this.addToCharactersUsedInParties(savedParty);
                ++n2;
            }
        }
        this.partyPaneContent.setHorizontalGroup(group);
        this.partyPaneContent.setVerticalGroup(group2);
        this.setAcceptState();
    }

    private List<SavedParty> getPartiesInDirectory(String string) {
        ArrayList<SavedParty> arrayList = new ArrayList<SavedParty>();
        File file = new File(string);
        for (String string2 : file.list()) {
            File file2 = new File(string + "/" + string2);
            if (!file2.isFile()) continue;
            String string3 = string2.substring(0, string2.length() - 5);
            SavedParty savedParty = new SavedParty(string + string3 + ResourceType.JSON.getExtension(), string3);
            arrayList.add(savedParty);
        }
        return arrayList;
    }

    private void addToCharactersUsedInParties(SavedParty savedParty) {
        for (String string : savedParty.getCharacterIDs()) {
            this.charactersUsedInParties.add(string);
        }
    }

    private void populateCurrentParty() {
        this.charactersPaneContent.removeAllChildren();
        DialogLayout.Group group = this.charactersPaneContent.createParallelGroup();
        DialogLayout.Group group2 = this.charactersPaneContent.createSequentialGroup();
        if (this.preselected != null) {
            CharacterSelector characterSelector = new CharacterSelector(this.preselected, (Widget)this.mainMenu);
            group.addWidget((Widget)characterSelector);
            group2.addWidget((Widget)characterSelector);
        } else if (this.selectedParty != null) {
            for (String string : this.selectedParty.party.getCharacterIDs()) {
                PC pC = EntityManager.getPC(string);
                pC.resetTime();
                CharacterSelector characterSelector = new CharacterSelector(pC, (Widget)this.mainMenu);
                group.addWidget((Widget)characterSelector);
                group2.addWidget((Widget)characterSelector);
            }
        }
        this.charactersPaneContent.setHorizontalGroup(group);
        this.charactersPaneContent.setVerticalGroup(group2);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.acceptCancelGap = themeInfo.getParameter("acceptCancelGap", 0);
        this.sectionGap = themeInfo.getParameter("sectionGap", 0);
        this.innerWidth = themeInfo.getParameter("innerwidth", 0);
        this.preselectedWidth = themeInfo.getParameter("preselectedwidth", 0);
        this.preselectedHeight = themeInfo.getParameter("preselectedheight", 0);
    }

    public void layout() {
        int n;
        if (this.preselected == null) {
            this.setSize(this.innerWidth + this.getBorderHorizontal(), this.getMaxHeight());
        } else {
            n = Math.max(this.preselectedWidth, this.difficultySelector.getPreferredWidth());
            this.setSize(n + this.getBorderHorizontal(), this.preselectedHeight);
        }
        this.setPosition((Game.config.getResolutionX() - this.getWidth()) / 2, (Game.config.getResolutionY() - this.getHeight()) / 2);
        n = this.getInnerX() + this.getInnerWidth() / 2;
        this.cancel.setSize(this.cancel.getPreferredWidth(), this.cancel.getPreferredHeight());
        this.accept.setSize(this.accept.getPreferredWidth(), this.accept.getPreferredHeight());
        this.accept.setPosition(n - this.accept.getWidth() - this.acceptCancelGap, this.getInnerBottom() - this.accept.getHeight());
        this.cancel.setPosition(n + this.acceptCancelGap, this.getInnerBottom() - this.cancel.getHeight());
        this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
        this.title.setPosition(n - this.title.getWidth() / 2, this.getInnerY());
        this.difficultySelector.setSize(this.difficultySelector.getPreferredWidth(), this.difficultySelector.getPreferredHeight());
        this.difficultySelector.setPosition(n - this.difficultySelector.getWidth() / 2, this.accept.getY() - this.sectionGap - this.difficultySelector.getHeight());
        if (this.preselected == null) {
            this.partyLabel.setPosition(this.getInnerX(), this.title.getBottom() + this.sectionGap);
            this.partyLabel.setSize(this.partyLabel.getPreferredWidth(), this.partyLabel.getPreferredHeight());
            this.newPartyButton.setSize(this.newPartyButton.getPreferredWidth(), this.newPartyButton.getPreferredHeight());
            this.newPartyButton.setPosition(this.getInnerX(), this.partyLabel.getBottom());
            this.showInvalidPartiesButton.setSize(this.showInvalidPartiesButton.getPreferredWidth(), this.showInvalidPartiesButton.getPreferredHeight());
            this.showInvalidPartiesButton.setPosition(this.getInnerX(), this.difficultySelector.getY() - this.newPartyButton.getHeight() - this.sectionGap);
            this.partyPane.setPosition(this.getInnerX(), this.newPartyButton.getBottom());
            this.partyPane.setSize(this.getInnerWidth() / 2, Math.max(0, this.showInvalidPartiesButton.getY() - this.partyPane.getY()));
            this.charactersLabel.setPosition(this.getInnerX() + this.getInnerWidth() / 2, this.title.getBottom() + this.sectionGap);
            this.charactersLabel.setSize(this.charactersLabel.getPreferredWidth(), this.charactersLabel.getPreferredHeight());
            this.charactersPane.setPosition(this.partyPane.getRight(), this.charactersLabel.getBottom());
            this.charactersPane.setSize(this.getInnerWidth() / 2, this.difficultySelector.getY() - this.charactersPane.getY() - this.sectionGap);
        } else {
            this.charactersLabel.setPosition(this.getInnerX(), this.title.getBottom() + this.sectionGap);
            this.charactersLabel.setSize(this.charactersLabel.getPreferredWidth(), this.charactersLabel.getPreferredHeight());
            this.charactersPane.setPosition(this.getInnerX(), this.charactersLabel.getBottom());
            this.charactersPane.setSize(this.getInnerWidth(), Math.max(0, this.difficultySelector.getY() - this.charactersPane.getY() - this.sectionGap));
        }
    }

    private void acceptNewGame() {
        if (this.preselected != null) {
            Game.curCampaign.addParty(null, null);
            Game.curCampaign.party.setFirstMemberSelected();
        } else {
            Game.curCampaign.addParty(this.selectedParty.party.getCharacterIDs(), this.selectedParty.party.getName());
            Game.curCampaign.party.setFirstMemberSelected();
            int n = Math.max(this.selectedParty.party.getCurrency(), Game.curCampaign.getMinCurrency());
            Game.curCampaign.partyCurrency.setValue(n);
            if (Game.curCampaign.allowLevelUp()) {
                int n2 = XP.getPointsForLevel(Game.curCampaign.getMinStartingLevel());
                for (PC pC : Game.curCampaign.party) {
                    int n3 = pC.getExperiencePoints();
                    pC.addExperiencePoints(Math.max(n2 - n3, 0));
                }
            }
        }
        Game.ruleset.getDifficultyManager().setCurrentDifficulty(this.difficultySelector.getSelectedDifficulty());
        this.mainMenu.update();
    }

    private class PartySelector
    extends ToggleButton
    implements Runnable {
        private TextArea textArea;
        private Button delete;
        private HTMLTextAreaModel model;
        private SavedParty party;

        private PartySelector(SavedParty savedParty, boolean bl) {
            this.party = savedParty;
            this.addCallback(this);
            this.model = new HTMLTextAreaModel();
            this.textArea = new TextAreaNoInput((TextAreaModel)this.model);
            this.add((Widget)this.textArea);
            this.delete = new Button();
            this.delete.setTheme("deletebutton");
            this.delete.setEnabled(bl);
            this.delete.addCallback(new Runnable(){

                @Override
                public void run() {
                    PartySelector.this.showDeleteConfirmation();
                }
            });
            this.add((Widget)this.delete);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<div style=\"font-family: medium;\">");
            stringBuilder.append(savedParty.getName());
            stringBuilder.append("</div>");
            stringBuilder.append("<div>");
            if (savedParty.getMaxLevel() == savedParty.getMinLevel()) {
                stringBuilder.append("Level ");
                stringBuilder.append(savedParty.getMaxLevel());
            } else {
                stringBuilder.append("Levels ");
                stringBuilder.append(savedParty.getMinLevel());
                stringBuilder.append(" to ");
                stringBuilder.append(savedParty.getMaxLevel());
            }
            if (Game.curCampaign.allowLevelUp() && savedParty.getMinLevel() < Game.curCampaign.getMinStartingLevel()) {
                stringBuilder.append(" - <span style=\"font-family: red\">");
                stringBuilder.append("Requires Level Up");
                stringBuilder.append("</span>");
            }
            stringBuilder.append("</div>");
            this.model.setHtml(stringBuilder.toString());
        }

        private void showDeleteConfirmation() {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup(NewGameWindow.this);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Delete ");
            stringBuilder.append(this.party.getName());
            stringBuilder.append("?");
            confirmationPopup.setTitleText(stringBuilder.toString());
            confirmationPopup.setWarningText("This action is permanent and cannot be undone.");
            confirmationPopup.addCallback(new Runnable(){

                @Override
                public void run() {
                    PartySelector.this.party.deleteFile();
                    NewGameWindow.this.selectedParty = null;
                    NewGameWindow.this.populatePartySelectors(null);
                    NewGameWindow.this.populateCurrentParty();
                }
            });
            confirmationPopup.openPopupCentered();
        }

        @Override
        public void run() {
            if (NewGameWindow.this.selectedParty != null) {
                NewGameWindow.this.selectedParty.setActive(false);
            }
            NewGameWindow.this.selectedParty = this;
            this.setActive(true);
            NewGameWindow.this.populateCurrentParty();
            NewGameWindow.this.setAcceptState();
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            String string = themeInfo.getParameter("deletedisabledtooltip", (String)null);
            if (!this.delete.isEnabled()) {
                this.delete.setTooltipContent((Object)string);
            }
        }

        protected void layout() {
            this.textArea.setSize(this.getInnerWidth(), this.getInnerHeight());
            this.textArea.setPosition(this.getInnerX(), this.getInnerY());
            this.delete.setSize(this.delete.getPreferredWidth(), this.delete.getPreferredHeight());
            this.delete.setPosition(this.getInnerRight() - this.delete.getWidth(), this.getInnerBottom() - this.delete.getHeight());
        }

        public int getPreferredWidth() {
            return this.textArea.getPreferredWidth() + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return this.textArea.getPreferredHeight() + this.getBorderVertical();
        }
    }
}

