/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import java.util.ArrayList;
import java.util.List;

public class MainMenuAction {
    private Runnable preActionCallback;
    private Action action;
    private String loadGameFile;
    private List<String> errorPopupMessages = new ArrayList<String>();

    public MainMenuAction(Action action) {
        this.action = action;
        if (action == Action.LoadGame) {
            throw new IllegalArgumentException("Use MainMenuAction(String) instead.");
        }
    }

    public MainMenuAction(String string) {
        this.action = Action.LoadGame;
        this.loadGameFile = string;
    }

    public void runPreActionCallback() {
        if (this.preActionCallback != null) {
            this.preActionCallback.run();
        }
    }

    public void setPreActionCallback(Runnable runnable) {
        this.preActionCallback = runnable;
    }

    public void addErrorPopupMessage(String string) {
        this.errorPopupMessages.add(string);
    }

    public List<String> getErrorPopupMessages() {
        return this.errorPopupMessages;
    }

    public Action getAction() {
        return this.action;
    }

    public String getLoadGameFile() {
        if (this.action != Action.LoadGame) {
            throw new UnsupportedOperationException("Only valid for load game action type.");
        }
        return this.loadGameFile;
    }

    public static enum Action {
        Exit,
        Restart,
        ShowMainMenu,
        NewGame,
        LoadGame;

    }
}

