/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DesktopArea;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.Renderer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Config;
import net.sf.hale.Game;
import net.sf.hale.loading.CampaignLoadingTaskList;
import net.sf.hale.loading.LoadingTaskList;
import net.sf.hale.loading.LoadingWaitPopup;
import net.sf.hale.mainmenu.CampaignPopup;
import net.sf.hale.mainmenu.CheckForUpdatesTask;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.mainmenu.LoadGamePopup;
import net.sf.hale.mainmenu.MainMenuAction;
import net.sf.hale.mainmenu.NewGameWindow;
import net.sf.hale.mainmenu.OptionsPopup;
import net.sf.hale.mainmenu.Updater;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Campaign;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.widgets.HTMLPopup;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class MainMenu
extends DesktopArea
implements LoadGamePopup.Callback {
    private Runnable exitCallback;
    private Sprite backgroundSprite;
    private Point backgroundSpriteOffset;
    private final GUI gui;
    private LoadingTaskList loader;
    private LoadingWaitPopup popup;
    private boolean menuRunning = true;
    private boolean exit = false;
    private boolean restart = false;
    private boolean exitOnLoad = false;
    private String loadGame = null;
    private final Label campaignLabel;
    private int buttonGap;
    private int titleOffset;
    private final Button campaignButton;
    private final Button newGameButton;
    private final Button loadGameButton;
    private final Button updateButton;
    private final Button optionsButton;
    private final Button creditsButton;
    private final Button exitButton;
    private final Button releaseNotesButton;
    private final Label versionLabel;
    private final List<PopupWindow> popupsToShow = new ArrayList<PopupWindow>();
    private final List<PopupWindow> popupsToHide = new ArrayList<PopupWindow>();
    private String version;

    public MainMenu() {
        String string;
        this.setTheme("mainmenu");
        this.gui = new GUI((Widget)this, (Renderer)Game.renderer);
        this.gui.setSize();
        this.gui.applyTheme(Game.themeManager);
        this.gui.setTooltipDelay(Game.config.getTooltipDelay());
        this.campaignLabel = new Label();
        this.campaignLabel.setTheme("campaignlabel");
        this.add((Widget)this.campaignLabel);
        try {
            this.version = FileUtil.readFileAsString("docs/version.txt");
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error reading version information", iOException);
        }
        this.campaignButton = new Button();
        this.campaignButton.setTheme("campaignbutton");
        this.campaignButton.addCallback(new Runnable(){

            @Override
            public void run() {
                CampaignPopup campaignPopup = new CampaignPopup(MainMenu.this);
                campaignPopup.openPopupCentered();
            }
        });
        this.add((Widget)this.campaignButton);
        this.newGameButton = new Button();
        this.newGameButton.setTheme("newgamebutton");
        this.newGameButton.addCallback(new Runnable(){

            @Override
            public void run() {
                NewGameWindow newGameWindow = new NewGameWindow(MainMenu.this);
                MainMenu.this.add(newGameWindow);
            }
        });
        this.add((Widget)this.newGameButton);
        this.loadGameButton = new Button();
        this.loadGameButton.setTheme("loadgamebutton");
        this.loadGameButton.addCallback(new Runnable(){

            @Override
            public void run() {
                LoadGamePopup loadGamePopup = new LoadGamePopup((Widget)MainMenu.this, true);
                loadGamePopup.setCallback(MainMenu.this);
                loadGamePopup.openPopupCentered();
            }
        });
        this.add((Widget)this.loadGameButton);
        this.creditsButton = new Button();
        this.creditsButton.setTheme("creditsbutton");
        this.creditsButton.addCallback(new Runnable(){

            @Override
            public void run() {
                try {
                    HTMLPopup hTMLPopup = new HTMLPopup(new File("docs/Contributors.html"), (Widget)MainMenu.this);
                    hTMLPopup.setSize(640, 480);
                    hTMLPopup.openPopupCentered();
                }
                catch (IOException iOException) {
                    Logger.appendToErrorLog("Error retrieving contributors file", iOException);
                }
            }
        });
        this.add((Widget)this.creditsButton);
        this.updateButton = new Button();
        this.updateButton.setTheme("updatebutton");
        this.updateButton.setVisible(false);
        this.updateButton.addCallback(new Runnable(){

            @Override
            public void run() {
                new Updater().runUpdater(MainMenu.this);
            }
        });
        this.add((Widget)this.updateButton);
        this.optionsButton = new Button();
        this.optionsButton.setTheme("optionsbutton");
        this.optionsButton.addCallback(new Runnable(){

            @Override
            public void run() {
                OptionsPopup optionsPopup = new OptionsPopup(MainMenu.this);
                optionsPopup.openPopupCentered();
            }
        });
        this.add((Widget)this.optionsButton);
        this.exitButton = new Button();
        this.exitButton.setTheme("exitbutton");
        this.exitButton.addCallback(new Runnable(){

            @Override
            public void run() {
                MainMenu.this.showExitPopup();
            }
        });
        this.add((Widget)this.exitButton);
        this.backgroundSprite = SpriteManager.getSpriteAnyExtension("mainmenu");
        this.backgroundSpriteOffset = new Point();
        if (this.backgroundSprite != null) {
            this.backgroundSpriteOffset.x = (Game.displayMode.getWidth() - this.backgroundSprite.getWidth()) / 2;
            this.backgroundSpriteOffset.y = (Game.displayMode.getHeight() - this.backgroundSprite.getHeight()) / 2;
        }
        if ((string = this.getLastOpenCampaign()) != null) {
            this.loadCampaign(string);
        }
        if (this.version.equals("svn")) {
            this.versionLabel = new Label("Build ID: " + Game.config.getVersionID());
        } else if (this.version.equals("disabled")) {
            this.versionLabel = new Label("Version Disabled");
        } else {
            this.versionLabel = new Label("Version: " + this.version);
            File file = new File(Game.getConfigBaseDirectory() + "updateAvailable.txt");
            if (file.isFile()) {
                this.updateButton.setVisible(true);
            } else if (Game.osType == Game.OSType.Windows) {
                long l = System.currentTimeMillis();
                long l2 = Game.config.getCheckForUpdatesInterval();
                long l3 = Config.getLastCheckForUpdatesTime();
                if (l3 + l2 < l) {
                    CheckForUpdatesTask checkForUpdatesTask = new CheckForUpdatesTask(this);
                    checkForUpdatesTask.start();
                }
                Config.writeCheckForUpdatesTime(l);
            }
        }
        this.versionLabel.setTheme("versionlabel");
        this.add((Widget)this.versionLabel);
        this.releaseNotesButton = new Button();
        this.releaseNotesButton.addCallback(new Runnable(){

            @Override
            public void run() {
                try {
                    HTMLPopup hTMLPopup = new HTMLPopup(new File("docs/Release Notes.html"), (Widget)MainMenu.this);
                    hTMLPopup.setSize(640, 480);
                    hTMLPopup.openPopupCentered();
                }
                catch (IOException iOException) {
                    Logger.appendToErrorLog("Error retrieving release notes", iOException);
                }
            }
        });
        this.releaseNotesButton.setTheme("releasenotesbutton");
        this.add((Widget)this.releaseNotesButton);
    }

    private void showExitPopup() {
        ConfirmationPopup confirmationPopup = new ConfirmationPopup((Widget)this);
        confirmationPopup.setTitleText("Are you sure you wish to exit?");
        confirmationPopup.addCallback(new Runnable(){

            @Override
            public void run() {
                MainMenu.this.exit = true;
                MainMenu.this.menuRunning = false;
            }
        });
        confirmationPopup.openPopupCentered();
    }

    public void enableUpdate() {
        this.updateButton.setVisible(true);
    }

    public String getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hidePopup(PopupWindow popupWindow) {
        List<PopupWindow> list = this.popupsToHide;
        synchronized (list) {
            this.popupsToHide.add(popupWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopup(PopupWindow popupWindow) {
        List<PopupWindow> list = this.popupsToShow;
        synchronized (list) {
            this.popupsToShow.add(popupWindow);
        }
    }

    protected void setButtonsVisible(boolean bl) {
        this.campaignButton.setVisible(bl);
        this.newGameButton.setVisible(bl);
        this.loadGameButton.setVisible(bl);
        this.optionsButton.setVisible(bl);
        this.exitButton.setVisible(bl);
        this.creditsButton.setVisible(bl);
        this.releaseNotesButton.setEnabled(bl);
    }

    protected void paintWidget(GUI gUI) {
        if (this.backgroundSprite != null) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.backgroundSprite.draw(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.buttonGap = themeInfo.getParameter("buttonGap", 0);
        this.titleOffset = themeInfo.getParameter("titleOffset", 0);
    }

    protected void layout() {
        super.layout();
        int n = Game.config.getResolutionX();
        this.campaignButton.setSize(this.campaignButton.getPreferredWidth(), this.campaignButton.getPreferredHeight());
        this.newGameButton.setSize(this.newGameButton.getPreferredWidth(), this.newGameButton.getPreferredHeight());
        this.loadGameButton.setSize(this.loadGameButton.getPreferredWidth(), this.loadGameButton.getPreferredHeight());
        this.creditsButton.setSize(this.creditsButton.getPreferredWidth(), this.creditsButton.getPreferredHeight());
        this.optionsButton.setSize(this.optionsButton.getPreferredWidth(), this.optionsButton.getPreferredHeight());
        this.exitButton.setSize(this.exitButton.getPreferredWidth(), this.exitButton.getPreferredHeight());
        int n2 = this.campaignButton.getHeight() + this.newGameButton.getHeight() + this.loadGameButton.getHeight() + this.updateButton.getHeight() + this.optionsButton.getHeight() + this.exitButton.getHeight() + 6 * this.buttonGap;
        int n3 = (Game.config.getResolutionY() - n2) / 2;
        this.campaignButton.setPosition((n - this.campaignButton.getWidth()) / 2, n3);
        this.newGameButton.setPosition((n - this.newGameButton.getWidth()) / 2, this.campaignButton.getBottom() + this.buttonGap);
        this.loadGameButton.setPosition((n - this.loadGameButton.getWidth()) / 2, this.newGameButton.getBottom() + this.buttonGap);
        this.creditsButton.setPosition((n - this.creditsButton.getWidth()) / 2, this.loadGameButton.getBottom() + this.buttonGap);
        this.optionsButton.setPosition((n - this.optionsButton.getWidth()) / 2, this.creditsButton.getBottom() + this.buttonGap);
        this.exitButton.setPosition((n - this.exitButton.getWidth()) / 2, this.optionsButton.getBottom() + this.buttonGap);
        this.campaignLabel.setSize(this.campaignLabel.getPreferredWidth(), this.campaignLabel.getPreferredHeight());
        this.campaignLabel.setPosition((n - this.campaignLabel.getWidth()) / 2, n3 - this.campaignLabel.getHeight() - this.titleOffset);
        this.releaseNotesButton.setSize(this.releaseNotesButton.getPreferredWidth(), this.releaseNotesButton.getPreferredHeight());
        this.releaseNotesButton.setPosition(this.getInnerRight() - this.releaseNotesButton.getWidth(), this.getInnerBottom() - this.releaseNotesButton.getHeight());
        this.versionLabel.setSize(this.versionLabel.getPreferredWidth(), this.versionLabel.getPreferredHeight());
        this.versionLabel.setPosition(this.getInnerRight() - this.versionLabel.getWidth(), this.releaseNotesButton.getY() - this.versionLabel.getHeight());
        this.updateButton.setSize(this.updateButton.getPreferredWidth(), this.updateButton.getPreferredHeight());
        this.updateButton.setPosition(this.getInnerRight() - this.updateButton.getWidth(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePopups() {
        List<PopupWindow> list = this.popupsToShow;
        synchronized (list) {
            for (PopupWindow popupWindow : this.popupsToShow) {
                popupWindow.openPopupCentered();
            }
            this.popupsToShow.clear();
        }
        list = this.popupsToHide;
        synchronized (list) {
            for (PopupWindow popupWindow : this.popupsToHide) {
                popupWindow.closePopup();
            }
            this.popupsToHide.clear();
        }
    }

    public MainMenuAction mainLoop() {
        this.update();
        while (this.menuRunning) {
            if (this.loader != null && !this.loader.isAlive()) {
                this.popup.closePopup();
                this.update();
                this.loader = null;
                if (this.exitOnLoad) {
                    this.menuRunning = false;
                }
            }
            this.handlePopups();
            Game.textureLoader.update();
            GL11.glClear((int)16384);
            try {
                this.gui.update();
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error in GUI update", exception);
            }
            Display.update((boolean)false);
            GL11.glGetError();
            Display.sync((int)60);
            Display.processMessages();
            if (!Display.isCloseRequested()) continue;
            this.showExitPopup();
        }
        if (this.exitCallback != null) {
            this.exitCallback.run();
        }
        this.gui.destroy();
        if (this.exit) {
            return new MainMenuAction(MainMenuAction.Action.Exit);
        }
        if (this.restart) {
            return new MainMenuAction(MainMenuAction.Action.Restart);
        }
        if (this.loadGame != null) {
            return new MainMenuAction(this.loadGame);
        }
        return new MainMenuAction(MainMenuAction.Action.NewGame);
    }

    public void setExitCallback(Runnable runnable) {
        this.exitCallback = runnable;
    }

    public void setExitOnLoad() {
        this.exitOnLoad = true;
    }

    public void restartMenu() {
        this.menuRunning = false;
        this.restart = true;
    }

    public static void writeLastOpenCampaign(String string) {
        File file = new File(Game.getConfigBaseDirectory() + "lastOpenCampaign.txt");
        try {
            FileWriter fileWriter = new FileWriter(file, false);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error writing last open campaign file.", exception);
        }
    }

    public void update() {
        if (Game.curCampaign == null) {
            this.newGameButton.setEnabled(false);
            this.loadGameButton.setEnabled(false);
        } else {
            this.newGameButton.setEnabled(true);
            this.loadGameButton.setEnabled(SaveGameUtil.getSaveGames().size() > 0);
            if (Game.curCampaign != null) {
                if (Game.curCampaign.party.size() > 0 || this.loadGame != null) {
                    if (this.exitOnLoad) {
                        this.setButtonsVisible(false);
                        this.campaignLabel.setVisible(false);
                    } else {
                        this.menuRunning = false;
                        this.setVisible(false);
                    }
                }
                this.campaignLabel.setText(Game.curCampaign.getName());
            }
        }
    }

    private String getLastOpenCampaign() {
        try {
            return FileUtil.readFileAsString(Game.getConfigBaseDirectory() + "lastOpenCampaign.txt");
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error loading last open campaign file.", exception);
            return null;
        }
    }

    @Override
    public void loadGameAccepted(String string) {
        this.loadGame = string;
        this.update();
    }

    public void loadCampaign(String string) {
        Game.curCampaign = new Campaign(string);
        this.loader = new CampaignLoadingTaskList();
        this.backgroundSprite = SpriteManager.getSpriteAnyExtension("mainmenu");
        this.loader.start();
        this.popup = new LoadingWaitPopup((Widget)this, "Loading " + string);
        this.popup.setBGSprite(this.backgroundSprite);
        this.popup.setLoadingTaskList(this.loader);
        this.popup.openPopupCentered();
    }
}

