/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.mainmenu.AbstractSaveGamePopup;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.mainmenu.SaveGameSelector;
import net.sf.hale.util.SaveGameUtil;

public class LoadGamePopup
extends AbstractSaveGamePopup
implements Runnable {
    private Callback callback;
    private boolean showLoadWarning;
    private String saveGame;

    public LoadGamePopup(Widget widget, boolean bl) {
        super(widget);
        this.showLoadWarning = bl;
    }

    @Override
    public void run() {
        this.callback.loadGameAccepted(this.saveGame);
        this.closePopup();
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    @Override
    protected void selectionAccepted(AbstractSaveGamePopup.Selector selector) {
        this.saveGame = selector.getSaveGame();
        if (!this.showLoadWarning || !selector.checkVersionID()) {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup(this.getParent());
            if (!this.showLoadWarning) {
                confirmationPopup.setTitleText("Load " + this.saveGame + "? You will lose any unsaved progress.");
            } else {
                confirmationPopup.setTitleText("Load " + this.saveGame + "?");
            }
            if (!selector.checkVersionID()) {
                confirmationPopup.setWarningText("Warning!  This save file is from an earlier version.");
            }
            confirmationPopup.addCallback(this);
            confirmationPopup.openPopupCentered();
        } else {
            this.callback.loadGameAccepted(this.saveGame);
            this.closePopup();
        }
    }

    @Override
    protected List<AbstractSaveGamePopup.Selector> getValidSelectors() {
        ArrayList<AbstractSaveGamePopup.Selector> arrayList = new ArrayList<AbstractSaveGamePopup.Selector>();
        for (String string : SaveGameUtil.getSaveGames()) {
            SaveGameSelector saveGameSelector = new SaveGameSelector(string, this.getDateFormat());
            saveGameSelector.addCallback(new AbstractSaveGamePopup.SelectorCallback(saveGameSelector));
            arrayList.add(saveGameSelector);
        }
        return arrayList;
    }

    public static interface Callback {
        public void loadGameAccepted(String var1);
    }
}

