/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;

public class KeyBindPopup
extends PopupWindow {
    private final Callback callback;
    private final Content content;

    public KeyBindPopup(Widget widget, Callback callback) {
        super(widget);
        this.setCloseOnEscape(false);
        this.setCloseOnClickedOutside(true);
        this.callback = callback;
        this.content = new Content();
        this.add(this.content);
    }

    public int getPreferredInnerWidth() {
        return this.content.getPreferredWidth();
    }

    public int getPreferredInnerHeight() {
        return this.content.getPreferredHeight();
    }

    public static interface Callback {
        public void keyBound(int var1);

        public String getActionName();
    }

    private class Content
    extends Widget {
        private Label title;
        private Label label;

        private Content() {
            this.title = new Label("Binding for " + KeyBindPopup.this.callback.getActionName());
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.label = new Label();
            this.label.setTheme("textlabel");
            this.add((Widget)this.label);
        }

        protected void layout() {
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.title.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - this.title.getWidth() / 2, this.getInnerY() + this.getInnerHeight() / 4 - this.title.getHeight());
            this.label.setSize(this.label.getPreferredWidth(), this.label.getPreferredHeight());
            this.label.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - this.label.getWidth() / 2, this.getInnerY() + this.getInnerHeight() / 2 - this.label.getHeight());
            this.requestKeyboardFocus();
        }

        public int getPreferredInnerWidth() {
            return Math.max(this.label.getPreferredWidth(), this.title.getPreferredWidth());
        }

        public int getPreferredInnerHeight() {
            return 2 * (this.label.getPreferredHeight() + this.title.getPreferredHeight());
        }

        public boolean handleEvent(Event event) {
            switch (event.getType()) {
                case KEY_PRESSED: {
                    int n = event.getKeyCode();
                    KeyBindPopup.this.callback.keyBound(n);
                    KeyBindPopup.this.closePopup();
                    break;
                }
                case MOUSE_ENTERED: {
                    return true;
                }
            }
            return super.handleEvent(event);
        }
    }
}

