/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.mainmenu.DifficultySelector;

public class InGameOptionsPopup
extends PopupWindow {
    private Content content = new Content();

    public InGameOptionsPopup(Widget widget) {
        super(widget);
        this.add(this.content);
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(true);
    }

    private void applySettings() {
        Game.ruleset.getDifficultyManager().setCurrentDifficulty(this.content.difficultySelector.getSelectedDifficulty());
    }

    private class Content
    extends Widget {
        private int sectionGap;
        private int largeGap;
        private DifficultySelector difficultySelector;
        private Label title = new Label();
        private Button accept;
        private Button cancel;

        private Content() {
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.difficultySelector = new DifficultySelector();
            this.add(this.difficultySelector);
            this.accept = new Button();
            this.accept.setTheme("acceptbutton");
            this.accept.addCallback(new Runnable(){

                @Override
                public void run() {
                    InGameOptionsPopup.this.applySettings();
                    InGameOptionsPopup.this.closePopup();
                }
            });
            this.add((Widget)this.accept);
            this.cancel = new Button();
            this.cancel.setTheme("cancelbutton");
            this.cancel.addCallback(new Runnable(){

                @Override
                public void run() {
                    InGameOptionsPopup.this.closePopup();
                }
            });
            this.add((Widget)this.cancel);
        }

        protected void layout() {
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.title.setPosition(n - this.title.getWidth() / 2, this.getInnerY());
            this.difficultySelector.setSize(this.difficultySelector.getPreferredWidth(), this.difficultySelector.getPreferredHeight());
            this.difficultySelector.setPosition(n - this.difficultySelector.getWidth() / 2, this.title.getBottom() + this.largeGap);
            this.accept.setSize(this.accept.getPreferredWidth(), this.accept.getPreferredHeight());
            this.cancel.setSize(this.cancel.getPreferredWidth(), this.cancel.getPreferredHeight());
            this.accept.setPosition(n - this.sectionGap / 2 - this.accept.getWidth(), this.difficultySelector.getBottom() + this.largeGap);
            this.cancel.setPosition(n + this.sectionGap / 2, this.difficultySelector.getBottom() + this.largeGap);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.sectionGap = themeInfo.getParameter("sectiongap", 0);
            this.largeGap = themeInfo.getParameter("largegap", 0);
        }

        public int getPreferredWidth() {
            return this.difficultySelector.getPreferredWidth() + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return this.title.getPreferredHeight() + this.difficultySelector.getPreferredHeight() + this.accept.getPreferredHeight() + this.largeGap * 2 + this.getBorderVertical();
        }
    }
}

