/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import java.io.File;
import net.sf.hale.Game;
import net.sf.hale.mainmenu.ConfirmQuitPopup;
import net.sf.hale.mainmenu.InGameOptionsPopup;
import net.sf.hale.mainmenu.LoadGamePopup;
import net.sf.hale.mainmenu.SaveGamePopup;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SaveGameUtil;

public class InGameMenu
extends PopupWindow
implements LoadGamePopup.Callback,
SaveGamePopup.Callback {
    private final Widget content;

    public InGameMenu(Widget widget) {
        super(widget);
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(true);
        this.content = new Content();
        this.add(this.content);
    }

    @Override
    public void loadGameAccepted(String string) {
        Game.mainViewer.setLoadGame(string);
        Game.mainViewer.setVisible(false);
        Game.mainViewer.exitToMainMenu();
    }

    @Override
    public void saveGameAccepted(String string) {
        File file = SaveGameUtil.getSaveFile(string);
        try {
            SaveGameUtil.saveGame(file);
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error saving game to file " + file.getName(), exception);
            Game.mainViewer.addMessage("link", "Error saving game!");
            file.delete();
            return;
        }
        Game.mainViewer.addMessage("link", "Game saved successfully.");
        Game.mainViewer.updateInterface();
        this.closePopup();
    }

    private class Content
    extends DialogLayout {
        private final Button back = new Button();
        private final Button save;
        private final Button load;
        private final Button options;
        private final Button quit;
        private final Button exit;

        private Content() {
            this.back.setTheme("backbutton");
            this.back.addCallback(new Runnable(){

                @Override
                public void run() {
                    InGameMenu.this.closePopup();
                }
            });
            this.back.setEnabled(!Game.curCampaign.party.isDefeated());
            this.save = new Button();
            this.save.setTheme("savebutton");
            this.save.addCallback(new Runnable(){

                @Override
                public void run() {
                    if (Game.isInTurnMode() || Game.curCampaign.party.isDefeated()) {
                        Content.this.save.setEnabled(false);
                        return;
                    }
                    SaveGamePopup saveGamePopup = new SaveGamePopup((Widget)InGameMenu.this);
                    saveGamePopup.setCallback(InGameMenu.this);
                    saveGamePopup.openPopupCentered();
                }
            });
            this.load = new Button();
            this.load.setTheme("loadbutton");
            this.load.addCallback(new Runnable(){

                @Override
                public void run() {
                    LoadGamePopup loadGamePopup = new LoadGamePopup((Widget)InGameMenu.this, false);
                    loadGamePopup.setCallback(InGameMenu.this);
                    loadGamePopup.openPopupCentered();
                }
            });
            this.load.setEnabled(SaveGameUtil.getSaveGames().size() > 0);
            this.options = new Button();
            this.options.setTheme("optionsbutton");
            this.options.addCallback(new Runnable(){

                @Override
                public void run() {
                    new InGameOptionsPopup((Widget)InGameMenu.this).openPopupCentered();
                }
            });
            this.quit = new Button();
            this.quit.setTheme("menubutton");
            this.quit.addCallback(new Runnable(){

                @Override
                public void run() {
                    new ConfirmQuitPopup((Widget)InGameMenu.this, ConfirmQuitPopup.QuitMode.QuitToMenu).openPopupCentered();
                }
            });
            this.exit = new Button();
            this.exit.setTheme("exitbutton");
            this.exit.addCallback(new Runnable(){

                @Override
                public void run() {
                    new ConfirmQuitPopup((Widget)InGameMenu.this, ConfirmQuitPopup.QuitMode.ExitGame).openPopupCentered();
                }
            });
            this.save.setEnabled(!Game.isInTurnMode() && !Game.curCampaign.party.isDefeated());
            this.setHorizontalGroup(this.createParallelGroup(new Widget[]{this.back, this.save, this.load, this.options, this.quit, this.exit}));
            this.setVerticalGroup(this.createSequentialGroup(new Widget[]{this.back, this.save, this.load, this.options, this.quit, this.exit}));
        }
    }
}

