/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;

public class ErrorPopup
extends PopupWindow {
    private Content content;
    private List<String> messages;
    private Runnable callback;

    public ErrorPopup(Widget widget, List<String> list) {
        super(widget);
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(false);
        this.messages = new ArrayList<String>();
        this.messages.addAll(list);
        this.content = new Content();
        this.add(this.content);
    }

    public void setCallback(Runnable runnable) {
        this.callback = runnable;
    }

    private class Content
    extends Widget {
        private int gap;

        private Content() {
            for (String string : ErrorPopup.this.messages) {
                Label label = new Label(string);
                label.setTheme("messagelabel");
                this.add((Widget)label);
            }
            Button button = new Button();
            button.setTheme("acceptbutton");
            button.addCallback(new Runnable(){

                @Override
                public void run() {
                    if (ErrorPopup.this.callback != null) {
                        ErrorPopup.this.callback.run();
                    }
                    ErrorPopup.this.closePopup();
                }
            });
            this.add((Widget)button);
        }

        public int getPreferredHeight() {
            int n = this.getBorderVertical();
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Widget widget = this.getChild(i);
                n += widget.getPreferredHeight() + this.gap;
            }
            return n -= this.gap;
        }

        public int getPreferredWidth() {
            int n = 0;
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Widget widget = this.getChild(i);
                n = Math.max(n, widget.getPreferredWidth());
            }
            return n + this.getBorderHorizontal();
        }

        protected void layout() {
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            int n2 = this.getInnerY();
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Widget widget = this.getChild(i);
                widget.setSize(widget.getPreferredWidth(), widget.getPreferredHeight());
                widget.setPosition(n - widget.getWidth() / 2, n2);
                n2 = widget.getBottom() + this.gap;
            }
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.gap = themeInfo.getParameter("gap", 0);
        }
    }
}

