/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.DifficultyManager;
import net.sf.hale.Game;

public class DifficultySelector
extends Widget {
    private DifficultyManager manager;
    private ToggleButton activeDifficultyButton;
    private HTMLTextAreaModel textAreaModel;
    private TextArea textArea;
    private Label difficultyLabel = new Label();
    private List<ToggleButton> buttons;

    public DifficultySelector() {
        this.difficultyLabel.setTheme("difficultylabel");
        this.add((Widget)this.difficultyLabel);
        this.buttons = new ArrayList<ToggleButton>();
        this.manager = Game.ruleset.getDifficultyManager();
        for (String string : this.manager.getDifficultyLevels()) {
            SelectorButton selectorButton = new SelectorButton(string);
            selectorButton.setTheme("difficultybutton");
            if (string.equals(this.manager.getCurrentDifficulty())) {
                selectorButton.setActive(true);
                this.activeDifficultyButton = selectorButton;
            }
            this.buttons.add(selectorButton);
            this.add((Widget)selectorButton);
        }
        this.textAreaModel = new HTMLTextAreaModel();
        this.textAreaModel.setHtml(this.manager.getDifficultyDescription(this.manager.getCurrentDifficulty()));
        this.textArea = new TextArea((TextAreaModel)this.textAreaModel);
        this.textArea.setTheme("difficultydescription");
        this.add((Widget)this.textArea);
    }

    protected void layout() {
        int n;
        int n2 = this.getInnerX() + this.getInnerWidth() / 2;
        this.difficultyLabel.setSize(this.difficultyLabel.getPreferredWidth(), this.difficultyLabel.getPreferredHeight());
        this.difficultyLabel.setPosition(n2 - this.difficultyLabel.getWidth() / 2, this.getInnerY());
        int n3 = this.getInnerX();
        int n4 = n = this.difficultyLabel.getBottom();
        for (ToggleButton toggleButton : this.buttons) {
            toggleButton.setSize(toggleButton.getPreferredWidth(), toggleButton.getPreferredHeight());
            toggleButton.setPosition(n3, n);
            n3 = toggleButton.getRight();
            n4 = toggleButton.getBottom();
        }
        this.textArea.setSize(this.getInnerWidth(), Math.min(this.textArea.getPreferredHeight(), this.textArea.getMaxHeight()));
        this.textArea.setPosition(this.getInnerX(), n4);
    }

    public int getPreferredWidth() {
        int n = 0;
        for (ToggleButton toggleButton : this.buttons) {
            n += toggleButton.getPreferredWidth();
        }
        return n + this.getBorderHorizontal();
    }

    public int getPreferredHeight() {
        int n = 0;
        for (ToggleButton toggleButton : this.buttons) {
            n = Math.max(n, toggleButton.getPreferredHeight());
        }
        return (n += Math.min(this.textArea.getPreferredHeight(), this.textArea.getMaxHeight())) + this.difficultyLabel.getPreferredHeight() + this.getBorderVertical();
    }

    public String getSelectedDifficulty() {
        return this.activeDifficultyButton.getText();
    }

    private void difficultyButtonPressed(SelectorButton selectorButton) {
        if (this.activeDifficultyButton != null) {
            this.activeDifficultyButton.setActive(false);
        }
        selectorButton.setActive(true);
        this.activeDifficultyButton = selectorButton;
        this.textAreaModel.setHtml(this.manager.getDifficultyDescription(selectorButton.difficulty));
    }

    private class SelectorButton
    extends ToggleButton
    implements Runnable {
        private String difficulty;

        private SelectorButton(String string) {
            super(string);
            this.difficulty = string;
            this.addCallback(this);
        }

        @Override
        public void run() {
            DifficultySelector.this.difficultyButtonPressed(this);
        }
    }
}

