/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;

public class ConfirmationPopup
extends PopupWindow {
    private Content content;
    private List<Runnable> callbacks;

    public ConfirmationPopup(Widget widget) {
        super(widget);
        this.setCloseOnClickedOutside(false);
        this.content = new Content();
        this.add(this.content);
        this.callbacks = new ArrayList<Runnable>();
    }

    public void setWarningText(String string) {
        this.content.warning.setText(string);
    }

    public void setTitleText(String string) {
        this.content.title.setText(string);
    }

    public void addCallback(Runnable runnable) {
        this.callbacks.add(runnable);
    }

    private class Content
    extends Widget {
        private Label title = new Label();
        private Label warning;
        private Button yes;
        private Button no;
        private int titleGap;
        private int acceptCancelGap;

        private Content() {
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.warning = new Label();
            this.warning.setTheme("warninglabel");
            this.add((Widget)this.warning);
            this.yes = new Button("Yes");
            this.yes.setTheme("acceptbutton");
            this.yes.addCallback(new Runnable(){

                @Override
                public void run() {
                    Content.this.setVisible(false);
                    for (Runnable runnable : ConfirmationPopup.this.callbacks) {
                        runnable.run();
                    }
                    ConfirmationPopup.this.closePopup();
                }
            });
            this.add((Widget)this.yes);
            this.no = new Button("No");
            this.no.setTheme("cancelbutton");
            this.no.addCallback(new Runnable(){

                @Override
                public void run() {
                    ConfirmationPopup.this.closePopup();
                }
            });
            this.add((Widget)this.no);
        }

        public int getPreferredWidth() {
            int n = this.no.getPreferredWidth() + this.yes.getPreferredWidth() + 2 * this.acceptCancelGap;
            int n2 = Math.max(this.title.getPreferredWidth(), this.warning.getPreferredWidth());
            return Math.max(n, n2) + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            int n = this.title.getPreferredHeight() + this.titleGap;
            n += Math.max(this.yes.getPreferredHeight(), this.no.getPreferredHeight());
            if (this.warning.getPreferredHeight() != 0) {
                n += this.warning.getPreferredHeight() + this.titleGap;
            }
            return n + this.getBorderVertical();
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.titleGap = themeInfo.getParameter("titleGap", 0);
            this.acceptCancelGap = themeInfo.getParameter("acceptCancelGap", 0);
        }

        protected void layout() {
            super.layout();
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.warning.setSize(this.warning.getPreferredWidth(), this.warning.getPreferredHeight());
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            this.title.setPosition(n - this.title.getWidth() / 2, this.getInnerY());
            this.warning.setPosition(n - this.warning.getWidth() / 2, this.title.getBottom() + this.titleGap);
            this.yes.setSize(this.yes.getPreferredWidth(), this.yes.getPreferredHeight());
            this.no.setSize(this.no.getPreferredWidth(), this.no.getPreferredHeight());
            int n2 = this.title.getBottom() + this.titleGap;
            if (this.warning.getPreferredHeight() != 0) {
                n2 = this.warning.getBottom() + this.titleGap;
            }
            this.no.setPosition(n + this.acceptCancelGap, n2);
            this.yes.setPosition(n - this.acceptCancelGap - this.yes.getWidth(), n2);
        }
    }
}

