/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.entity.PC;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.mainmenu.PartyFormationWindow;
import net.sf.hale.mainmenu.UniqueCharacter;
import net.sf.hale.rules.Role;
import net.sf.hale.view.CharacterWindow;
import net.sf.hale.widgets.BasePortraitViewer;
import net.sf.hale.widgets.TextAreaNoInput;

public class CharacterSelector
extends Widget {
    private int numRoleLines;
    private int expandBoxY;
    private int expandBoxBorder;
    private Button details;
    private HTMLTextAreaModel textAreaModel;
    private TextArea textArea;
    private Button addRemove;
    private ExpandBox expand;
    private boolean characterMeetsLevelRequirements;
    private UniqueCharacter character;
    private PC pc;
    private Widget parent;
    private BasePortraitViewer portrait;
    private DeleteButton deleteButton;
    private PartyFormationWindow newGameWindow;
    private boolean showDeleteButtons;
    private Set<String> charactersInParties;

    public CharacterSelector(UniqueCharacter uniqueCharacter, Widget widget, Set<String> set) {
        this.charactersInParties = set;
        if (set == null) {
            this.charactersInParties = Collections.emptySet();
        }
        this.character = uniqueCharacter;
        this.pc = uniqueCharacter.getBestCreature();
        boolean bl = this.characterMeetsLevelRequirements = this.pc != null;
        if (this.pc == null) {
            this.pc = uniqueCharacter.iterator().next();
        }
        this.parent = widget;
        this.textAreaModel = new HTMLTextAreaModel();
        this.textArea = new TextAreaNoInput((TextAreaModel)this.textAreaModel);
        this.textArea.setTheme("description");
        this.textAreaModel.setHtml(this.getDescription());
        this.add((Widget)this.textArea);
        this.details = new Button();
        this.details.setTheme("detailsbutton");
        this.details.addCallback(new Runnable(){

            @Override
            public void run() {
                CharWindow charWindow = new CharWindow();
                CharacterSelector.this.parent.add((Widget)charWindow);
                charWindow.updateContent(CharacterSelector.this.pc);
                charWindow.setPosition(CharacterSelector.this.details.getRight(), CharacterSelector.this.details.getY() - 150);
            }
        });
        this.add((Widget)this.details);
        this.portrait = new BasePortraitViewer(this.pc);
        this.portrait.setEnableEventHandling(false);
        this.add((Widget)this.portrait);
        this.expand = new ExpandBox();
        this.setDeleteExpandState();
    }

    public CharacterSelector(PC pC, Widget widget) {
        this(new UniqueCharacter(pC), widget, null);
    }

    public void showDeleteButtons() {
        this.showDeleteButtons = true;
        this.setDeleteExpandState();
    }

    private void setDeleteExpandState() {
        if (this.expand != null) {
            this.removeChild((Widget)this.expand);
            if (this.character.size() > 1) {
                this.add((Widget)this.expand);
            }
        }
        if (this.showDeleteButtons) {
            if (this.deleteButton != null) {
                this.removeChild((Widget)this.deleteButton);
            }
            if (this.character.size() <= 1) {
                this.deleteButton = new DeleteButton(this.character.getFirstCreature(), null);
                this.add((Widget)this.deleteButton);
            }
        }
    }

    public PC getCreature() {
        return this.pc;
    }

    public void setNewGameWindow(PartyFormationWindow partyFormationWindow) {
        this.newGameWindow = partyFormationWindow;
    }

    private void setSelectedCreature(PC pC) {
        this.pc = pC;
        this.textAreaModel.setHtml(this.getDescription());
        this.setDeleteExpandState();
    }

    public String getCreatureID() {
        return this.pc.getTemplate().getID();
    }

    public void setAddRemoveButton(String string, Runnable runnable) {
        if (string == null) {
            if (this.addRemove != null) {
                this.removeChild((Widget)this.addRemove);
                this.addRemove = null;
            }
        } else {
            this.addRemove = new Button(string);
            this.addRemove.setTheme("addremovebutton");
            this.addRemove.addCallback(runnable);
            this.addRemove.setEnabled(this.characterMeetsLevelRequirements);
            if (!this.addRemove.isEnabled()) {
                this.addRemove.setTooltipContent((Object)"No version of this character meets the level requirements");
            }
            this.add((Widget)this.addRemove);
        }
        this.invalidateLayout();
    }

    public void setAddRemoveEnabled(boolean bl) {
        if (this.addRemove != null) {
            this.addRemove.setEnabled(bl && this.characterMeetsLevelRequirements);
        }
    }

    private String getDescription() {
        this.numRoleLines = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div style=\"font-family: medium-bold;\">").append(this.pc.getTemplate().getName()).append("</div>");
        stringBuilder.append("<div style=\"font-family: medium;\">");
        stringBuilder.append((Object)this.pc.getTemplate().getGender()).append(' ');
        stringBuilder.append("<span style=\"font-family: medium-blue;\">").append(this.pc.getTemplate().getRace().getName()).append("</span>");
        stringBuilder.append("</div>");
        stringBuilder.append("<div style=\"font-family: medium; margin-bottom: 1em\">");
        for (String string : this.pc.roles.getRoleIDs()) {
            Role role = Game.ruleset.getRole(string);
            int n = this.pc.roles.getLevel(role);
            stringBuilder.append("<p>");
            stringBuilder.append("Level <span style=\"font-family: medium-italic;\">").append(n).append("</span> ");
            stringBuilder.append("<span style=\"font-family: medium-red;\">").append(role.getName()).append("</span>");
            stringBuilder.append("</p>");
            ++this.numRoleLines;
        }
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.expandBoxY = themeInfo.getParameter("expandboxy", 0);
        this.expandBoxBorder = themeInfo.getParameter("expandboxborder", 0);
    }

    public int getPreferredWidth() {
        return this.portrait.getPreferredWidth() + this.textArea.getPreferredWidth() + this.getBorderHorizontal();
    }

    public int getPreferredHeight() {
        int n = this.textArea.getPreferredInnerHeight() + this.textArea.getBorderVertical();
        n += this.details.getPreferredHeight();
        if (this.addRemove != null) {
            n += this.addRemove.getPreferredHeight();
        }
        return Math.max(n, this.portrait.getPreferredHeight()) + this.getBorderVertical();
    }

    protected void layout() {
        this.portrait.setSize(this.portrait.getPreferredWidth(), this.portrait.getPreferredHeight());
        this.portrait.setPosition(this.getInnerX(), this.getInnerY() + (this.getInnerHeight() - this.portrait.getHeight()) / 2);
        this.textArea.setPosition(this.portrait.getRight(), this.getInnerY());
        this.textArea.setSize(this.textArea.getPreferredWidth(), this.textArea.getPreferredHeight());
        int n = this.getInnerRight() - this.portrait.getRight();
        this.details.setSize(this.details.getPreferredWidth(), this.details.getPreferredHeight());
        this.details.setPosition(this.portrait.getRight() + n / 2 - this.details.getWidth() / 2, this.getInnerBottom() - this.details.getHeight());
        this.expand.setSize(this.textArea.getWidth() - this.expandBoxBorder * 2, this.expand.getPreferredHeight());
        this.expand.setPosition(this.textArea.getX() + this.expandBoxBorder, this.getInnerY() + this.expandBoxY);
        if (this.addRemove != null) {
            this.addRemove.setSize(this.addRemove.getPreferredWidth(), this.addRemove.getPreferredHeight());
            this.addRemove.setPosition(this.portrait.getRight() + n / 2 - this.addRemove.getWidth() / 2, this.details.getY() - this.addRemove.getHeight());
        }
        if (this.deleteButton != null) {
            this.deleteButton.setSize(this.deleteButton.getPreferredWidth(), this.deleteButton.getPreferredHeight());
            this.deleteButton.setPosition(this.getInnerRight() - this.deleteButton.getWidth() - this.expandBoxBorder, this.getInnerY() + this.expandBoxY + this.expandBoxBorder);
        }
    }

    private class CharacterButton
    extends ToggleButton
    implements Runnable {
        private int height;
        private int numRows;
        private PopupWindow popup;
        private PC pc;
        private TextArea textArea;
        private HTMLTextAreaModel textAreaModel;

        private CharacterButton(PC pC, PopupWindow popupWindow) {
            if (!CharacterSelector.this.character.meetsLevelConstraints(pC)) {
                this.setEnabled(false);
            }
            if (pC == CharacterSelector.this.pc) {
                this.setActive(true);
            }
            this.popup = popupWindow;
            this.pc = pC;
            this.textAreaModel = new HTMLTextAreaModel();
            this.numRows = 0;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<div style=\"font-family: medium\">");
            for (String string : pC.roles.getRoleIDs()) {
                Role role = Game.ruleset.getRole(string);
                int n = pC.roles.getLevel(role);
                stringBuilder.append("<p>");
                stringBuilder.append("Level <span style=\"font-family: medium-italic;\">").append(n).append("</span> ");
                stringBuilder.append("<span style=\"font-family: medium-red;\">").append(role.getName()).append("</span>");
                stringBuilder.append("</p>");
                ++this.numRows;
            }
            stringBuilder.append("</div>");
            this.textAreaModel.setHtml(stringBuilder.toString());
            this.textArea = new TextAreaNoInput((TextAreaModel)this.textAreaModel);
            this.textArea.setTheme("textarea");
            this.add((Widget)this.textArea);
            this.addCallback(this);
        }

        @Override
        public void run() {
            this.popup.closePopup();
            CharacterSelector.this.setSelectedCreature(this.pc);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.height = themeInfo.getParameter("height", 0);
            if (!this.isEnabled()) {
                int n;
                int n2 = Game.curCampaign.getMinStartingLevel();
                if (n2 == (n = Game.curCampaign.getMaxStartingLevel())) {
                    this.setTooltipContent("All characters must be level " + n2);
                } else {
                    this.setTooltipContent("All characters must be from level " + n2 + " to " + n);
                }
            }
        }

        public int getPreferredHeight() {
            return this.height * this.numRows;
        }

        protected void layout() {
            this.textArea.setPosition(this.getX(), this.getY());
            this.textArea.setSize(this.getWidth(), this.textArea.getPreferredHeight());
        }
    }

    private class DeleteCallback
    implements Runnable {
        private PC pc;
        private PopupWindow parent;

        private DeleteCallback(PC pC, PopupWindow popupWindow) {
            this.pc = pC;
            this.parent = popupWindow;
        }

        @Override
        public void run() {
            CharacterSelector.this.character.deleteCreature(this.pc);
            if (CharacterSelector.this.character.size() == 0) {
                if (CharacterSelector.this.newGameWindow != null) {
                    CharacterSelector.this.newGameWindow.removeSelector(CharacterSelector.this);
                }
            } else if (this.pc == CharacterSelector.this.pc) {
                PC pC = CharacterSelector.this.character.getBestCreature();
                if (pC == null) {
                    CharacterSelector.this.newGameWindow.removeSelector(CharacterSelector.this);
                } else {
                    CharacterSelector.this.setSelectedCreature(CharacterSelector.this.character.getBestCreature());
                }
            }
            if (this.parent != null) {
                this.parent.closePopup();
            }
        }
    }

    private class DeleteButton
    extends Button
    implements Runnable {
        private PC pc;
        private PopupWindow parent;

        private DeleteButton(PC pC, PopupWindow popupWindow) {
            this.pc = pC;
            this.parent = popupWindow;
            this.addCallback(this);
            if (pC.getTemplate().isPregenerated()) {
                this.setEnabled(false);
                this.setTooltipContent("This character is pregenerated and may not be deleted.");
            } else if (CharacterSelector.this.charactersInParties.contains(pC.getTemplate().getID())) {
                this.setEnabled(false);
                this.setTooltipContent("This character is in one or more parties and may not be deleted.");
            }
        }

        @Override
        public void run() {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup(CharacterSelector.this);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Delete ");
            stringBuilder.append(this.pc.getTemplate().getName());
            stringBuilder.append(", Level ");
            stringBuilder.append(this.pc.roles.getTotalLevel());
            stringBuilder.append(" ");
            stringBuilder.append(this.pc.roles.getBaseRole().getName());
            stringBuilder.append("?");
            confirmationPopup.setTitleText(stringBuilder.toString());
            confirmationPopup.setWarningText("This action is permanent and cannot be undone.");
            confirmationPopup.addCallback(new DeleteCallback(this.pc, this.parent));
            confirmationPopup.openPopupCentered();
        }
    }

    private class PopupContent
    extends Widget {
        private List<CharacterButton> selectors;
        private List<DeleteButton> deleteButtons;

        private PopupContent(PopupWindow popupWindow) {
            this.setTheme("content");
            this.selectors = new ArrayList<CharacterButton>();
            this.deleteButtons = new ArrayList<DeleteButton>();
            for (PC pC : CharacterSelector.this.character) {
                CharacterButton characterButton = new CharacterButton(pC, popupWindow);
                this.add((Widget)characterButton);
                this.selectors.add(characterButton);
                DeleteButton deleteButton = new DeleteButton(pC, popupWindow);
                if (CharacterSelector.this.showDeleteButtons) {
                    this.add((Widget)deleteButton);
                }
                this.deleteButtons.add(deleteButton);
            }
        }

        public int getPreferredHeight() {
            int n = this.getBorderVertical();
            for (CharacterButton characterButton : this.selectors) {
                n += characterButton.getPreferredHeight();
            }
            return n;
        }

        protected void layout() {
            int n = this.getInnerY();
            for (int i = 0; i < this.selectors.size(); ++i) {
                CharacterButton characterButton = this.selectors.get(i);
                DeleteButton deleteButton = this.deleteButtons.get(i);
                characterButton.setSize(this.getInnerWidth(), characterButton.getPreferredHeight());
                characterButton.setPosition(this.getInnerX(), n);
                deleteButton.setSize(deleteButton.getPreferredWidth(), deleteButton.getPreferredHeight());
                deleteButton.setPosition(characterButton.getInnerRight() - deleteButton.getWidth(), characterButton.getInnerY());
                n = characterButton.getBottom();
            }
        }
    }

    private class Popup
    extends PopupWindow {
        private Popup(Widget widget) {
            super(widget);
            this.setTheme("characterselectorpopup");
            this.add(new PopupContent(this));
        }
    }

    private class ExpandBox
    extends Label
    implements CallbackWithReason<Label.CallbackReason> {
        private boolean boxHover;
        private Button expand;
        private Widget box = new Widget(this.getAnimationState());

        private ExpandBox() {
            this.box.setTheme("box");
            if (!CharacterSelector.this.characterMeetsLevelRequirements) {
                this.box.setEnabled(false);
                this.box.getAnimationState().setAnimationState(STATE_DISABLED, true);
            }
            this.add(this.box);
            this.expand = new Button(this.getAnimationState());
            this.expand.setTheme("expandbutton");
            this.expand.getModel().addStateCallback(new Runnable(){

                @Override
                public void run() {
                    ExpandBox.this.updateHover();
                }
            });
            this.expand.addCallback(new Runnable(){

                @Override
                public void run() {
                    ExpandBox.this.openPopup();
                }
            });
            this.add((Widget)this.expand);
            this.addCallback(this);
        }

        private void openPopup() {
            Popup popup = new Popup(CharacterSelector.this.parent);
            popup.openPopup();
            popup.setPosition(this.getX(), this.getInnerBottom());
            popup.setSize(this.getWidth(), popup.getPreferredHeight());
        }

        public void callback(Label.CallbackReason callbackReason) {
            this.openPopup();
        }

        private void updateHover() {
            this.getAnimationState().setAnimationState(Label.STATE_HOVER, this.boxHover || this.expand.getModel().isHover());
        }

        public int getPreferredInnerHeight() {
            return CharacterSelector.this.numRoleLines * this.expand.getPreferredHeight() + this.box.getBorderVertical();
        }

        protected void layout() {
            this.expand.setSize(this.expand.getPreferredWidth(), this.getPreferredInnerHeight());
            this.expand.setPosition(this.getInnerRight() - this.expand.getWidth(), this.getInnerY() + (this.getInnerHeight() - this.expand.getHeight()) / 2);
            this.box.setSize(this.getInnerWidth(), this.getInnerHeight());
            this.box.setPosition(this.getInnerX(), this.getInnerY());
        }

        protected void handleMouseHover(Event event) {
            if (event.isMouseEvent()) {
                boolean bl;
                boolean bl2 = bl = event.getType() != Event.Type.MOUSE_EXITED;
                if (bl != this.boxHover) {
                    this.boxHover = bl;
                    this.updateHover();
                }
            }
        }
    }

    private class CharWindow
    extends CharacterWindow {
        public CharWindow() {
            this.setTheme("characterwindow");
            this.hideExportButton();
        }

        @Override
        public void run() {
            CharacterSelector.this.parent.removeChild((Widget)this);
        }
    }
}

