/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.hale.Game;
import net.sf.hale.mainmenu.CampaignGroupSelector;
import net.sf.hale.mainmenu.MainMenu;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONParser;

public class CampaignPopup
extends PopupWindow {
    private CampaignGroupSelector selectedGroup;
    private Content content;
    private MainMenu mainMenu;

    public CampaignPopup(MainMenu mainMenu) {
        super((Widget)mainMenu);
        this.mainMenu = mainMenu;
        this.content = new Content();
        this.add(this.content);
    }

    protected void groupSelected(CampaignGroupSelector campaignGroupSelector) {
        if (this.selectedGroup != null && this.selectedGroup != campaignGroupSelector) {
            this.selectedGroup.deselect();
        }
        this.selectedGroup = campaignGroupSelector;
        this.content.textAreaModel.setHtml(campaignGroupSelector.getSelectedDescription());
        this.content.textPane.invalidateLayout();
        this.content.accept.setEnabled(true);
    }

    private static List<CampaignGroupSelector> getAvailableGroups(Map<String, CampaignGroupSelector.CampaignDescriptor> map) {
        ArrayList<CampaignGroupSelector> arrayList = new ArrayList<CampaignGroupSelector>();
        try {
            for (String object : new File("campaigns").list()) {
                File file = new File("campaigns/" + object);
                if (!file.isFile() || !file.getName().endsWith(ResourceType.JSON.getExtension())) continue;
                String string = ResourceManager.getResourceID(file.getName(), ResourceType.JSON);
                CampaignGroupSelector campaignGroupSelector = new CampaignGroupSelector(string, map);
                arrayList.add(campaignGroupSelector);
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error generating list of campaign groups.", exception);
        }
        HashSet hashSet = new HashSet();
        for (CampaignGroupSelector campaignGroupSelector : arrayList) {
            hashSet.addAll(campaignGroupSelector.getAllCampaignIDs());
        }
        for (String string : map.keySet()) {
            if (hashSet.contains(string)) continue;
            CampaignGroupSelector campaignGroupSelector = new CampaignGroupSelector(map.get(string));
            arrayList.add(campaignGroupSelector);
        }
        Collections.sort(arrayList, new Comparator<CampaignGroupSelector>(){

            @Override
            public int compare(CampaignGroupSelector campaignGroupSelector, CampaignGroupSelector campaignGroupSelector2) {
                return campaignGroupSelector.getCampaignName().compareTo(campaignGroupSelector2.getCampaignName());
            }
        });
        return arrayList;
    }

    private static Map<String, CampaignGroupSelector.CampaignDescriptor> getAvailableCampaigns() {
        ArrayList<CampaignGroupSelector.CampaignDescriptor> arrayList = new ArrayList<CampaignGroupSelector.CampaignDescriptor>();
        File file = new File("campaigns");
        String[] stringArray = file.list();
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            File file2;
            for (String string2 : stringArray) {
                file2 = new File("campaigns/" + string2);
                if (!file2.isDirectory() || file2.getName().startsWith(".")) continue;
                object3 = new SimpleJSONParser(new File(file2.getPath() + "/campaign" + ResourceType.JSON.getExtension()));
                object2 = string2;
                object = FileUtil.readFileAsString(file2.getPath() + "/description" + ResourceType.HTML.getExtension());
                string = ((SimpleJSONParser)object3).get("name", string2);
                arrayList.add(new CampaignGroupSelector.CampaignDescriptor((String)object2, string, (String)object));
            }
            for (String string2 : stringArray) {
                file2 = new File("campaigns/" + string2);
                if (!file2.isFile() || !file2.getName().endsWith(ResourceType.Zip.getExtension()) || CampaignPopup.containsCampaign(arrayList, (String)(object3 = ResourceManager.getResourceID(file2.getName(), ResourceType.Zip)))) continue;
                object2 = new ZipFile(file2);
                object = ((ZipFile)object2).getEntry("description" + ResourceType.HTML.getExtension());
                string = ResourceManager.getResourceAsString(((ZipFile)object2).getInputStream((ZipEntry)object));
                ZipEntry zipEntry = ((ZipFile)object2).getEntry("campaign" + ResourceType.JSON.getExtension());
                SimpleJSONParser simpleJSONParser = new SimpleJSONParser(((ZipFile)object2).getName() + "/campaign", ((ZipFile)object2).getInputStream(zipEntry));
                String string3 = simpleJSONParser.get("name", (String)object3);
                arrayList.add(new CampaignGroupSelector.CampaignDescriptor((String)object3, string3, string));
                ((ZipFile)object2).close();
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error generating list of campaigns.", exception);
        }
        Collections.sort(arrayList, new Comparator<CampaignGroupSelector.CampaignDescriptor>(){

            @Override
            public int compare(CampaignGroupSelector.CampaignDescriptor campaignDescriptor, CampaignGroupSelector.CampaignDescriptor campaignDescriptor2) {
                return campaignDescriptor.id.compareTo(campaignDescriptor2.id);
            }
        });
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (CampaignGroupSelector.CampaignDescriptor campaignDescriptor : arrayList) {
            linkedHashMap.put(campaignDescriptor.id, campaignDescriptor);
        }
        return linkedHashMap;
    }

    private static boolean containsCampaign(List<CampaignGroupSelector.CampaignDescriptor> list, String string) {
        for (CampaignGroupSelector.CampaignDescriptor campaignDescriptor : list) {
            if (!campaignDescriptor.id.equals(string)) continue;
            return true;
        }
        return false;
    }

    private class Content
    extends Widget {
        private Label title;
        private ScrollPane selectorPane;
        private DialogLayout paneContent;
        private Button accept;
        private Button cancel;
        private HTMLTextAreaModel textAreaModel;
        private ScrollPane textPane;
        private int acceptCancelGap;

        private Content() {
            CampaignPopup.this.content = this;
            this.title = new Label();
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.textAreaModel = new HTMLTextAreaModel();
            TextArea textArea = new TextArea((TextAreaModel)this.textAreaModel);
            this.textPane = new ScrollPane((Widget)textArea);
            this.textPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            this.textPane.setCanAcceptKeyboardFocus(false);
            this.textPane.setTheme("descriptionpane");
            this.add((Widget)this.textPane);
            this.paneContent = new DialogLayout();
            this.paneContent.setTheme("content");
            this.selectorPane = new ScrollPane((Widget)this.paneContent);
            this.selectorPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            this.selectorPane.setTheme("selectorpane");
            this.add((Widget)this.selectorPane);
            this.accept = new Button();
            this.accept.setTheme("acceptbutton");
            this.accept.addCallback(new Runnable(){

                @Override
                public void run() {
                    CampaignPopup.this.mainMenu.loadCampaign(CampaignPopup.this.selectedGroup.getSelectedID());
                    CampaignPopup.this.mainMenu.update();
                    CampaignPopup.this.closePopup();
                }
            });
            this.accept.setEnabled(false);
            this.add((Widget)this.accept);
            this.cancel = new Button();
            this.cancel.setTheme("cancelbutton");
            this.cancel.addCallback(new Runnable(){

                @Override
                public void run() {
                    CampaignPopup.this.closePopup();
                }
            });
            this.add((Widget)this.cancel);
            DialogLayout.Group group = this.paneContent.createParallelGroup();
            DialogLayout.Group group2 = this.paneContent.createSequentialGroup();
            Map map = CampaignPopup.getAvailableCampaigns();
            for (CampaignGroupSelector campaignGroupSelector : CampaignPopup.getAvailableGroups(map)) {
                campaignGroupSelector.setCallback(CampaignPopup.this);
                if (Game.curCampaign != null) {
                    campaignGroupSelector.selectCampaign(Game.curCampaign.getID());
                }
                group.addWidget((Widget)campaignGroupSelector);
                group2.addWidget((Widget)campaignGroupSelector);
            }
            this.paneContent.setHorizontalGroup(group);
            this.paneContent.setVerticalGroup(group2);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.acceptCancelGap = themeInfo.getParameter("acceptCancelGap", 0);
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerX() + this.getWidth() / 2;
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.accept.setSize(this.accept.getPreferredWidth(), this.accept.getPreferredHeight());
            this.cancel.setSize(this.cancel.getPreferredWidth(), this.cancel.getPreferredHeight());
            this.title.setPosition(n - this.title.getWidth() / 2, this.getInnerY());
            this.accept.setPosition(n - this.acceptCancelGap - this.accept.getWidth(), this.getInnerBottom() - this.accept.getHeight());
            this.cancel.setPosition(n + this.acceptCancelGap, this.getInnerBottom() - this.cancel.getHeight());
            int n2 = Math.min(this.accept.getY(), this.cancel.getY());
            this.selectorPane.setPosition(this.getInnerX(), this.title.getBottom());
            this.selectorPane.setSize(this.selectorPane.getPreferredWidth(), n2 - this.title.getBottom());
            this.textPane.setPosition(this.selectorPane.getRight(), this.title.getBottom());
            this.textPane.setSize(this.getInnerRight() - this.textPane.getX(), n2 - this.title.getBottom());
        }
    }
}

