/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.hale.mainmenu.CampaignPopup;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONParser;

public class CampaignGroupSelector
extends ToggleButton
implements Runnable {
    private final CampaignGroup group;
    private CampaignPopup callback;
    private Label groupName;
    private CampaignSelector selected;

    private CampaignGroupSelector(CampaignGroup campaignGroup) {
        this.group = campaignGroup;
        this.groupName = new Label(campaignGroup.name);
        this.groupName.setTheme("namelabel");
        this.add((Widget)this.groupName);
        this.addCallback(this);
    }

    public CampaignGroupSelector(CampaignDescriptor campaignDescriptor) {
        this(new CampaignGroup(campaignDescriptor));
    }

    public CampaignGroupSelector(String string, Map<String, CampaignDescriptor> map) {
        this(new CampaignGroup(string, map));
    }

    public List<String> getAllCampaignIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CampaignDescriptor campaignDescriptor : this.group.entries) {
            arrayList.add(campaignDescriptor.id);
        }
        return arrayList;
    }

    public void deselect() {
        this.setActive(false);
        this.removeAllChildren();
        this.add((Widget)this.groupName);
        this.invalidateLayout();
    }

    public void selectCampaign(String string) {
        if (string == null) {
            return;
        }
        for (CampaignDescriptor campaignDescriptor : this.group.entries) {
            if (!campaignDescriptor.id.equals(string)) continue;
            this.addChildWidgets(campaignDescriptor);
            this.callback.groupSelected(this);
            this.setActive(true);
        }
    }

    private void addChildWidgets(CampaignDescriptor campaignDescriptor) {
        this.removeAllChildren();
        this.add((Widget)this.groupName);
        for (CampaignDescriptor campaignDescriptor2 : this.group.entries) {
            CampaignSelector campaignSelector = new CampaignSelector(campaignDescriptor2);
            if (campaignDescriptor2 == campaignDescriptor) {
                this.selected = campaignSelector;
                campaignSelector.setActive(true);
            }
            if (this.group.entries.size() <= 1) continue;
            this.add((Widget)campaignSelector);
        }
        this.invalidateLayout();
    }

    @Override
    public void run() {
        this.addChildWidgets(this.group.defaultEntry);
        this.callback.groupSelected(this);
        this.setActive(true);
    }

    public String getSelectedID() {
        return ((CampaignSelector)this.selected).descriptor.id;
    }

    public String getSelectedDescription() {
        return ((CampaignSelector)this.selected).descriptor.description;
    }

    public String getCampaignName() {
        return this.group.name;
    }

    public void setCallback(CampaignPopup campaignPopup) {
        this.callback = campaignPopup;
    }

    public int getPreferredHeight() {
        int n = 0;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            n += this.getChild(i).getPreferredHeight();
        }
        return n + this.getBorderVertical();
    }

    protected void layout() {
        int n = this.getNumChildren();
        if (n == 1) {
            this.groupName.setPosition(this.getInnerX(), this.getInnerY() + this.getInnerHeight() / 2);
        } else {
            this.groupName.setPosition(this.getInnerX(), this.getInnerY() + this.groupName.getPreferredHeight() / 2);
        }
        int n2 = this.getInnerY() + this.groupName.getPreferredHeight();
        for (int i = 1; i < n; ++i) {
            Widget widget = this.getChild(i);
            widget.setSize(this.getInnerWidth(), widget.getPreferredHeight());
            widget.setPosition(this.getInnerX(), n2);
            n2 = widget.getBottom();
        }
    }

    private static class CampaignGroup {
        private final String name;
        private final CampaignDescriptor defaultEntry;
        private final List<CampaignDescriptor> entries;

        private CampaignGroup(CampaignDescriptor campaignDescriptor) {
            this.name = campaignDescriptor.name;
            this.defaultEntry = campaignDescriptor;
            this.entries = Collections.singletonList(campaignDescriptor);
        }

        private CampaignGroup(String string, Map<String, CampaignDescriptor> map) {
            SimpleJSONParser simpleJSONParser = new SimpleJSONParser(new File("campaigns/" + string + ResourceType.JSON.getExtension()));
            this.name = simpleJSONParser.get("name", string);
            String string2 = simpleJSONParser.get("defaultCampaign", null);
            this.defaultEntry = map.get(string2);
            this.entries = new ArrayList<CampaignDescriptor>();
            SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("campaigns");
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
                String string3 = simpleJSONArrayEntry.getString();
                this.entries.add(map.get(string3));
            }
        }
    }

    public static class CampaignDescriptor {
        public final String id;
        public final String name;
        public final String description;

        protected CampaignDescriptor(String string, String string2, String string3) {
            this.id = string;
            this.name = string2;
            this.description = string3;
        }
    }

    private class CampaignSelector
    extends ToggleButton
    implements Runnable {
        private CampaignDescriptor descriptor;

        private CampaignSelector(CampaignDescriptor campaignDescriptor) {
            super(campaignDescriptor.name);
            this.descriptor = campaignDescriptor;
            this.addCallback(this);
        }

        @Override
        public void run() {
            if (CampaignGroupSelector.this.selected != null) {
                CampaignGroupSelector.this.selected.setActive(false);
            }
            CampaignGroupSelector.this.selected = this;
            this.setActive(true);
            CampaignGroupSelector.this.callback.groupSelected(CampaignGroupSelector.this);
        }
    }
}

