/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.mainmenu;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.hale.mainmenu.ConfirmationPopup;
import net.sf.hale.util.SaveGameUtil;

public abstract class AbstractSaveGamePopup
extends PopupWindow {
    private Selector selected;
    private Content content;
    private DateFormat format = new SimpleDateFormat("H:mm:ss dd MMMMM yyyy");

    public AbstractSaveGamePopup(Widget widget) {
        super(widget);
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(true);
        this.content = new Content();
        this.add(this.content);
    }

    public DateFormat getDateFormat() {
        return this.format;
    }

    protected abstract void selectionAccepted(Selector var1);

    protected abstract List<Selector> getValidSelectors();

    protected void setActiveSelector(Selector selector) {
        if (this.selected != null) {
            this.selected.setActive(false);
        }
        this.selected = selector;
        if (this.selected != null) {
            selector.setActive(true);
        }
        this.content.accept.setEnabled(this.selected != null);
    }

    protected void setDeleteEnabled(boolean bl) {
        this.content.delete.setEnabled(bl);
    }

    public static abstract class Selector
    extends ToggleButton {
        public int getPreferredWidth() {
            return Short.MAX_VALUE;
        }

        public boolean checkVersionID() {
            return true;
        }

        public abstract String getSaveGame();
    }

    public class SelectorCallback
    implements Runnable {
        private Selector selector;

        public SelectorCallback(Selector selector) {
            this.selector = selector;
        }

        @Override
        public void run() {
            AbstractSaveGamePopup.this.setActiveSelector(this.selector);
            AbstractSaveGamePopup.this.setDeleteEnabled(true);
        }
    }

    private class DeleteSelectorCallback
    implements Runnable {
        private DeleteSelectorCallback() {
        }

        @Override
        public void run() {
            String string = AbstractSaveGamePopup.this.selected.getSaveGame();
            File file = SaveGameUtil.getSaveFile(string);
            file.delete();
            AbstractSaveGamePopup.this.content.addSelectors();
        }
    }

    private class Content
    extends Widget {
        private Label title = new Label();
        private Button cancel;
        private Button accept;
        private Button delete;
        private ScrollPane selectorPane;
        private DialogLayout selectorPaneContent;
        private int acceptCancelGap;

        private Content() {
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.cancel = new Button();
            this.cancel.setTheme("cancelbutton");
            this.cancel.addCallback(new Runnable(){

                @Override
                public void run() {
                    AbstractSaveGamePopup.this.closePopup();
                }
            });
            this.add((Widget)this.cancel);
            this.accept = new Button();
            this.accept.setTheme("acceptbutton");
            this.accept.addCallback(new Runnable(){

                @Override
                public void run() {
                    AbstractSaveGamePopup.this.selectionAccepted(AbstractSaveGamePopup.this.selected);
                }
            });
            this.add((Widget)this.accept);
            this.delete = new Button();
            this.delete.setTheme("deletebutton");
            this.delete.addCallback(new Runnable(){

                @Override
                public void run() {
                    ConfirmationPopup confirmationPopup = new ConfirmationPopup(Content.this.getParent());
                    confirmationPopup.setTitleText("Delete save file " + AbstractSaveGamePopup.this.selected.getSaveGame() + "?");
                    confirmationPopup.setWarningText("This action is permanent and cannot be undone.");
                    confirmationPopup.addCallback(new DeleteSelectorCallback());
                    confirmationPopup.openPopupCentered();
                }
            });
            this.add((Widget)this.delete);
            this.selectorPaneContent = new DialogLayout();
            this.selectorPaneContent.setTheme("content");
            this.selectorPane = new ScrollPane((Widget)this.selectorPaneContent);
            this.selectorPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
            this.selectorPane.setTheme("selectorpane");
            this.add((Widget)this.selectorPane);
            this.addSelectors();
        }

        private void addSelectors() {
            this.selectorPaneContent.removeAllChildren();
            DialogLayout.Group group = this.selectorPaneContent.createSequentialGroup();
            DialogLayout.Group group2 = this.selectorPaneContent.createParallelGroup();
            for (Selector selector : AbstractSaveGamePopup.this.getValidSelectors()) {
                group.addWidget((Widget)selector);
                group2.addWidget((Widget)selector);
            }
            this.selectorPaneContent.setHorizontalGroup(group2);
            this.selectorPaneContent.setVerticalGroup(group);
            this.accept.setEnabled(false);
            this.delete.setEnabled(false);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.acceptCancelGap = themeInfo.getParameter("acceptCancelGap", 0);
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerX() + this.getWidth() / 2;
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.title.setPosition(n - this.title.getWidth() / 2, this.getInnerY());
            this.cancel.setSize(this.cancel.getPreferredWidth(), this.cancel.getPreferredHeight());
            this.accept.setSize(this.accept.getPreferredWidth(), this.accept.getPreferredHeight());
            this.cancel.setPosition(n + this.acceptCancelGap, this.getInnerBottom() - this.cancel.getHeight());
            this.accept.setPosition(n - this.acceptCancelGap - this.accept.getWidth(), this.getInnerBottom() - this.accept.getHeight());
            this.delete.setSize(this.delete.getPreferredWidth(), this.delete.getPreferredHeight());
            this.delete.setPosition(this.getInnerX(), this.getInnerBottom() - this.delete.getHeight());
            int n2 = Math.min(this.cancel.getY(), this.accept.getY());
            n2 = Math.min(n2, this.delete.getY());
            this.selectorPane.setSize(this.getInnerWidth(), n2 - this.title.getBottom());
            this.selectorPane.setPosition(this.getInnerX(), this.title.getBottom());
        }
    }
}

