/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import net.minidev.json.JSONValue;

public class SaveWriter {
    private static char[] DIGITS = "0123456789".toCharArray();

    private static void appendInt(int n, PrintWriter printWriter) throws IOException {
        if (n < 0) {
            printWriter.append('-');
            n = -n;
        }
        do {
            printWriter.append(DIGITS[n % 10]);
        } while ((n /= 10) > 0);
    }

    private static void writeJSONValue(Object object, PrintWriter printWriter, String string) throws IOException {
        if (object == null) {
            printWriter.append("null");
        } else if (object instanceof String) {
            printWriter.append('\"');
            JSONValue.escape((String)((String)object), (Appendable)printWriter);
            printWriter.append('\"');
        } else if (object instanceof Number) {
            if (object instanceof Double) {
                if (((Double)object).isInfinite()) {
                    printWriter.append("null");
                } else {
                    printWriter.append(object.toString());
                }
            } else if (object instanceof Float) {
                if (((Float)object).isInfinite()) {
                    printWriter.append("null");
                } else {
                    printWriter.append(object.toString());
                }
            } else {
                printWriter.append(object.toString());
            }
        } else if (object instanceof Boolean) {
            printWriter.append(object.toString());
        } else if (object instanceof Map) {
            SaveWriter.writeJSON((Map)object, printWriter, string);
        } else if (object.getClass().isArray()) {
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = clazz.getComponentType();
            boolean bl = false;
            String string2 = string + "  ";
            printWriter.append('[');
            printWriter.println();
            printWriter.append(string2);
            if (clazz2.isPrimitive()) {
                if (clazz2 == Integer.TYPE) {
                    for (int n : (int[])object) {
                        if (bl) {
                            printWriter.append(", ");
                        } else {
                            bl = true;
                        }
                        SaveWriter.appendInt(n, printWriter);
                    }
                } else if (clazz2 == Short.TYPE) {
                    for (short s : (short[])object) {
                        if (bl) {
                            printWriter.append(", ");
                        } else {
                            bl = true;
                        }
                        SaveWriter.appendInt(s, printWriter);
                    }
                } else if (clazz2 == Byte.TYPE) {
                    for (byte by : (byte[])object) {
                        if (bl) {
                            printWriter.append(", ");
                        } else {
                            bl = true;
                        }
                        SaveWriter.appendInt(by, printWriter);
                    }
                } else if (clazz2 == Long.TYPE) {
                    for (long l : (long[])object) {
                        if (bl) {
                            printWriter.append(", ");
                        } else {
                            bl = true;
                        }
                        if (l < 0L) {
                            printWriter.append('-');
                            l = -l;
                        }
                        do {
                            printWriter.append(DIGITS[(int)(l % 10L)]);
                        } while ((l /= 10L) > 0L);
                    }
                } else if (clazz2 == Float.TYPE) {
                    for (float f : (float[])object) {
                        if (bl) {
                            printWriter.append(", ");
                        } else {
                            bl = true;
                        }
                        printWriter.append(Float.toString(f));
                    }
                } else if (clazz2 == Double.TYPE) {
                    for (double d : (double[])object) {
                        if (bl) {
                            printWriter.append(", ");
                        } else {
                            bl = true;
                        }
                        printWriter.append(Double.toString(d));
                    }
                } else if (clazz2 == Boolean.TYPE) {
                    for (boolean bl2 : (boolean[])object) {
                        if (bl) {
                            printWriter.append(", ");
                        } else {
                            bl = true;
                        }
                        if (bl2) {
                            printWriter.append("true");
                            continue;
                        }
                        printWriter.append("false");
                    }
                }
            } else {
                for (Object object2 : (Object[])object) {
                    if (bl) {
                        printWriter.append(", ");
                    } else {
                        bl = true;
                    }
                    SaveWriter.writeJSONValue(object2, printWriter, string2);
                }
            }
            printWriter.println();
            printWriter.append(string);
            printWriter.append(']');
        }
    }

    private static void writeJSON(Map<String, ? extends Object> map, PrintWriter printWriter, String string) throws IOException {
        if (map == null) {
            printWriter.append("null");
            return;
        }
        String string2 = string + "  ";
        boolean bl = true;
        printWriter.append('{');
        printWriter.println();
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                printWriter.append(',');
                printWriter.println();
            }
            printWriter.append(string2);
            String string3 = entry.getKey();
            if (string3 == null) {
                printWriter.append("null");
            } else {
                printWriter.append('\"');
                JSONValue.escape((String)string3, (Appendable)printWriter);
                printWriter.append('\"');
            }
            printWriter.append(" : ");
            SaveWriter.writeJSONValue(entry.getValue(), printWriter, string2);
        }
        printWriter.println();
        printWriter.append(string);
        printWriter.append('}');
    }

    public static void writeJSON(Map<String, ? extends Object> map, PrintWriter printWriter) throws IOException {
        SaveWriter.writeJSON(map, printWriter, "");
    }
}

